/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigNodeIdentitySet
extends ConfigMessage {
    private static final String TAG = ConfigNodeIdentitySet.class.getSimpleName();
    private static final int OP_CODE = 32839;
    private final NetworkKey networkKey;
    private final int nodeIdentityState;

    public ConfigNodeIdentitySet(@NonNull NetworkKey networkKey, int nodeIdentityState) {
        this.networkKey = networkKey;
        this.nodeIdentityState = nodeIdentityState;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32839;
    }

    @Override
    void assembleMessageParameters() {
        Log.d((String)TAG, (String)("Node Identity: " + this.nodeIdentityState));
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.networkKey.getKeyIndex());
        this.mParameters = new byte[]{netKeyIndex[1], (byte)(netKeyIndex[0] & 0xFF & 0xF), (byte)this.nodeIdentityState};
    }
}

