/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;

public final class ConfigRelayStatus
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigRelayStatus.class.getSimpleName();
    private static final int OP_CODE = 32808;
    private int mRelay;
    private int mRelayRetransmitCount;
    private int mRelayRetransmitIntervalSteps;
    public static final Parcelable.Creator<ConfigRelayStatus> CREATOR = new Parcelable.Creator<ConfigRelayStatus>(){

        public ConfigRelayStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigRelayStatus(message);
        }

        public ConfigRelayStatus[] newArray(int size) {
            return new ConfigRelayStatus[size];
        }
    };

    public ConfigRelayStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    public int getOpCode() {
        return 32808;
    }

    @Override
    final void parseStatusParameters() {
        byte[] payload = ((AccessMessage)this.mMessage).getAccessPdu();
        this.mRelay = payload[2];
        this.mRelayRetransmitCount = payload[3] & 7;
        this.mRelayRetransmitIntervalSteps = payload[3] >> 3 & 0x1F;
        Log.d((String)TAG, (String)("Relay: " + this.mRelay));
        Log.d((String)TAG, (String)("Retransmit count: " + this.mRelayRetransmitCount));
        Log.d((String)TAG, (String)("Retransmit Interval steps: " + this.mRelayRetransmitIntervalSteps));
    }

    public int getRelay() {
        return this.mRelay;
    }

    public int getRelayRetransmitCount() {
        return this.mRelayRetransmitCount;
    }

    public int getRelayRetransmitIntervalSteps() {
        return this.mRelayRetransmitIntervalSteps;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

