/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ConfigStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigSigModelSubscriptionList
extends ConfigStatusMessage
implements Parcelable {
    private static final String TAG = ConfigSigModelSubscriptionList.class.getSimpleName();
    private static final int OP_CODE = 32810;
    private int mElementAddress;
    private int mModelIdentifier;
    private final List<Integer> mSubscriptionAddresses = new ArrayList<Integer>();
    private static final Parcelable.Creator<ConfigSigModelSubscriptionList> CREATOR = new Parcelable.Creator<ConfigSigModelSubscriptionList>(){

        public ConfigSigModelSubscriptionList createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new ConfigSigModelSubscriptionList(message);
        }

        public ConfigSigModelSubscriptionList[] newArray(int size) {
            return new ConfigSigModelSubscriptionList[size];
        }
    };

    public ConfigSigModelSubscriptionList(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    final void parseStatusParameters() {
        AccessMessage message = (AccessMessage)this.mMessage;
        this.mStatusCode = this.mParameters[0];
        this.mStatusCodeName = this.getStatusCodeName(this.mStatusCode);
        this.mElementAddress = MeshParserUtils.unsignedBytesToInt(this.mParameters[1], this.mParameters[2]);
        this.mModelIdentifier = MeshParserUtils.unsignedBytesToInt(this.mParameters[3], this.mParameters[4]);
        Log.v((String)TAG, (String)("Status code: " + this.mStatusCode));
        Log.v((String)TAG, (String)("Status message: " + this.mStatusCodeName));
        Log.v((String)TAG, (String)("Element Address: " + MeshAddress.formatAddress(this.mElementAddress, true)));
        Log.v((String)TAG, (String)("Model Identifier: " + Integer.toHexString(this.mModelIdentifier)));
        for (int i = 5; i < this.mParameters.length; i += 2) {
            int address = MeshParserUtils.unsignedBytesToInt(this.mParameters[i], this.mParameters[i + 1]);
            this.mSubscriptionAddresses.add(address);
            Log.v((String)TAG, (String)("Subscription Address: " + MeshAddress.formatAddress(address, false)));
        }
    }

    @Override
    public int getOpCode() {
        return 32810;
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public List<Integer> getSubscriptionAddresses() {
        return this.mSubscriptionAddresses;
    }

    public final int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public final boolean isSuccessful() {
        return this.mStatusCode == 0;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

