/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public final class ConfigVendorModelSubscriptionGet
extends ConfigMessage {
    private static final String TAG = ConfigVendorModelSubscriptionGet.class.getSimpleName();
    private static final int OP_CODE = 32811;
    private static final int VENDOR_MODEL_SUBSCRIPTION_GET_LENGTH = 6;
    private final int mElementAddress;
    private final int mModelIdentifier;

    public ConfigVendorModelSubscriptionGet(int elementAddress, int modelIdentifier) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.mElementAddress = elementAddress;
        this.mModelIdentifier = modelIdentifier;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32811;
    }

    @Override
    void assembleMessageParameters() {
        byte[] elementAddress = MeshAddress.addressIntToBytes(this.mElementAddress);
        ByteBuffer paramsBuffer = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.putShort((short)this.mElementAddress);
        byte[] modelIdentifier = new byte[]{(byte)(this.mModelIdentifier >> 24 & 0xFF), (byte)(this.mModelIdentifier >> 16 & 0xFF), (byte)(this.mModelIdentifier >> 8 & 0xFF), (byte)(this.mModelIdentifier & 0xFF)};
        paramsBuffer.put(modelIdentifier[1]);
        paramsBuffer.put(modelIdentifier[0]);
        paramsBuffer.put(modelIdentifier[3]);
        paramsBuffer.put(modelIdentifier[2]);
        this.mParameters = paramsBuffer.array();
    }
}

