/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class LightLCLightOnOffStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = LightLCLightOnOffStatus.class.getSimpleName();
    private static final int OP_CODE = 33436;
    private static final int GENERIC_ON_OFF_STATE_ON = 1;
    private boolean mPresentOn;
    private Boolean mTargetOn;
    private int mRemainingTime;
    private int mTransitionSteps;
    private int mTransitionResolution;
    private static final Parcelable.Creator<LightLCLightOnOffStatus> CREATOR = new Parcelable.Creator<LightLCLightOnOffStatus>(){

        public LightLCLightOnOffStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new LightLCLightOnOffStatus(message);
        }

        public LightLCLightOnOffStatus[] newArray(int size) {
            return new LightLCLightOnOffStatus[size];
        }
    };

    public LightLCLightOnOffStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        Log.v((String)TAG, (String)("Received light lc light on off status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true)));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        this.mPresentOn = buffer.get() == 1;
        Log.v((String)TAG, (String)("Present on: " + this.mPresentOn));
        if (buffer.limit() > 1) {
            this.mTargetOn = buffer.get() == 1;
            this.mRemainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = this.mRemainingTime & 0x3F;
            this.mTransitionResolution = this.mRemainingTime >> 6;
            Log.v((String)TAG, (String)("Target on: " + this.mTargetOn));
            Log.v((String)TAG, (String)("Remaining time, transition number of steps: " + this.mTransitionSteps));
            Log.v((String)TAG, (String)("Remaining time, transition number of step resolution: " + this.mTransitionResolution));
            Log.v((String)TAG, (String)("Remaining time: " + MeshParserUtils.getRemainingTime(this.mRemainingTime)));
        }
    }

    @Override
    public int getOpCode() {
        return 33436;
    }

    public final boolean getPresentState() {
        return this.mPresentOn;
    }

    public final Boolean getTargetState() {
        return this.mTargetOn;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public int getRemainingTime() {
        return this.mRemainingTime;
    }
}

