/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class SensorColumnGet
extends ApplicationMessage {
    private static final String TAG = SensorColumnGet.class.getSimpleName();
    private static final int OP_CODE = 33330;
    private final DeviceProperty property;
    private final byte[] rawValueX;

    public SensorColumnGet(@NonNull ApplicationKey appKey, @NonNull DeviceProperty property, @NonNull byte[] rawValueX) {
        super(appKey);
        this.property = property;
        this.rawValueX = rawValueX;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33330;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        this.mParameters = ByteBuffer.allocate(2 + this.rawValueX.length).order(ByteOrder.LITTLE_ENDIAN).putShort(this.property.getPropertyId()).put(this.rawValueX).array();
    }
}

