/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.sensorutils.StatusTriggerDelta;
import no.nordicsemi.android.mesh.sensorutils.StatusTriggerType;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public abstract class SensorMessage
extends ApplicationStatusMessage {
    SensorMessage(@NonNull AccessMessage message) {
        super(message);
    }

    public class SensorCadence {
        private final DeviceProperty deviceProperty;
        private int periodDivisor;
        private StatusTriggerType triggerType;
        private int statusMinInterval;
        private StatusTriggerDelta<?> delta;
        private DevicePropertyCharacteristic<?> fastCadenceLow;
        private DevicePropertyCharacteristic<?> fastCadenceHigh;

        public SensorCadence(DeviceProperty property, @NonNull int periodDivisor, @NonNull StatusTriggerType triggerType, @NonNull StatusTriggerDelta<?> delta, @NonNull DevicePropertyCharacteristic<?> fastCadenceLow, DevicePropertyCharacteristic<?> fastCadenceHigh, int statusMinInterval) {
            this.deviceProperty = property;
            this.periodDivisor = periodDivisor;
            this.triggerType = triggerType;
            this.delta = delta;
            this.statusMinInterval = statusMinInterval;
            this.fastCadenceLow = fastCadenceLow;
            this.fastCadenceHigh = fastCadenceHigh;
        }

        SensorCadence(@NonNull DeviceProperty deviceProperty, byte[] data) {
            int offset = 2;
            this.deviceProperty = deviceProperty;
            if (data.length > 2) {
                this.periodDivisor = data[offset++] & 0xFF;
                this.triggerType = StatusTriggerType.from(data[offset++] & 0xFF);
                int length = this.triggerType.ordinal() == 0 ? (data.length - offset - 4) / 4 : (data.length - offset - 8) / 2;
                switch (this.triggerType) {
                    default: {
                        DevicePropertyCharacteristic<?> down = DeviceProperty.getCharacteristic(deviceProperty, data, offset, length);
                        DevicePropertyCharacteristic<?> up = DeviceProperty.getCharacteristic(deviceProperty, data, offset + length, length);
                        this.delta = new StatusTriggerDelta.Characteristic(down, up);
                        offset += length * 2;
                        break;
                    }
                    case UNIT_LESS: {
                        this.delta = new StatusTriggerDelta.Percent((float)MeshParserUtils.unsignedBytesToInt(data[offset + 2], data[offset + 3]) / 100.0f, (float)MeshParserUtils.unsignedBytesToInt(data[offset], data[offset + 1]) / 100.0f);
                        offset += 4;
                    }
                }
                this.statusMinInterval = data[offset++] & 0xFF;
                this.fastCadenceLow = DeviceProperty.getCharacteristic(deviceProperty, data, offset, length);
                this.fastCadenceHigh = DeviceProperty.getCharacteristic(deviceProperty, data, offset + length, length);
            }
        }

        public DeviceProperty getDeviceProperty() {
            return this.deviceProperty;
        }

        public int getPeriodDivisor() {
            return this.periodDivisor;
        }

        @Nullable
        public StatusTriggerType getTriggerType() {
            return this.triggerType;
        }

        @Nullable
        public StatusTriggerDelta<?> getDelta() {
            return this.delta;
        }

        public int getStatusMinInterval() {
            return this.statusMinInterval;
        }

        @Nullable
        public DevicePropertyCharacteristic<?> getFastCadenceLow() {
            return this.fastCadenceLow;
        }

        @Nullable
        public DevicePropertyCharacteristic<?> getFastCadenceHigh() {
            return this.fastCadenceHigh;
        }

        protected byte[] toBytes() {
            byte[] data = new byte[3 + this.delta.getLength() + 1 + this.fastCadenceLow.getLength() + this.fastCadenceHigh.getLength()];
            ByteBuffer buffer = ByteBuffer.allocate(data.length).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(this.deviceProperty.getPropertyId());
            buffer.put((byte)(this.periodDivisor << 7 | this.triggerType.ordinal()));
            if (this.triggerType == StatusTriggerType.SENSOR_PROPERTY_ID_FORMAT_TYPE) {
                buffer.put(((DevicePropertyCharacteristic)this.delta.getDown()).getBytes());
                buffer.put(((DevicePropertyCharacteristic)this.delta.getUp()).getBytes());
            } else {
                buffer.putShort(((Float)((StatusTriggerDelta.Percent)this.delta).getDown()).shortValue());
                buffer.putShort(((Float)((StatusTriggerDelta.Percent)this.delta).getUp()).shortValue());
            }
            return data;
        }
    }
}

