/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class SensorSeriesGet
extends ApplicationMessage {
    private static final String TAG = SensorSeriesGet.class.getSimpleName();
    private static final int OP_CODE = 33331;
    private final DeviceProperty property;
    private byte[] rawValueX1;
    private byte[] rawValueX2;

    public SensorSeriesGet(@NonNull ApplicationKey appKey, @NonNull DeviceProperty property) {
        super(appKey);
        this.property = property;
    }

    public SensorSeriesGet(@NonNull ApplicationKey appKey, @NonNull DeviceProperty property, @NonNull byte[] rawValueX1, @NonNull byte[] rawValueX2) {
        super(appKey);
        this.property = property;
        this.rawValueX1 = rawValueX1;
        this.rawValueX2 = rawValueX2;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33331;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        this.mParameters = this.rawValueX1 != null ? ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(this.property.getPropertyId()).array() : ByteBuffer.allocate(2 + this.rawValueX1.length + this.rawValueX2.length).order(ByteOrder.LITTLE_ENDIAN).putShort(this.property.getPropertyId()).put(this.rawValueX1).put(this.rawValueX2).array();
    }
}

