/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.sensorutils.SensorSettingAccess;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.transport.SceneStatuses;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class SensorSettingStatus
extends ApplicationStatusMessage
implements Parcelable,
SceneStatuses {
    private static final String TAG = SensorSettingStatus.class.getSimpleName();
    private static final int OP_CODE = 91;
    private DeviceProperty propertyId;
    private DeviceProperty sensorSettingPropertyId;
    private SensorSettingAccess sensorSettingAccess;
    private DevicePropertyCharacteristic<?> sensorSetting;
    private static final Parcelable.Creator<SensorSettingStatus> CREATOR = new Parcelable.Creator<SensorSettingStatus>(){

        public SensorSettingStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SensorSettingStatus(message);
        }

        public SensorSettingStatus[] newArray(int size) {
            return new SensorSettingStatus[size];
        }
    };

    public SensorSettingStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        this.propertyId = DeviceProperty.from((short)MeshParserUtils.unsignedBytesToInt(this.mParameters[0], this.mParameters[1]));
        this.sensorSettingPropertyId = DeviceProperty.from((short)MeshParserUtils.unsignedBytesToInt(this.mParameters[2], this.mParameters[3]));
        if (this.mParameters.length > 4) {
            this.sensorSettingAccess = SensorSettingAccess.from(this.mParameters[4] & 0xFF);
            this.sensorSetting = DeviceProperty.getCharacteristic(this.sensorSettingPropertyId, this.mParameters, 5, this.mParameters.length - 5);
        }
    }

    @Override
    public int getOpCode() {
        return 91;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public DeviceProperty getPropertyId() {
        return this.propertyId;
    }

    public DeviceProperty getSensorSettingPropertyId() {
        return this.sensorSettingPropertyId;
    }

    public SensorSettingAccess getSensorSettingAccess() {
        return this.sensorSettingAccess;
    }

    public DevicePropertyCharacteristic<?> getSensorSetting() {
        return this.sensorSetting;
    }
}

