/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.transport.SceneStatuses;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class SensorSettingsStatus
extends ApplicationStatusMessage
implements Parcelable,
SceneStatuses {
    private static final String TAG = SensorSettingsStatus.class.getSimpleName();
    private static final int OP_CODE = 88;
    private DeviceProperty propertyId;
    private DeviceProperty[] sensorSettingPropertyId;
    private static final Parcelable.Creator<SensorSettingsStatus> CREATOR = new Parcelable.Creator<SensorSettingsStatus>(){

        public SensorSettingsStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SensorSettingsStatus(message);
        }

        public SensorSettingsStatus[] newArray(int size) {
            return new SensorSettingsStatus[size];
        }
    };

    public SensorSettingsStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        this.propertyId = DeviceProperty.from((short)MeshParserUtils.unsignedBytesToInt(this.mParameters[0], this.mParameters[1]));
        int offset = 2;
        this.sensorSettingPropertyId = new DeviceProperty[(this.mParameters.length - offset) / 2];
        for (int i = 0; i < this.sensorSettingPropertyId.length; ++i) {
            this.sensorSettingPropertyId[i] = DeviceProperty.from((short)MeshParserUtils.unsignedBytesToInt(this.mParameters[offset], this.mParameters[offset + 1]));
            offset += 2;
        }
    }

    @Override
    public int getOpCode() {
        return 88;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public DeviceProperty getPropertyId() {
        return this.propertyId;
    }

    public DeviceProperty[] getSensorSettingPropertyIds() {
        return this.sensorSettingPropertyId;
    }
}

