/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;

public class ConfigModelPublicationSetParams {
    private final ProvisionedMeshNode meshNode;
    private final byte[] elementAddress;
    private final byte[] publishAddress;
    private final int appKeyIndex;
    private int aszmic;
    private boolean credentialFlag;
    private int publishTtl;
    private int publicationSteps;
    private int publicationResolution;
    private int publishRetransmitCount;
    private int publishRetransmitIntervalSteps;
    private int modelIdentifier;

    public ConfigModelPublicationSetParams(@NonNull ProvisionedMeshNode mProvisionedMeshNode, @NonNull byte[] elementAddress, int modelIdentifier, @NonNull byte[] publishAddress, int appKeyIndex) throws IllegalArgumentException {
        this.meshNode = mProvisionedMeshNode;
        if (elementAddress.length != 2) {
            throw new IllegalArgumentException("Element address must be 2 bytes");
        }
        this.elementAddress = elementAddress;
        this.modelIdentifier = modelIdentifier;
        if (publishAddress.length != 2) {
            throw new IllegalArgumentException("Publish address must be 2 bytes");
        }
        this.publishAddress = publishAddress;
        this.appKeyIndex = appKeyIndex;
    }

    public byte[] getElementAddress() {
        return this.elementAddress;
    }

    public byte[] getPublishAddress() {
        return this.publishAddress;
    }

    public int getAppKeyIndex() {
        return this.appKeyIndex;
    }

    public int getAszmic() {
        return this.aszmic;
    }

    public boolean getCredentialFlag() {
        return this.credentialFlag;
    }

    public int getPublishTtl() {
        return this.publishTtl;
    }

    public int getPublicationSteps() {
        return this.publicationSteps;
    }

    public int getPublicationResolution() {
        return this.publicationResolution;
    }

    public int getPublishRetransmitCount() {
        return this.publishRetransmitCount;
    }

    public int getPublishRetransmitIntervalSteps() {
        return this.publishRetransmitIntervalSteps;
    }

    public int getModelIdentifier() {
        return this.modelIdentifier;
    }

    public void setCredentialFlag(boolean credentialFlag) {
        this.credentialFlag = credentialFlag;
    }

    public void setPublishTtl(int publishTtl) {
        this.publishTtl = publishTtl;
    }

    public void setPublicationSteps(int publicationSteps) {
        this.publicationSteps = publicationSteps;
    }

    public void setPublicationResolution(int publicationResolution) {
        this.publicationResolution = publicationResolution;
    }

    public void setPublishRetransmitCount(int publisRetransmitCount) {
        this.publishRetransmitCount = publisRetransmitCount;
    }

    public void setPublishRetransmitIntervalSteps(int retransmitIntervalSteps) {
        this.publishRetransmitIntervalSteps = retransmitIntervalSteps;
    }

    public ProvisionedMeshNode getMeshNode() {
        return this.meshNode;
    }
}

