/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

public enum PublicKeyOOB {
    PUBLIC_KEY_INFORMATION_AVAILABLE(1);

    private static final String TAG;
    private short algorithmType;

    private PublicKeyOOB(short algorithmType) {
        this.algorithmType = algorithmType;
    }

    public short getAlgorithmType() {
        return this.algorithmType;
    }

    public static PublicKeyOOB getPublicKeyOOBFromBitMask(byte rawPublicKeyType) {
        PublicKeyOOB[] publicKeyOOBS;
        for (PublicKeyOOB publicKeyOOB : publicKeyOOBS = new PublicKeyOOB[]{PUBLIC_KEY_INFORMATION_AVAILABLE}) {
            if ((rawPublicKeyType & publicKeyOOB.ordinal()) != publicKeyOOB.ordinal()) continue;
            return publicKeyOOB;
        }
        return null;
    }

    public static String getPublicKeyInformationDescription(PublicKeyOOB type) {
        switch (type) {
            case PUBLIC_KEY_INFORMATION_AVAILABLE: {
                return "FIPS P-256 Elliptic Curve";
            }
        }
        return "Prohibited";
    }

    static {
        TAG = PublicKeyOOB.class.getSimpleName();
    }
}

