/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import no.nordicsemi.android.mesh.SecureNetworkBeacon;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.InvalidCipherTextException;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.engines.AESLightEngine;
import org.spongycastle.crypto.macs.CMac;
import org.spongycastle.crypto.modes.CCMBlockCipher;
import org.spongycastle.crypto.params.AEADParameters;
import org.spongycastle.crypto.params.KeyParameter;

public class SecureUtils {
    public static final byte[] PRCK = "prck".getBytes(Charset.forName("US-ASCII"));
    public static final byte[] PRSK = "prsk".getBytes(Charset.forName("US-ASCII"));
    public static final byte[] PRSN = "prsn".getBytes(Charset.forName("US-ASCII"));
    public static final byte[] PRDK = "prdk".getBytes(Charset.forName("US-ASCII"));
    public static final byte[] K2_MASTER_INPUT = new byte[]{0};
    public static final byte[] SMK2 = "smk2".getBytes(Charset.forName("US-ASCII"));
    public static final byte[] SMK3 = "smk3".getBytes(Charset.forName("US-ASCII"));
    public static final byte[] SMK3_DATA = "id64".getBytes(Charset.forName("US-ASCII"));
    public static final int ENC_K3_OUTPUT_MASK = 127;
    public static final byte[] SMK4 = "smk4".getBytes(Charset.forName("US-ASCII"));
    public static final byte[] SMK4_DATA = "id6".getBytes(Charset.forName("US-ASCII"));
    public static final int ENC_K4_OUTPUT_MASK = 63;
    protected static final byte[] SALT_KEY = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    protected static final byte[] NONCE_PADDING = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final String TAG = SecureUtils.class.getSimpleName();
    private static final byte[] NKIK = "nkik".getBytes(Charset.forName("US-ASCII"));
    private static final byte[] NKBK = "nkbk".getBytes(Charset.forName("US-ASCII"));
    private static final byte[] ID128 = "id128".getBytes(Charset.forName("US-ASCII"));
    private static final byte[] HASH_PADDING = new byte[]{0, 0, 0, 0, 0, 0};
    private static final int HASH_LENGTH = 8;
    public static int NRF_MESH_KEY_SIZE = 16;

    public static byte[] generateRandomNumber() {
        SecureRandom random = new SecureRandom();
        byte[] randomBytes = new byte[16];
        random.nextBytes(randomBytes);
        return randomBytes;
    }

    public static String generateRandomNetworkKey() {
        byte[] networkKey = SecureUtils.generateRandomNumber();
        return MeshParserUtils.bytesToHex(networkKey, false);
    }

    public static String generateRandomApplicationKey() {
        return MeshParserUtils.bytesToHex(SecureUtils.generateRandomNumber(), false);
    }

    public static byte[] calculateSalt(byte[] data) {
        return SecureUtils.calculateCMAC(data, SALT_KEY);
    }

    public static byte[] calculateCMAC(byte[] data, byte[] key) {
        byte[] cmac = new byte[16];
        KeyParameter cipherParameters = new KeyParameter(key);
        AESEngine blockCipher = new AESEngine();
        CMac mac = new CMac((BlockCipher)blockCipher);
        mac.init((CipherParameters)cipherParameters);
        mac.update(data, 0, data.length);
        mac.doFinal(cmac, 0);
        return cmac;
    }

    public static byte[] encryptCCM(@NonNull byte[] data, @NonNull byte[] key, @NonNull byte[] nonce, int micSize) {
        byte[] ccm = new byte[data.length + micSize];
        CCMBlockCipher ccmBlockCipher = new CCMBlockCipher((BlockCipher)new AESEngine());
        AEADParameters aeadParameters = new AEADParameters(new KeyParameter(key), micSize * 8, nonce);
        ccmBlockCipher.init(true, (CipherParameters)aeadParameters);
        ccmBlockCipher.processBytes(data, 0, data.length, ccm, data.length);
        try {
            ccmBlockCipher.doFinal(ccm, 0);
            return ccm;
        }
        catch (InvalidCipherTextException e) {
            Log.e((String)TAG, (String)("Error wile encrypting: " + e.getMessage()));
            return null;
        }
    }

    public static byte[] encryptCCM(@NonNull byte[] data, @NonNull byte[] key, @NonNull byte[] nonce, @NonNull byte[] additionalData, int micSize) {
        byte[] ccm = new byte[data.length + micSize];
        CCMBlockCipher ccmBlockCipher = new CCMBlockCipher((BlockCipher)new AESEngine());
        AEADParameters aeadParameters = new AEADParameters(new KeyParameter(key), micSize * 8, nonce, additionalData);
        ccmBlockCipher.init(true, (CipherParameters)aeadParameters);
        ccmBlockCipher.processBytes(data, 0, data.length, ccm, data.length);
        try {
            ccmBlockCipher.doFinal(ccm, 0);
            return ccm;
        }
        catch (InvalidCipherTextException e) {
            Log.e((String)TAG, (String)("Error wile encrypting: " + e.getMessage()));
            return null;
        }
    }

    public static byte[] decryptCCM(@NonNull byte[] data, @NonNull byte[] key, @NonNull byte[] nonce, int micSize) throws InvalidCipherTextException {
        byte[] ccm = new byte[data.length - micSize];
        CCMBlockCipher ccmBlockCipher = new CCMBlockCipher((BlockCipher)new AESEngine());
        AEADParameters aeadParameters = new AEADParameters(new KeyParameter(key), micSize * 8, nonce);
        ccmBlockCipher.init(false, (CipherParameters)aeadParameters);
        ccmBlockCipher.processBytes(data, 0, data.length, ccm, 0);
        ccmBlockCipher.doFinal(ccm, 0);
        return ccm;
    }

    public static byte[] decryptCCM(@NonNull byte[] data, @NonNull byte[] key, @NonNull byte[] nonce, @NonNull byte[] additionalData, int micSize) throws InvalidCipherTextException {
        byte[] ccm = new byte[data.length - micSize];
        CCMBlockCipher ccmBlockCipher = new CCMBlockCipher((BlockCipher)new AESEngine());
        AEADParameters aeadParameters = new AEADParameters(new KeyParameter(key), micSize * 8, nonce, additionalData);
        ccmBlockCipher.init(false, (CipherParameters)aeadParameters);
        ccmBlockCipher.processBytes(data, 0, data.length, ccm, 0);
        ccmBlockCipher.doFinal(ccm, 0);
        return ccm;
    }

    public static byte[] calculateK1(byte[] ecdh, byte[] confirmationSalt, byte[] text) {
        return SecureUtils.calculateCMAC(text, SecureUtils.calculateCMAC(ecdh, confirmationSalt));
    }

    public static K2Output calculateK2(byte[] data, byte[] p) {
        if (data == null || p == null) {
            return null;
        }
        byte[] salt = SecureUtils.calculateSalt(SMK2);
        byte[] t = SecureUtils.calculateCMAC(data, salt);
        byte[] t0 = new byte[]{};
        ByteBuffer inputBufferT0 = ByteBuffer.allocate(t0.length + p.length + 1);
        inputBufferT0.put(t0);
        inputBufferT0.put(p);
        inputBufferT0.put((byte)1);
        byte[] t1 = SecureUtils.calculateCMAC(inputBufferT0.array(), t);
        byte nid = (byte)(t1[15] & 0x7F);
        ByteBuffer inputBufferT1 = ByteBuffer.allocate(t1.length + p.length + 1);
        inputBufferT1.put(t1);
        inputBufferT1.put(p);
        inputBufferT1.put((byte)2);
        byte[] encryptionKey = SecureUtils.calculateCMAC(inputBufferT1.array(), t);
        ByteBuffer inputBufferT2 = ByteBuffer.allocate(encryptionKey.length + p.length + 1);
        inputBufferT2.put(encryptionKey);
        inputBufferT2.put(p);
        inputBufferT2.put((byte)3);
        byte[] privacyKey = SecureUtils.calculateCMAC(inputBufferT2.array(), t);
        return new K2Output(nid, encryptionKey, privacyKey);
    }

    public static byte[] calculateK3(byte[] n) {
        if (n == null) {
            return null;
        }
        byte[] salt = SecureUtils.calculateSalt(SMK3);
        byte[] t = SecureUtils.calculateCMAC(n, salt);
        ByteBuffer buffer = ByteBuffer.allocate(SMK3_DATA.length + 1);
        buffer.put(SMK3_DATA);
        buffer.put((byte)1);
        byte[] cmacInput = buffer.array();
        byte[] result = SecureUtils.calculateCMAC(cmacInput, t);
        byte[] networkId = new byte[8];
        int srcOffset = result.length - networkId.length;
        System.arraycopy(result, srcOffset, networkId, 0, networkId.length);
        return networkId;
    }

    public static byte calculateK4(byte[] n) {
        if (n == null || n.length != 16) {
            throw new IllegalArgumentException("Key cannot be empty and must be 16-bytes long.");
        }
        byte[] salt = SecureUtils.calculateSalt(SMK4);
        byte[] t = SecureUtils.calculateCMAC(n, salt);
        ByteBuffer buffer = ByteBuffer.allocate(SMK4_DATA.length + 1);
        buffer.put(SMK4_DATA);
        buffer.put((byte)1);
        byte[] cmacInput = buffer.array();
        byte[] result = SecureUtils.calculateCMAC(cmacInput, t);
        return (byte)(result[15] & 0x3F);
    }

    public static byte[] calculateIdentityKey(byte[] n) {
        if (n == null) {
            return null;
        }
        byte[] salt = SecureUtils.calculateSalt(NKIK);
        ByteBuffer buffer = ByteBuffer.allocate(ID128.length + 1);
        buffer.put(ID128);
        buffer.put((byte)1);
        byte[] p = buffer.array();
        return SecureUtils.calculateK1(n, salt, p);
    }

    public static byte[] calculateBeaconKey(byte[] n) {
        byte[] salt = SecureUtils.calculateSalt(NKBK);
        ByteBuffer buffer = ByteBuffer.allocate(ID128.length + 1);
        buffer.put(ID128);
        buffer.put((byte)1);
        byte[] p = buffer.array();
        return SecureUtils.calculateK1(n, salt, p);
    }

    public static byte[] calculateAuthValueSecureNetBeacon(@NonNull byte[] n, int flags, @NonNull byte[] networkId, int ivIndex) {
        int inputLength = 1 + networkId.length + 4;
        ByteBuffer pBuffer = ByteBuffer.allocate(inputLength);
        pBuffer.put((byte)flags);
        pBuffer.put(networkId);
        pBuffer.putInt(ivIndex);
        byte[] beaconKey = SecureUtils.calculateBeaconKey(n);
        return SecureUtils.calculateCMAC(pBuffer.array(), beaconKey);
    }

    public static SecureNetworkBeacon createSecureNetworkBeacon(@NonNull byte[] n, int flags, @NonNull byte[] networkId, int ivIndex) {
        byte[] authentication = SecureUtils.calculateAuthValueSecureNetBeacon(n, flags, networkId, ivIndex);
        int inputLength = 1 + networkId.length + 4;
        ByteBuffer pBuffer = ByteBuffer.allocate(inputLength);
        pBuffer.put((byte)flags);
        pBuffer.put(networkId);
        pBuffer.putInt(ivIndex);
        ByteBuffer secNetBeaconBuffer = ByteBuffer.allocate(1 + inputLength + 8);
        secNetBeaconBuffer.put((byte)1);
        secNetBeaconBuffer.put(pBuffer.array());
        secNetBeaconBuffer.put(authentication, 0, 8);
        return new SecureNetworkBeacon(secNetBeaconBuffer.array());
    }

    public static byte[] calculateSecureNetworkBeacon(@NonNull byte[] n, int beaconType, int flags, @NonNull byte[] networkId, int ivIndex) {
        byte[] authentication = SecureUtils.calculateAuthValueSecureNetBeacon(n, flags, networkId, ivIndex);
        int inputLength = 1 + networkId.length + 4;
        ByteBuffer pBuffer = ByteBuffer.allocate(inputLength);
        pBuffer.put((byte)flags);
        pBuffer.put(networkId);
        pBuffer.putInt(ivIndex);
        ByteBuffer secNetBeaconBuffer = ByteBuffer.allocate(1 + inputLength + 8);
        secNetBeaconBuffer.put((byte)beaconType);
        secNetBeaconBuffer.put(pBuffer.array());
        secNetBeaconBuffer.put(authentication, 0, 8);
        return secNetBeaconBuffer.array();
    }

    public static byte[] calculateHash(byte[] identityKey, byte[] random, byte[] src) {
        int length = HASH_PADDING.length + random.length + src.length;
        ByteBuffer bufferHashInput = ByteBuffer.allocate(length).order(ByteOrder.BIG_ENDIAN);
        bufferHashInput.put(HASH_PADDING);
        bufferHashInput.put(random);
        bufferHashInput.put(src);
        byte[] hashInput = bufferHashInput.array();
        byte[] hash = SecureUtils.encryptWithAES(hashInput, identityKey);
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN);
        buffer.put(hash, 8, 8);
        return buffer.array();
    }

    public static byte[] encryptWithAES(byte[] data, byte[] key) {
        byte[] encrypted = new byte[data.length];
        KeyParameter cipherParameters = new KeyParameter(key);
        AESLightEngine engine = new AESLightEngine();
        engine.init(true, (CipherParameters)cipherParameters);
        engine.processBlock(data, 0, encrypted, 0);
        return encrypted;
    }

    public static int getNetMicLength(int ctl) {
        if (ctl == 0) {
            return 4;
        }
        return 8;
    }

    public static int getTransMicLength(int aszmic) {
        if (aszmic == 0) {
            return 4;
        }
        return 8;
    }

    public static class K2Output
    implements Parcelable {
        public static final Parcelable.Creator<K2Output> CREATOR = new Parcelable.Creator<K2Output>(){

            public K2Output createFromParcel(Parcel in) {
                return new K2Output(in);
            }

            public K2Output[] newArray(int size) {
                return new K2Output[size];
            }
        };
        @Expose
        private byte nid;
        @Expose
        private byte[] encryptionKey;
        @Expose
        private byte[] privacyKey;

        private K2Output(byte nid, byte[] encryptionKey, byte[] privacyKey) {
            this.nid = nid;
            this.encryptionKey = encryptionKey;
            this.privacyKey = privacyKey;
        }

        protected K2Output(Parcel in) {
            this.nid = in.readByte();
            this.encryptionKey = in.createByteArray();
            this.privacyKey = in.createByteArray();
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeByte(this.nid);
            dest.writeByteArray(this.encryptionKey);
            dest.writeByteArray(this.privacyKey);
        }

        public int describeContents() {
            return 0;
        }

        public byte getNid() {
            return this.nid;
        }

        public byte[] getEncryptionKey() {
            return this.encryptionKey;
        }

        public byte[] getPrivacyKey() {
            return this.privacyKey;
        }
    }
}

