/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Collections;
import java.util.List;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.data.ApplicationKeyDao;

public final class ApplicationKeyDao_Impl
implements ApplicationKeyDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ApplicationKey> __insertionAdapterOfApplicationKey;
    private final EntityDeletionOrUpdateAdapter<ApplicationKey> __deletionAdapterOfApplicationKey;
    private final EntityDeletionOrUpdateAdapter<ApplicationKey> __updateAdapterOfApplicationKey;

    public ApplicationKeyDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfApplicationKey = new EntityInsertionAdapter<ApplicationKey>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `application_key` (`id`,`mesh_uuid`,`index`,`name`,`key`,`old_key`,`bound_key_index`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, ApplicationKey value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshUuid());
                }
                stmt.bindLong(3, (long)value.getKeyIndex());
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                if (value.getKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, value.getKey());
                }
                if (value.getOldKey() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindBlob(6, value.getOldKey());
                }
                stmt.bindLong(7, (long)value.getBoundNetKeyIndex());
            }
        };
        this.__deletionAdapterOfApplicationKey = new EntityDeletionOrUpdateAdapter<ApplicationKey>(__db){

            public String createQuery() {
                return "DELETE FROM `application_key` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ApplicationKey value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfApplicationKey = new EntityDeletionOrUpdateAdapter<ApplicationKey>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `application_key` SET `id` = ?,`mesh_uuid` = ?,`index` = ?,`name` = ?,`key` = ?,`old_key` = ?,`bound_key_index` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, ApplicationKey value) {
                stmt.bindLong(1, (long)value.getId());
                if (value.getMeshUuid() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshUuid());
                }
                stmt.bindLong(3, (long)value.getKeyIndex());
                if (value.getName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getName());
                }
                if (value.getKey() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindBlob(5, value.getKey());
                }
                if (value.getOldKey() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindBlob(6, value.getOldKey());
                }
                stmt.bindLong(7, (long)value.getBoundNetKeyIndex());
                stmt.bindLong(8, (long)value.getId());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(ApplicationKey applicationKey) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfApplicationKey.insertAndReturnId((Object)applicationKey);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(ApplicationKey applicationKey) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfApplicationKey.handle((Object)applicationKey);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(ApplicationKey applicationKey) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfApplicationKey.handle((Object)applicationKey);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

