/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import java.util.Arrays;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.transport.SceneStatuses;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class SensorColumnStatus
extends ApplicationStatusMessage
implements Parcelable,
SceneStatuses {
    private static final String TAG = SensorColumnStatus.class.getSimpleName();
    private static final int OP_CODE = 83;
    private DeviceProperty propertyId;
    private byte[] result;
    private static final Parcelable.Creator<SensorColumnStatus> CREATOR = new Parcelable.Creator<SensorColumnStatus>(){

        public SensorColumnStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SensorColumnStatus(message);
        }

        public SensorColumnStatus[] newArray(int size) {
            return new SensorColumnStatus[size];
        }
    };

    public SensorColumnStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        this.propertyId = DeviceProperty.from((short)MeshParserUtils.unsignedBytesToInt(this.mParameters[0], this.mParameters[1]));
        if (this.mParameters.length > 2) {
            this.result = Arrays.copyOfRange(this.mParameters, 2, this.mParameters.length);
        }
    }

    @Override
    public int getOpCode() {
        return 83;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public DeviceProperty getPropertyId() {
        return this.propertyId;
    }

    public byte[] getResult() {
        return this.result;
    }
}

