/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.TypeConverter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.IvIndex;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.ElementDbMigrator;
import no.nordicsemi.android.mesh.transport.InternalMeshModelDeserializer;
import no.nordicsemi.android.mesh.transport.MeshModel;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class MeshTypeConverters {
    @TypeConverter
    public static Map<Integer, ApplicationKey> fromJsonToAddedAppKeys(String appKeyJson) {
        Type addedAppKeys = new TypeToken<Map<Integer, ApplicationKey>>(){}.getType();
        return (Map)new Gson().fromJson(appKeyJson, addedAppKeys);
    }

    @TypeConverter
    public static List<NetworkKey> fromJsonToAddedNetKeys(String networkKeyJson) {
        Type addedNetKeys = new TypeToken<List<NetworkKey>>(){}.getType();
        return (List)new Gson().fromJson(networkKeyJson, addedNetKeys);
    }

    @TypeConverter
    public static String elementsToJson(Map<Integer, Element> elements) {
        return new Gson().toJson(elements);
    }

    @TypeConverter
    public Map<Integer, Element> fromJsonToElements(String elementsJson) {
        Type elements = new TypeToken<Map<Integer, Element>>(){}.getType();
        return (Map)new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Element.class, (Object)new ElementDbMigrator()).registerTypeAdapter(MeshModel.class, (Object)new InternalMeshModelDeserializer()).create().fromJson(elementsJson, elements);
    }

    @TypeConverter
    public static String allocatedGroupRangeToJson(List<AllocatedGroupRange> ranges) {
        return new Gson().toJson(ranges);
    }

    @TypeConverter
    public static List<AllocatedGroupRange> fromJsonToAllocatedGroupRanges(String rangesJson) {
        Type ranges = new TypeToken<List<AllocatedGroupRange>>(){}.getType();
        return (List)new Gson().fromJson(rangesJson, ranges);
    }

    @TypeConverter
    public static String allocatedSceneRangeToJson(List<AllocatedSceneRange> ranges) {
        return new Gson().toJson(ranges);
    }

    @TypeConverter
    public static List<AllocatedSceneRange> fromJsonToAllocatedSceneRanges(String rangesJson) {
        Type ranges = new TypeToken<List<AllocatedSceneRange>>(){}.getType();
        return (List)new Gson().fromJson(rangesJson, ranges);
    }

    @TypeConverter
    public static String allocatedUnicastRangeToJson(List<AllocatedUnicastRange> ranges) {
        return new Gson().toJson(ranges);
    }

    @TypeConverter
    public static List<AllocatedUnicastRange> fromJsonToAllocatedUnicastRanges(String rangesJson) {
        Type ranges = new TypeToken<List<AllocatedUnicastRange>>(){}.getType();
        return (List)new Gson().fromJson(rangesJson, ranges);
    }

    @TypeConverter
    public static String integerToJson(List<Integer> integerList) {
        return new Gson().toJson(integerList);
    }

    @TypeConverter
    public static List<Integer> fromJsonToIntegerList(String integerListJson) {
        Type addresses = new TypeToken<List<Integer>>(){}.getType();
        return (List)new Gson().fromJson(integerListJson, addresses);
    }

    @TypeConverter
    public String uuidToJson(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return new Gson().toJson((Object)uuid.toString());
    }

    @TypeConverter
    public UUID fromJsonToUuid(String addressesJson) {
        Type uuid = new TypeToken<UUID>(){}.getType();
        return (UUID)new Gson().fromJson(addressesJson, uuid);
    }

    @TypeConverter
    public static String sparseIntArrayToJson(@NonNull SparseIntArray array) {
        return new Gson().toJson((Object)array);
    }

    @TypeConverter
    public static SparseIntArray fromJsonToSparseIntArray(String integerListJson) {
        Type addresses = new TypeToken<SparseIntArray>(){}.getType();
        return (SparseIntArray)new Gson().fromJson(integerListJson, addresses);
    }

    @TypeConverter
    public static String nodeKeysToJson(@NonNull List<NodeKey> nodeKeys) {
        return new Gson().toJson(nodeKeys);
    }

    @TypeConverter
    public static List<NodeKey> fromJsonToNodeKeys(String nodeKeys) {
        Type keys = new TypeToken<List<NodeKey>>(){}.getType();
        return (List)new Gson().fromJson(nodeKeys, keys);
    }

    @TypeConverter
    public static String ivIndexToJson(@NonNull IvIndex ivIndex) {
        return new Gson().toJson((Object)ivIndex);
    }

    @TypeConverter
    public static IvIndex fromJsonToIvIndex(String ivIndex) {
        Type newIvIndex = new TypeToken<IvIndex>(){}.getType();
        return (IvIndex)new Gson().fromJson(ivIndex, newIvIndex);
    }

    @TypeConverter
    public static String networkExclusionsToJson(@NonNull Map<Integer, ArrayList<Integer>> networkExclusions) {
        return new Gson().toJson(networkExclusions);
    }

    @TypeConverter
    public static Map<Integer, ArrayList<Integer>> fromJsonToNetworkExclusions(@NonNull String networkExclusions) {
        Type newNetworkExclusions = new TypeToken<Map<Integer, ArrayList<Integer>>>(){}.getType();
        return (Map)new Gson().fromJson(networkExclusions, newNetworkExclusions);
    }
}

