/*
 * Copyright (c) 2018, Nordic Semiconductor
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package no.nordicsemi.android.mesh.utils;

import android.util.SparseArray;

public class CompanyIdentifiers {

    private static final SparseArray<String> vendorModels = new SparseArray();

    static {
        initVendorModels();
    }

    /**
     * Initializes company identifier and names with the given key/values
     */
    private static void initVendorModels() {
        vendorModels.append(0x0000, "Ericsson Technology Licensing");
        vendorModels.append(0x0001, "Nokia Mobile Phones");
        vendorModels.append(0x0002, "Intel Corp.");
        vendorModels.append(0x0003, "IBM Corp.");
        vendorModels.append(0x0004, "Toshiba Corp.");
        vendorModels.append(0x0005, "3Com");
        vendorModels.append(0x0006, "Microsoft");
        vendorModels.append(0x0007, "Lucent");
        vendorModels.append(0x0008, "Motorola");
        vendorModels.append(0x0009, "Infineon Technologies AG");
        vendorModels.append(0x000A, "Cambridge Silicon Radio");
        vendorModels.append(0x000B, "Silicon Wave");
        vendorModels.append(0x000C, "Digianswer A/S");
        vendorModels.append(0x000D, "Texas Instruments Inc.");
        vendorModels.append(0x000E, "Parthus Technologies Inc.");
        vendorModels.append(0x000F, "Broadcom Corporation");
        vendorModels.append(0x0010, "Mitel Semiconductor");
        vendorModels.append(0x0011, "Widcomm, Inc.");
        vendorModels.append(0x0012, "Zeevo, Inc.");
        vendorModels.append(0x0013, "Atmel Corporation");
        vendorModels.append(0x0014, "Mitsubishi Electric Corporation");
        vendorModels.append(0x0015, "RTX Telecom A/S");
        vendorModels.append(0x0016, "KC Technology Inc.");
        vendorModels.append(0x0017, "Newlogic");
        vendorModels.append(0x0018, "Transilica, Inc.");
        vendorModels.append(0x0019, "Rohde & Schwarz GmbH & Co. KG");
        vendorModels.append(0x001A, "TTPCom Limited");
        vendorModels.append(0x001B, "Signia Technologies, Inc.");
        vendorModels.append(0x001C, "Conexant Systems Inc.");
        vendorModels.append(0x001D, "Qualcomm");
        vendorModels.append(0x001E, "Inventel");
        vendorModels.append(0x001F, "AVM Berlin");
        vendorModels.append(0x0020, "BandSpeed, Inc.");
        vendorModels.append(0x0021, "Mansella Ltd");
        vendorModels.append(0x0022, "NEC Corporation");
        vendorModels.append(0x0023, "WavePlus Technology Co.,Ltd.");
        vendorModels.append(0x0024, "Alcatel");
        vendorModels.append(0x0025, "NXP Semiconductors (formerly Philips Semiconductors);");
        vendorModels.append(0x0026, "C Technologies");
        vendorModels.append(0x0027, "Open Interface");
        vendorModels.append(0x0028, "R F Micro Devices");
        vendorModels.append(0x0029, "Hitachi Ltd");
        vendorModels.append(0x002A, "Symbol Technologies, Inc.");
        vendorModels.append(0x002B, "Tenovis");
        vendorModels.append(0x002C, "Macronix International Co. Ltd.");
        vendorModels.append(0x002D, "GCT Semiconductor");
        vendorModels.append(0x002E, "Norwood Systems");
        vendorModels.append(0x002F, "MewTel Technology Inc.");
        vendorModels.append(0x0030, "ST Microelectronics");
        vendorModels.append(0x0031, "Synopsys, Inc.");
        vendorModels.append(0x0032, "Red-M (Communications,Ltd");
        vendorModels.append(0x0033, "Commil Ltd");
        vendorModels.append(0x0034, "Computer Access Technology Corporation (CATC);");
        vendorModels.append(0x0035, "Eclipse (HQ Espana,S.L.");
        vendorModels.append(0x0036, "Renesas Electronics Corporation");
        vendorModels.append(0x0037, "Mobilian Corporation");
        vendorModels.append(0x0038, "Syntronix Corporation");
        vendorModels.append(0x0039, "Integrated System Solution Corp.");
        vendorModels.append(0x003A, "Matsushita Electric Industrial Co.,Ltd.");
        vendorModels.append(0x003B, "Gennum Corporation");
        vendorModels.append(0x003C, "BlackBerry Limited (formerly Research In Motion);");
        vendorModels.append(0x003D, "IPextreme, Inc.");
        vendorModels.append(0x003E, "Systems and Chips, Inc");
        vendorModels.append(0x003F, "Bluetooth SIG, Inc");
        vendorModels.append(0x0040, "Seiko Epson Corporation");
        vendorModels.append(0x0041, "Integrated Silicon Solution Taiwan, Inc.");
        vendorModels.append(0x0042, "CONWISE Technology Corporation Ltd");
        vendorModels.append(0x0043, "PARROT AUTOMOTIVE SAS");
        vendorModels.append(0x0044, "Socket Mobile");
        vendorModels.append(0x0045, "Atheros Communications, Inc.");
        vendorModels.append(0x0046, "MediaTek, Inc.");
        vendorModels.append(0x0047, "Bluegiga");
        vendorModels.append(0x0048, "Marvell Technology Group Ltd.");
        vendorModels.append(0x0049, "3DSP Corporation");
        vendorModels.append(0x004A, "Accel Semiconductor Ltd.");
        vendorModels.append(0x004B, "Continental Automotive Systems");
        vendorModels.append(0x004C, "Apple, Inc.");
        vendorModels.append(0x004D, "Staccato Communications, Inc.");
        vendorModels.append(0x004E, "Avago Technologies");
        vendorModels.append(0x004F, "APT Ltd.");
        vendorModels.append(0x0050, "SiRF Technology, Inc.");
        vendorModels.append(0x0051, "Tzero Technologies, Inc.");
        vendorModels.append(0x0052, "J&M Corporation");
        vendorModels.append(0x0053, "Free2move AB");
        vendorModels.append(0x0054, "3DiJoy Corporation");
        vendorModels.append(0x0055, "Plantronics, Inc.");
        vendorModels.append(0x0056, "Sony Ericsson Mobile Communications");
        vendorModels.append(0x0057, "Harman International Industries, Inc.");
        vendorModels.append(0x0058, "Vizio, Inc.");
        vendorModels.append(0x0059, "Nordic Semiconductor ASA");
        vendorModels.append(0x005A, "EM Microelectronic-Marin SA");
        vendorModels.append(0x005B, "Ralink Technology Corporation");
        vendorModels.append(0x005C, "Belkin International, Inc.");
        vendorModels.append(0x005D, "Realtek Semiconductor Corporation");
        vendorModels.append(0x005E, "Stonestreet One,LLC");
        vendorModels.append(0x005F, "Wicentric, Inc.");
        vendorModels.append(0x0060, "RivieraWaves S.A.S");
        vendorModels.append(0x0061, "RDA Microelectronics");
        vendorModels.append(0x0062, "Gibson Guitars");
        vendorModels.append(0x0063, "MiCommand Inc.");
        vendorModels.append(0x0064, "Band XI International,LLC");
        vendorModels.append(0x0065, "Hewlett-Packard Company");
        vendorModels.append(0x0066, "9Solutions Oy");
        vendorModels.append(0x0067, "GN Netcom A/S");
        vendorModels.append(0x0068, "General Motors");
        vendorModels.append(0x0069, "A&D Engineering, Inc.");
        vendorModels.append(0x006A, "MindTree Ltd.");
        vendorModels.append(0x006B, "Polar Electro OY");
        vendorModels.append(0x006C, "Beautiful Enterprise Co.,Ltd.");
        vendorModels.append(0x006D, "BriarTek, Inc");
        vendorModels.append(0x006E, "Summit Data Communications, Inc.");
        vendorModels.append(0x006F, "Sound ID");
        vendorModels.append(0x0070, "Monster,LLC");
        vendorModels.append(0x0071, "connectBlue AB");
        vendorModels.append(0x0072, "ShangHai Super Smart Electronics Co. Ltd.");
        vendorModels.append(0x0073, "Group Sense Ltd.");
        vendorModels.append(0x0074, "Zomm,LLC");
        vendorModels.append(0x0075, "Samsung Electronics Co. Ltd.");
        vendorModels.append(0x0076, "Creative Technology Ltd.");
        vendorModels.append(0x0077, "Laird Technologies");
        vendorModels.append(0x0078, "Nike, Inc.");
        vendorModels.append(0x0079, "lesswire AG");
        vendorModels.append(0x007A, "MStar Semiconductor, Inc.");
        vendorModels.append(0x007B, "Hanlynn Technologies");
        vendorModels.append(0x007C, "A & R Cambridge");
        vendorModels.append(0x007D, "Seers Technology Co.,Ltd.");
        vendorModels.append(0x007E, "Sports Tracking Technologies Ltd.");
        vendorModels.append(0x007F, "Autonet Mobile");
        vendorModels.append(0x0080, "DeLorme Publishing Company, Inc.");
        vendorModels.append(0x0081, "WuXi Vimicro");
        vendorModels.append(0x0082, "Sennheiser Communications A/S");
        vendorModels.append(0x0083, "TimeKeeping Systems, Inc.");
        vendorModels.append(0x0084, "Ludus Helsinki Ltd.");
        vendorModels.append(0x0085, "BlueRadios, Inc.");
        vendorModels.append(0x0086, "Equinux AG");
        vendorModels.append(0x0087, "Garmin International, Inc.");
        vendorModels.append(0x0088, "Ecotest");
        vendorModels.append(0x0089, "GN ReSound A/S");
        vendorModels.append(0x008A, "Jawbone");
        vendorModels.append(0x008B, "Topcon Positioning Systems,LLC");
        vendorModels.append(0x008C, "Gimbal Inc. (formerly Qualcomm Labs, Inc. and Qualcomm Retail Solutions, Inc.);");
        vendorModels.append(0x008D, "Zscan Software");
        vendorModels.append(0x008E, "Quintic Corp");
        vendorModels.append(0x008F, "Telit Wireless Solutions GmbH (formerly Stollmann E+V GmbH);");
        vendorModels.append(0x0090, "Funai Electric Co.,Ltd.");
        vendorModels.append(0x0091, "Advanced PANMOBIL systems GmbH & Co. KG");
        vendorModels.append(0x0092, "ThinkOptics, Inc.");
        vendorModels.append(0x0093, "Universal Electronics, Inc.");
        vendorModels.append(0x0094, "Airoha Technology Corp.");
        vendorModels.append(0x0095, "NEC Lighting,Ltd.");
        vendorModels.append(0x0096, "ODM Technology, Inc.");
        vendorModels.append(0x0097, "ConnecteDevice Ltd.");
        vendorModels.append(0x0098, "zero1.tv GmbH");
        vendorModels.append(0x0099, "i.Tech Dynamic Global Distribution Ltd.");
        vendorModels.append(0x009A, "Alpwise");
        vendorModels.append(0x009B, "Jiangsu Toppower Automotive Electronics Co.,Ltd.");
        vendorModels.append(0x009C, "Colorfy, Inc.");
        vendorModels.append(0x009D, "Geoforce Inc.");
        vendorModels.append(0x009E, "Bose Corporation");
        vendorModels.append(0x009F, "Suunto Oy");
        vendorModels.append(0x00A0, "Kensington Computer Products Group");
        vendorModels.append(0x00A1, "SR-Medizinelektronik");
        vendorModels.append(0x00A2, "Vertu Corporation Limited");
        vendorModels.append(0x00A3, "Meta Watch Ltd.");
        vendorModels.append(0x00A4, "LINAK A/S");
        vendorModels.append(0x00A5, "OTL Dynamics LLC");
        vendorModels.append(0x00A6, "Panda Ocean Inc.");
        vendorModels.append(0x00A7, "Visteon Corporation");
        vendorModels.append(0x00A8, "ARP Devices Limited");
        vendorModels.append(0x00A9, "Magneti Marelli S.p.A");
        vendorModels.append(0x00AA, "CAEN RFID srl");
        vendorModels.append(0x00AB, "Ingenieur-Systemgruppe Zahn GmbH");
        vendorModels.append(0x00AC, "Green Throttle Games");
        vendorModels.append(0x00AD, "Peter Systemtechnik GmbH");
        vendorModels.append(0x00AE, "Omegawave Oy");
        vendorModels.append(0x00AF, "Cinetix");
        vendorModels.append(0x00B0, "Passif Semiconductor Corp");
        vendorModels.append(0x00B1, "Saris Cycling Group, Inc");
        vendorModels.append(0x00B2, "Bekey A/S");
        vendorModels.append(0x00B3, "Clarinox Technologies Pty. Ltd.");
        vendorModels.append(0x00B4, "BDE Technology Co.,Ltd.");
        vendorModels.append(0x00B5, "Swirl Networks");
        vendorModels.append(0x00B6, "Meso international");
        vendorModels.append(0x00B7, "TreLab Ltd");
        vendorModels.append(0x00B8, "Qualcomm Innovation Center, Inc. (QuIC);");
        vendorModels.append(0x00B9, "Johnson Controls, Inc.");
        vendorModels.append(0x00BA, "Starkey Laboratories Inc.");
        vendorModels.append(0x00BB, "S-Power Electronics Limited");
        vendorModels.append(0x00BC, "Ace Sensor Inc");
        vendorModels.append(0x00BD, "Aplix Corporation");
        vendorModels.append(0x00BE, "AAMP of America");
        vendorModels.append(0x00BF, "Stalmart Technology Limited");
        vendorModels.append(0x00C0, "AMICCOM Electronics Corporation");
        vendorModels.append(0x00C1, "Shenzhen Excelsecu Data Technology Co.);Ltd");
        vendorModels.append(0x00C2, "Geneq Inc.");
        vendorModels.append(0x00C3, "adidas AG");
        vendorModels.append(0x00C4, "LG Electronics");
        vendorModels.append(0x00C5, "Onset Computer Corporation");
        vendorModels.append(0x00C6, "Selfly BV");
        vendorModels.append(0x00C7, "Quuppa Oy.");
        vendorModels.append(0x00C8, "GeLo Inc");
        vendorModels.append(0x00C9, "Evluma");
        vendorModels.append(0x00CA, "MC10");
        vendorModels.append(0x00CB, "Binauric SE");
        vendorModels.append(0x00CC, "Beats Electronics");
        vendorModels.append(0x00CD, "Microchip Technology Inc.");
        vendorModels.append(0x00CE, "Elgato Systems GmbH");
        vendorModels.append(0x00CF, "ARCHOS SA");
        vendorModels.append(0x00D0, "Dexcom, Inc.");
        vendorModels.append(0x00D1, "Polar Electro Europe B.V.");
        vendorModels.append(0x00D2, "Dialog Semiconductor B.V.");
        vendorModels.append(0x00D3, "Taixingbang Technology (HK,Co);. LTD.");
        vendorModels.append(0x00D4, "Kawantech");
        vendorModels.append(0x00D5, "Austco Communication Systems");
        vendorModels.append(0x00D6, "Timex Group USA, Inc.");
        vendorModels.append(0x00D7, "Qualcomm Technologies, Inc.");
        vendorModels.append(0x00D8, "Qualcomm Connected Experiences, Inc.");
        vendorModels.append(0x00D9, "Voyetra Turtle Beach");
        vendorModels.append(0x00DA, "txtr GmbH");
        vendorModels.append(0x00DB, "Biosentronics");
        vendorModels.append(0x00DC, "Procter & Gamble");
        vendorModels.append(0x00DD, "Hosiden Corporation");
        vendorModels.append(0x00DE, "Muzik LLC");
        vendorModels.append(0x00DF, "Misfit Wearables Corp");
        vendorModels.append(0x00E0, "Google");
        vendorModels.append(0x00E1, "Danlers Ltd");
        vendorModels.append(0x00E2, "Semilink Inc");
        vendorModels.append(0x00E3, "inMusic Brands, Inc");
        vendorModels.append(0x00E4, "L.S. Research Inc.");
        vendorModels.append(0x00E5, "Eden Software Consultants Ltd.");
        vendorModels.append(0x00E6, "Freshtemp");
        vendorModels.append(0x00E7, "KS Technologies");
        vendorModels.append(0x00E8, "ACTS Technologies");
        vendorModels.append(0x00E9, "Vtrack Systems");
        vendorModels.append(0x00EA, "Nielsen-Kellerman Company");
        vendorModels.append(0x00EB, "Server Technology Inc.");
        vendorModels.append(0x00EC, "BioResearch Associates");
        vendorModels.append(0x00ED, "Jolly Logic,LLC");
        vendorModels.append(0x00EE, "Above Average Outcomes, Inc.");
        vendorModels.append(0x00EF, "Bitsplitters GmbH");
        vendorModels.append(0x00F0, "PayPal, Inc.");
        vendorModels.append(0x00F1, "Witron Technology Limited");
        vendorModels.append(0x00F2, "Morse Project Inc.");
        vendorModels.append(0x00F3, "Kent Displays Inc.");
        vendorModels.append(0x00F4, "Nautilus Inc.");
        vendorModels.append(0x00F5, "Smartifier Oy");
        vendorModels.append(0x00F6, "Elcometer Limited");
        vendorModels.append(0x00F7, "VSN Technologies, Inc.");
        vendorModels.append(0x00F8, "AceUni Corp.,Ltd.");
        vendorModels.append(0x00F9, "StickNFind");
        vendorModels.append(0x00FA, "Crystal Code AB");
        vendorModels.append(0x00FB, "KOUKAAM a.s.");
        vendorModels.append(0x00FC, "Delphi Corporation");
        vendorModels.append(0x00FD, "ValenceTech Limited");
        vendorModels.append(0x00FE, "Stanley Black and Decker");
        vendorModels.append(0x00FF, "Typo Products,LLC");
        vendorModels.append(0x0100, "TomTom International BV");
        vendorModels.append(0x0101, "Fugoo, Inc.");
        vendorModels.append(0x0102, "Keiser Corporation");
        vendorModels.append(0x0103, "Bang & Olufsen A/S");
        vendorModels.append(0x0104, "PLUS Location Systems Pty Ltd");
        vendorModels.append(0x0105, "Ubiquitous Computing Technology Corporation");
        vendorModels.append(0x0106, "Innovative Yachtter Solutions");
        vendorModels.append(0x0107, "William Demant Holding A/S");
        vendorModels.append(0x0108, "Chicony Electronics Co.,Ltd.");
        vendorModels.append(0x0109, "Atus BV");
        vendorModels.append(0x010A, "Codegate Ltd");
        vendorModels.append(0x010B, "ERi, Inc");
        vendorModels.append(0x010C, "Transducers Direct,LLC");
        vendorModels.append(0x010D, "Fujitsu Ten LImited");
        vendorModels.append(0x010E, "Audi AG");
        vendorModels.append(0x010F, "HiSilicon Technologies Col,Ltd.");
        vendorModels.append(0x0110, "Nippon Seiki Co.,Ltd.");
        vendorModels.append(0x0111, "Steelseries ApS");
        vendorModels.append(0x0112, "Visybl Inc.");
        vendorModels.append(0x0113, "Openbrain Technologies,Co.,Ltd.");
        vendorModels.append(0x0114, "Xensr");
        vendorModels.append(0x0115, "e.solutions");
        vendorModels.append(0x0116, "10AK Technologies");
        vendorModels.append(0x0117, "Wimoto Technologies Inc");
        vendorModels.append(0x0118, "Radius Networks, Inc.");
        vendorModels.append(0x0119, "Wize Technology Co.,Ltd.");
        vendorModels.append(0x011A, "Qualcomm Labs, Inc.");
        vendorModels.append(0x011B, "Hewlett Packard Enterprise");
        vendorModels.append(0x011C, "Baidu");
        vendorModels.append(0x011D, "Arendi AG");
        vendorModels.append(0x011E, "Skoda Auto a.s.");
        vendorModels.append(0x011F, "Volkswagen AG");
        vendorModels.append(0x0120, "Porsche AG");
        vendorModels.append(0x0121, "Sino Wealth Electronic Ltd.");
        vendorModels.append(0x0122, "AirTurn, Inc.");
        vendorModels.append(0x0123, "Kinsa, Inc");
        vendorModels.append(0x0124, "HID Global");
        vendorModels.append(0x0125, "SEAT es");
        vendorModels.append(0x0126, "Promethean Ltd.");
        vendorModels.append(0x0127, "Salutica Allied Solutions");
        vendorModels.append(0x0128, "GPSI Group Pty Ltd");
        vendorModels.append(0x0129, "Nimble Devices Oy");
        vendorModels.append(0x012A, "Changzhou Yongse Infotech Co.,Ltd.");
        vendorModels.append(0x012B, "SportIQ");
        vendorModels.append(0x012C, "TEMEC Instruments B.V.");
        vendorModels.append(0x012D, "Sony Corporation");
        vendorModels.append(0x012E, "ASSA ABLOY");
        vendorModels.append(0x012F, "Clarion Co. Inc.");
        vendorModels.append(0x0130, "Warehouse Innovations");
        vendorModels.append(0x0131, "Cypress Semiconductor");
        vendorModels.append(0x0132, "MADS Inc");
        vendorModels.append(0x0133, "Blue Maestro Limited");
        vendorModels.append(0x0134, "Resolution Products,Ltd.");
        vendorModels.append(0x0135, "Aireware LLC");
        vendorModels.append(0x0136, "Silvair, Inc.");
        vendorModels.append(0x0137, "Prestigio Plaza Ltd.");
        vendorModels.append(0x0138, "NTEO Inc.");
        vendorModels.append(0x0139, "Focus Systems Corporation");
        vendorModels.append(0x013A, "Tencent Holdings Ltd.");
        vendorModels.append(0x013B, "Allegion");
        vendorModels.append(0x013C, "Murata Manufacturing Co.,Ltd.");
        vendorModels.append(0x013D, "WirelessWERX");
        vendorModels.append(0x013E, "Nod, Inc.");
        vendorModels.append(0x013F, "B&B Manufacturing Company");
        vendorModels.append(0x0140, "Alpine Electronics (China,Co.,Ltd");
        vendorModels.append(0x0141, "FedEx Services");
        vendorModels.append(0x0142, "Grape Systems Inc.");
        vendorModels.append(0x0143, "Bkon Connect");
        vendorModels.append(0x0144, "Lintech GmbH");
        vendorModels.append(0x0145, "Novatel Wireless");
        vendorModels.append(0x0146, "Ciright");
        vendorModels.append(0x0147, "Mighty Cast, Inc.");
        vendorModels.append(0x0148, "Ambimat Electronics");
        vendorModels.append(0x0149, "Perytons Ltd.");
        vendorModels.append(0x014A, "Tivoli Audio,LLC");
        vendorModels.append(0x014B, "Master Lock");
        vendorModels.append(0x014C, "Mesh-Net Ltd");
        vendorModels.append(0x014D, "HUIZHOU DESAY SV AUTOMOTIVE CO.,LTD.");
        vendorModels.append(0x014E, "Tangerine, Inc.");
        vendorModels.append(0x014F, "B&W Group Ltd.");
        vendorModels.append(0x0150, "Pioneer Corporation");
        vendorModels.append(0x0151, "OnBeep");
        vendorModels.append(0x0152, "Vernier Software & Technology");
        vendorModels.append(0x0153, "ROL Ergo");
        vendorModels.append(0x0154, "Pebble Technology");
        vendorModels.append(0x0155, "NETATMO");
        vendorModels.append(0x0156, "Accumulate AB");
        vendorModels.append(0x0157, "Anhui Huami Information Technology Co.,Ltd.");
        vendorModels.append(0x0158, "Inmite s.r.o.");
        vendorModels.append(0x0159, "ChefSteps, Inc.");
        vendorModels.append(0x015A, "micas AG");
        vendorModels.append(0x015B, "Biomedical Research Ltd.");
        vendorModels.append(0x015C, "Pitius Tec S.L.");
        vendorModels.append(0x015D, "Estimote, Inc.");
        vendorModels.append(0x015E, "Unikey Technologies, Inc.");
        vendorModels.append(0x015F, "Timer Cap Co.");
        vendorModels.append(0x0160, "AwoX");
        vendorModels.append(0x0161, "yikes");
        vendorModels.append(0x0162, "MADSGlobalNZ Ltd.");
        vendorModels.append(0x0163, "PCH International");
        vendorModels.append(0x0164, "Qingdao Yeelink Information Technology Co.,Ltd.");
        vendorModels.append(0x0165, "Milwaukee Tool (Formally Milwaukee Electric Tools);");
        vendorModels.append(0x0166, "MISHIK Pte Ltd");
        vendorModels.append(0x0167, "Ascensia Diabetes Care US Inc.");
        vendorModels.append(0x0168, "Spicebox LLC");
        vendorModels.append(0x0169, "emberlight");
        vendorModels.append(0x016A, "Cooper-Atkins Corporation");
        vendorModels.append(0x016B, "Qblinks");
        vendorModels.append(0x016C, "MYSPHERA");
        vendorModels.append(0x016D, "LifeScan Inc");
        vendorModels.append(0x016E, "Volantic AB");
        vendorModels.append(0x016F, "Podo Labs, Inc");
        vendorModels.append(0x0170, "Roche Diabetes Care AG");
        vendorModels.append(0x0171, "Amazon Fulfillment Service");
        vendorModels.append(0x0172, "Connovate Technology Private Limited");
        vendorModels.append(0x0173, "Kocomojo,LLC");
        vendorModels.append(0x0174, "Everykey Inc.");
        vendorModels.append(0x0175, "Dynamic Controls");
        vendorModels.append(0x0176, "SentriLock");
        vendorModels.append(0x0177, "I-SYST inc.");
        vendorModels.append(0x0178, "CASIO COMPUTER CO.,LTD.");
        vendorModels.append(0x0179, "LAPIS Semiconductor Co.,Ltd.");
        vendorModels.append(0x017A, "Telemonitor, Inc.");
        vendorModels.append(0x017B, "taskit GmbH");
        vendorModels.append(0x017C, "Daimler AG");
        vendorModels.append(0x017D, "BatAndCat");
        vendorModels.append(0x017E, "BluDotz Ltd");
        vendorModels.append(0x017F, "XTel Wireless ApS");
        vendorModels.append(0x0180, "Gigaset Communications GmbH");
        vendorModels.append(0x0181, "Gecko Health Innovations, Inc.");
        vendorModels.append(0x0182, "HOP Ubiquitous");
        vendorModels.append(0x0183, "Walt Disney");
        vendorModels.append(0x0184, "Nectar");
        vendorModels.append(0x0185, "bel'apps LLC");
        vendorModels.append(0x0186, "CORE Lighting Ltd");
        vendorModels.append(0x0187, "Seraphim Sense Ltd");
        vendorModels.append(0x0188, "Unico RBC");
        vendorModels.append(0x0189, "Physical Enterprises Inc.");
        vendorModels.append(0x018A, "Able Trend Technology Limited");
        vendorModels.append(0x018B, "Konica Minolta, Inc.");
        vendorModels.append(0x018C, "Wilo SE");
        vendorModels.append(0x018D, "Extron Design Services");
        vendorModels.append(0x018E, "Fitbit, Inc.");
        vendorModels.append(0x018F, "Fireflies Systems");
        vendorModels.append(0x0190, "Intelletto Technologies Inc.");
        vendorModels.append(0x0191, "FDK CORPORATION");
        vendorModels.append(0x0192, "Cloudleaf, Inc");
        vendorModels.append(0x0193, "Maveric Automation LLC");
        vendorModels.append(0x0194, "Acoustic Stream Corporation");
        vendorModels.append(0x0195, "Zuli");
        vendorModels.append(0x0196, "Paxton Access Ltd");
        vendorModels.append(0x0197, "WiSilica Inc.");
        vendorModels.append(0x0198, "VENGIT Korlatolt Felelossegu Tarsasag");
        vendorModels.append(0x0199, "SALTO SYSTEMS S.L.");
        vendorModels.append(0x019A, "TRON Forum (formerly T-Engine Forum);");
        vendorModels.append(0x019B, "CUBETECH s.r.o.");
        vendorModels.append(0x019C, "Cokiya Incorporated");
        vendorModels.append(0x019D, "CVS Health");
        vendorModels.append(0x019E, "Ceruus");
        vendorModels.append(0x019F, "Strainstall Ltd");
        vendorModels.append(0x01A0, "Channel Enterprises (HK,Ltd.");
        vendorModels.append(0x01A1, "FIAMM");
        vendorModels.append(0x01A2, "GIGALANE.CO.);LTD");
        vendorModels.append(0x01A3, "EROAD");
        vendorModels.append(0x01A4, "Mine Safety Appliances");
        vendorModels.append(0x01A5, "Icon Health and Fitness");
        vendorModels.append(0x01A6, "Asandoo GmbH");
        vendorModels.append(0x01A7, "ENERGOUS CORPORATION");
        vendorModels.append(0x01A8, "Taobao");
        vendorModels.append(0x01A9, "Canon Inc.");
        vendorModels.append(0x01AA, "Geophysical Technology Inc.");
        vendorModels.append(0x01AB, "Facebook, Inc.");
        vendorModels.append(0x01AC, "Trividia Health, Inc.");
        vendorModels.append(0x01AD, "FlightSafety International");
        vendorModels.append(0x01AE, "Earlens Corporation");
        vendorModels.append(0x01AF, "Sunrise Micro Devices, Inc.");
        vendorModels.append(0x01B0, "Star Micronics Co.,Ltd.");
        vendorModels.append(0x01B1, "Netizens Sp. z o.o.");
        vendorModels.append(0x01B2, "Nymi Inc.");
        vendorModels.append(0x01B3, "Nytec, Inc.");
        vendorModels.append(0x01B4, "Trineo Sp. z o.o.");
        vendorModels.append(0x01B5, "Nest Labs Inc.");
        vendorModels.append(0x01B6, "LM Technologies Ltd");
        vendorModels.append(0x01B7, "General Electric Company");
        vendorModels.append(0x01B8, "i+D3 S.L.");
        vendorModels.append(0x01B9, "HANA Micron");
        vendorModels.append(0x01BA, "Stages Cycling LLC");
        vendorModels.append(0x01BB, "Cochlear Bone Anchored Solutions AB");
        vendorModels.append(0x01BC, "SenionLab AB");
        vendorModels.append(0x01BD, "Syszone Co.,Ltd");
        vendorModels.append(0x01BE, "Pulsate Mobile Ltd.");
        vendorModels.append(0x01BF, "Hong Kong HunterSun Electronic Limited");
        vendorModels.append(0x01C0, "pironex GmbH");
        vendorModels.append(0x01C1, "BRADATECH Corp.");
        vendorModels.append(0x01C2, "Transenergooil AG");
        vendorModels.append(0x01C3, "Bunch");
        vendorModels.append(0x01C4, "DME Microelectronics");
        vendorModels.append(0x01C5, "Bitcraze AB");
        vendorModels.append(0x01C6, "HASWARE Inc.");
        vendorModels.append(0x01C7, "Abiogenix Inc.");
        vendorModels.append(0x01C8, "Poly-Control ApS");
        vendorModels.append(0x01C9, "Avi-on");
        vendorModels.append(0x01CA, "Laerdal Medical AS");
        vendorModels.append(0x01CB, "Fetch My Pet");
        vendorModels.append(0x01CC, "Sam Labs Ltd.");
        vendorModels.append(0x01CD, "Chengdu Synwing Technology Ltd");
        vendorModels.append(0x01CE, "HOUWA SYSTEM DESIGN,k.k.");
        vendorModels.append(0x01CF, "BSH");
        vendorModels.append(0x01D0, "Primus Inter Pares Ltd");
        vendorModels.append(0x01D1, "August Home, Inc");
        vendorModels.append(0x01D2, "Gill Electronics");
        vendorModels.append(0x01D3, "Sky Wave Design");
        vendorModels.append(0x01D4, "Newlab S.r.l.");
        vendorModels.append(0x01D5, "ELAD srl");
        vendorModels.append(0x01D6, "G-wearables inc.");
        vendorModels.append(0x01D7, "Squadrone Systems Inc.");
        vendorModels.append(0x01D8, "Code Corporation");
        vendorModels.append(0x01D9, "Savant Systems LLC");
        vendorModels.append(0x01DA, "Logitech International SA");
        vendorModels.append(0x01DB, "Innblue Consulting");
        vendorModels.append(0x01DC, "iParking Ltd.");
        vendorModels.append(0x01DD, "Koninklijke Philips Electronics N.V.");
        vendorModels.append(0x01DE, "Minelab Electronics Pty Limited");
        vendorModels.append(0x01DF, "Bison Group Ltd.");
        vendorModels.append(0x01E0, "Widex A/S");
        vendorModels.append(0x01E1, "Jolla Ltd");
        vendorModels.append(0x01E2, "Lectronix, Inc.");
        vendorModels.append(0x01E3, "Caterpillar Inc");
        vendorModels.append(0x01E4, "Freedom Innovations");
        vendorModels.append(0x01E5, "Dynamic Devices Ltd");
        vendorModels.append(0x01E6, "Technology Solutions (UK,Ltd");
        vendorModels.append(0x01E7, "IPS Group Inc.");
        vendorModels.append(0x01E8, "STIR");
        vendorModels.append(0x01E9, "Sano, Inc.");
        vendorModels.append(0x01EA, "Advanced Application Design, Inc.");
        vendorModels.append(0x01EB, "AutoMap LLC");
        vendorModels.append(0x01EC, "Spreadtrum Communications Shanghai Ltd");
        vendorModels.append(0x01ED, "CuteCircuit LTD");
        vendorModels.append(0x01EE, "Valeo Service");
        vendorModels.append(0x01EF, "Fullpower Technologies, Inc.");
        vendorModels.append(0x01F0, "KloudNation");
        vendorModels.append(0x01F1, "Zebra Technologies Corporation");
        vendorModels.append(0x01F2, "Itron, Inc.");
        vendorModels.append(0x01F3, "The University of Tokyo");
        vendorModels.append(0x01F4, "UTC Fire and Security");
        vendorModels.append(0x01F5, "Cool Webthings Limited");
        vendorModels.append(0x01F6, "DJO Global");
        vendorModels.append(0x01F7, "Gelliner Limited");
        vendorModels.append(0x01F8, "Anyka (Guangzhou,Microelectronics Technology Co,LTD");
        vendorModels.append(0x01F9, "Medtronic Inc.");
        vendorModels.append(0x01FA, "Gozio Inc.");
        vendorModels.append(0x01FB, "Form Lifting,LLC");
        vendorModels.append(0x01FC, "Wahoo Fitness,LLC");
        vendorModels.append(0x01FD, "Kontakt Micro-Location Sp. z o.o.");
        vendorModels.append(0x01FE, "Radio Systems Corporation");
        vendorModels.append(0x01FF, "Freescale Semiconductor, Inc.");
        vendorModels.append(0x0200, "Verifone Systems Pte Ltd. Taiwan Branch");
        vendorModels.append(0x0201, "AR Timing");
        vendorModels.append(0x0202, "Rigado LLC");
        vendorModels.append(0x0203, "Kemppi Oy");
        vendorModels.append(0x0204, "Tapcentive Inc.");
        vendorModels.append(0x0205, "Smartbotics Inc.");
        vendorModels.append(0x0206, "Otter Products,LLC");
        vendorModels.append(0x0207, "STEMP Inc.");
        vendorModels.append(0x0208, "LumiGeek LLC");
        vendorModels.append(0x0209, "InvisionHeart Inc.");
        vendorModels.append(0x020A, "Macnica Inc.");
        vendorModels.append(0x020B, "Jaguar Land Rover Limited");
        vendorModels.append(0x020C, "CoroWare Technologies, Inc");
        vendorModels.append(0x020D, "Simplo Technology Co.,LTD");
        vendorModels.append(0x020E, "Omron Healthcare Co.,LTD");
        vendorModels.append(0x020F, "Comodule GMBH");
        vendorModels.append(0x0210, "ikeGPS");
        vendorModels.append(0x0211, "Telink Semiconductor Co. Ltd");
        vendorModels.append(0x0212, "Interplan Co.,Ltd");
        vendorModels.append(0x0213, "Wyler AG");
        vendorModels.append(0x0214, "IK Multimedia Production srl");
        vendorModels.append(0x0215, "Lukoton Experience Oy");
        vendorModels.append(0x0216, "MTI Ltd");
        vendorModels.append(0x0217, "Tech4home,Lda");
        vendorModels.append(0x0218, "Hiotech AB");
        vendorModels.append(0x0219, "DOTT Limited");
        vendorModels.append(0x021A, "Blue Speck Labs,LLC");
        vendorModels.append(0x021B, "Cisco Systems, Inc");
        vendorModels.append(0x021C, "Mobicomm Inc");
        vendorModels.append(0x021D, "Edamic");
        vendorModels.append(0x021E, "Goodnet,Ltd");
        vendorModels.append(0x021F, "Luster Leaf Products Inc");
        vendorModels.append(0x0220, "Manus Machina BV");
        vendorModels.append(0x0221, "Mobiquity Networks Inc");
        vendorModels.append(0x0222, "Praxis Dynamics");
        vendorModels.append(0x0223, "Philip Morris Products S.A.");
        vendorModels.append(0x0224, "Comarch SA");
        vendorModels.append(0x0225, "Nestl Nespresso S.A.");
        vendorModels.append(0x0226, "Merlinia A/S");
        vendorModels.append(0x0227, "LifeBEAM Technologies");
        vendorModels.append(0x0228, "Twocanoes Labs,LLC");
        vendorModels.append(0x0229, "Muoverti Limited");
        vendorModels.append(0x022A, "Stamer Musikanlagen GMBH");
        vendorModels.append(0x022B, "Tesla Motors");
        vendorModels.append(0x022C, "Pharynks Corporation");
        vendorModels.append(0x022D, "Lupine");
        vendorModels.append(0x022E, "Siemens AG");
        vendorModels.append(0x022F, "Huami (Shanghai,Culture Communication CO.,LTD");
        vendorModels.append(0x0230, "Foster Electric Company,Ltd");
        vendorModels.append(0x0231, "ETA SA");
        vendorModels.append(0x0232, "x-Senso Solutions Kft");
        vendorModels.append(0x0233, "Shenzhen SuLong Communication Ltd");
        vendorModels.append(0x0234, "FengFan (BeiJing,Technology Co,Ltd");
        vendorModels.append(0x0235, "Qrio Inc");
        vendorModels.append(0x0236, "Pitpatpet Ltd");
        vendorModels.append(0x0237, "MSHeli s.r.l.");
        vendorModels.append(0x0238, "Trakm8 Ltd");
        vendorModels.append(0x0239, "JIN CO,Ltd");
        vendorModels.append(0x023A, "Alatech Tehnology");
        vendorModels.append(0x023B, "Beijing CarePulse Electronic Technology Co,Ltd");
        vendorModels.append(0x023C, "Awarepoint");
        vendorModels.append(0x023D, "ViCentra B.V.");
        vendorModels.append(0x023E, "Raven Industries");
        vendorModels.append(0x023F, "WaveWare Technologies Inc.");
        vendorModels.append(0x0240, "Argenox Technologies");
        vendorModels.append(0x0241, "Bragi GmbH");
        vendorModels.append(0x0242, "16Lab Inc");
        vendorModels.append(0x0243, "Masimo Corp");
        vendorModels.append(0x0244, "Iotera Inc");
        vendorModels.append(0x0245, "Endress+Hauser");
        vendorModels.append(0x0246, "ACKme Networks, Inc.");
        vendorModels.append(0x0247, "FiftyThree Inc.");
        vendorModels.append(0x0248, "Parker Hannifin Corp");
        vendorModels.append(0x0249, "Transcranial Ltd");
        vendorModels.append(0x024A, "Uwatec AG");
        vendorModels.append(0x024B, "Orlan LLC");
        vendorModels.append(0x024C, "Blue Clover Devices");
        vendorModels.append(0x024D, "M-Way Solutions GmbH");
        vendorModels.append(0x024E, "Microtronics Engineering GmbH");
        vendorModels.append(0x024F, "Schneider Schreibgerte GmbH");
        vendorModels.append(0x0250, "Sapphire Circuits LLC");
        vendorModels.append(0x0251, "Lumo Bodytech Inc.");
        vendorModels.append(0x0252, "UKC Technosolution");
        vendorModels.append(0x0253, "Xicato Inc.");
        vendorModels.append(0x0254, "Playbrush");
        vendorModels.append(0x0255, "Dai Nippon Printing Co.,Ltd.");
        vendorModels.append(0x0256, "G24 Power Limited");
        vendorModels.append(0x0257, "AdBabble Local Commerce Inc.");
        vendorModels.append(0x0258, "Devialet SA");
        vendorModels.append(0x0259, "ALTYOR");
        vendorModels.append(0x025A, "University of Applied Sciences Valais/Haute Ecole Valaisanne");
        vendorModels.append(0x025B, "Five Interactive,LLC dba Zendo");
        vendorModels.append(0x025C, "NetEaseHangzhouNetwork co.Ltd.");
        vendorModels.append(0x025D, "Lexmark International Inc.");
        vendorModels.append(0x025E, "Fluke Corporation");
        vendorModels.append(0x025F, "Yardarm Technologies");
        vendorModels.append(0x0260, "SensaRx");
        vendorModels.append(0x0261, "SECVRE GmbH");
        vendorModels.append(0x0262, "Glacial Ridge Technologies");
        vendorModels.append(0x0263, "Identiv, Inc.");
        vendorModels.append(0x0264, "DDS, Inc.");
        vendorModels.append(0x0265, "SMK Corporation");
        vendorModels.append(0x0266, "Schawbel Technologies LLC");
        vendorModels.append(0x0267, "XMI Systems SA");
        vendorModels.append(0x0268, "Cerevo");
        vendorModels.append(0x0269, "Torrox GmbH & Co KG");
        vendorModels.append(0x026A, "Gemalto");
        vendorModels.append(0x026B, "DEKA Research & Development Corp.");
        vendorModels.append(0x026C, "Domster Tadeusz Szydlowski");
        vendorModels.append(0x026D, "Technogym SPA");
        vendorModels.append(0x026E, "FLEURBAEY BVBA");
        vendorModels.append(0x026F, "Aptcode Solutions");
        vendorModels.append(0x0270, "LSI ADL Technology");
        vendorModels.append(0x0271, "Animas Corp");
        vendorModels.append(0x0272, "Alps Electric Co.,Ltd.");
        vendorModels.append(0x0273, "OCEASOFT");
        vendorModels.append(0x0274, "Motsai Research");
        vendorModels.append(0x0275, "Geotab");
        vendorModels.append(0x0276, "E.G.O. Elektro-Gertebau GmbH");
        vendorModels.append(0x0277, "bewhere inc");
        vendorModels.append(0x0278, "Johnson Outdoors Inc");
        vendorModels.append(0x0279, "steute Schaltgerate GmbH & Co. KG");
        vendorModels.append(0x027A, "Ekomini inc.");
        vendorModels.append(0x027B, "DEFA AS");
        vendorModels.append(0x027C, "Aseptika Ltd");
        vendorModels.append(0x027D, "HUAWEI Technologies Co.,Ltd. ( );");
        vendorModels.append(0x027E, "HabitAware,LLC");
        vendorModels.append(0x027F, "ruwido austria gmbh");
        vendorModels.append(0x0280, "ITEC corporation");
        vendorModels.append(0x0281, "StoneL");
        vendorModels.append(0x0282, "Sonova AG");
        vendorModels.append(0x0283, "Maven Machines, Inc.");
        vendorModels.append(0x0284, "Synapse Electronics");
        vendorModels.append(0x0285, "Standard Innovation Inc.");
        vendorModels.append(0x0286, "RF Code, Inc.");
        vendorModels.append(0x0287, "Wally Ventures S.L.");
        vendorModels.append(0x0288, "Willowbank Electronics Ltd");
        vendorModels.append(0x0289, "SK Telecom");
        vendorModels.append(0x028A, "Jetro AS");
        vendorModels.append(0x028B, "Code Gears LTD");
        vendorModels.append(0x028C, "NANOLINK APS");
        vendorModels.append(0x028D, "IF,LLC");
        vendorModels.append(0x028E, "RF Digital Corp");
        vendorModels.append(0x028F, "Church & Dwight Co., Inc");
        vendorModels.append(0x0290, "Multibit Oy");
        vendorModels.append(0x0291, "CliniCloud Inc");
        vendorModels.append(0x0292, "SwiftSensors");
        vendorModels.append(0x0293, "Blue Bite");
        vendorModels.append(0x0294, "ELIAS GmbH");
        vendorModels.append(0x0295, "Sivantos GmbH");
        vendorModels.append(0x0296, "Petzl");
        vendorModels.append(0x0297, "storm power ltd");
        vendorModels.append(0x0298, "EISST Ltd");
        vendorModels.append(0x0299, "Inexess Technology Simma KG");
        vendorModels.append(0x029A, "Currant, Inc.");
        vendorModels.append(0x029B, "C2 Development, Inc.");
        vendorModels.append(0x029C, "Blue Sky Scientific,LLC");
        vendorModels.append(0x029D, "ALOTTAZS LABS,LLC");
        vendorModels.append(0x029E, "Kupson spol. s r.o.");
        vendorModels.append(0x029F, "Areus Engineering GmbH");
        vendorModels.append(0x02A0, "Impossible Camera GmbH");
        vendorModels.append(0x02A1, "InventureTrack Systems");
        vendorModels.append(0x02A2, "LockedUp");
        vendorModels.append(0x02A3, "Itude");
        vendorModels.append(0x02A4, "Pacific Lock Company");
        vendorModels.append(0x02A5, "Tendyron Corporation ( );");
        vendorModels.append(0x02A6, "Robert Bosch GmbH");
        vendorModels.append(0x02A7, "Illuxtron international B.V.");
        vendorModels.append(0x02A8, "miSport Ltd.");
        vendorModels.append(0x02A9, "Chargelib");
        vendorModels.append(0x02AA, "Doppler Lab");
        vendorModels.append(0x02AB, "BBPOS Limited");
        vendorModels.append(0x02AC, "RTB Elektronik GmbH & Co. KG");
        vendorModels.append(0x02AD, "Rx Networks, Inc.");
        vendorModels.append(0x02AE, "WeatherFlow, Inc.");
        vendorModels.append(0x02AF, "Technicolor USA Inc.");
        vendorModels.append(0x02B0, "Bestechnic(Shanghai););Ltd");
        vendorModels.append(0x02B1, "Raden Inc");
        vendorModels.append(0x02B2, "JouZen Oy");
        vendorModels.append(0x02B3, "CLABER S.P.A.");
        vendorModels.append(0x02B4, "Hyginex, Inc.");
        vendorModels.append(0x02B5, "HANSHIN ELECTRIC RAILWAY CO.);LTD.");
        vendorModels.append(0x02B6, "Schneider Electric");
        vendorModels.append(0x02B7, "Oort Technologies LLC");
        vendorModels.append(0x02B8, "Chrono Therapeutics");
        vendorModels.append(0x02B9, "Rinnai Corporation");
        vendorModels.append(0x02BA, "Swissprime Technologies AG");
        vendorModels.append(0x02BB, "Koha.);Co.Ltd");
        vendorModels.append(0x02BC, "Genevac Ltd");
        vendorModels.append(0x02BD, "Chemtronics");
        vendorModels.append(0x02BE, "Seguro Technology Sp. z o.o.");
        vendorModels.append(0x02BF, "Redbird Flight Simulations");
        vendorModels.append(0x02C0, "Dash Robotics");
        vendorModels.append(0x02C1, "LINE Corporation");
        vendorModels.append(0x02C2, "Guillemot Corporation");
        vendorModels.append(0x02C3, "Techtronic Power Tools Technology Limited");
        vendorModels.append(0x02C4, "Wilson Sporting Goods");
        vendorModels.append(0x02C5, "Lenovo (Singapore,Pte Ltd. ( );");
        vendorModels.append(0x02C6, "Ayatan Sensors");
        vendorModels.append(0x02C7, "Electronics Tomorrow Limited");
        vendorModels.append(0x02C8, "VASCO Data Security International, Inc.");
        vendorModels.append(0x02C9, "PayRange Inc.");
        vendorModels.append(0x02CA, "ABOV Semiconductor");
        vendorModels.append(0x02CB, "AINA-Wireless Inc.");
        vendorModels.append(0x02CC, "Eijkelkamp Soil & Water");
        vendorModels.append(0x02CD, "BMA ergonomics b.v.");
        vendorModels.append(0x02CE, "Teva Branded Pharmaceutical Products R&D, Inc.");
        vendorModels.append(0x02CF, "Anima");
        vendorModels.append(0x02D0, "3M");
        vendorModels.append(0x02D1, "Empatica Srl");
        vendorModels.append(0x02D2, "Afero, Inc.");
        vendorModels.append(0x02D3, "Powercast Corporation");
        vendorModels.append(0x02D4, "Secuyou ApS");
        vendorModels.append(0x02D5, "OMRON Corporation");
        vendorModels.append(0x02D6, "Send Solutions");
        vendorModels.append(0x02D7, "NIPPON SYSTEMWARE CO.);LTD.");
        vendorModels.append(0x02D8, "Neosfar");
        vendorModels.append(0x02D9, "Fliegl Agrartechnik GmbH");
        vendorModels.append(0x02DA, "Gilvader");
        vendorModels.append(0x02DB, "Digi International Inc (R);");
        vendorModels.append(0x02DC, "DeWalch Technologies, Inc.");
        vendorModels.append(0x02DD, "Flint Rehabilitation Devices,LLC");
        vendorModels.append(0x02DE, "Samsung SDS Co.,Ltd.");
        vendorModels.append(0x02DF, "Blur Product Development");
        vendorModels.append(0x02E0, "University of Michigan");
        vendorModels.append(0x02E1, "Victron Energy BV");
        vendorModels.append(0x02E2, "NTT docomo");
        vendorModels.append(0x02E3, "Carmanah Technologies Corp.");
        vendorModels.append(0x02E4, "Bytestorm Ltd.");
        vendorModels.append(0x02E5, "Espressif Incorporated ( (,);");
        vendorModels.append(0x02E6, "Unwire");
        vendorModels.append(0x02E7, "Connected Yard, Inc.");
        vendorModels.append(0x02E8, "American Music Environments");
        vendorModels.append(0x02E9, "Sensogram Technologies, Inc.");
        vendorModels.append(0x02EA, "Fujitsu Limited");
        vendorModels.append(0x02EB, "Ardic Technology");
        vendorModels.append(0x02EC, "Delta Systems, Inc");
        vendorModels.append(0x02ED, "HTC Corporation");
        vendorModels.append(0x02EE, "Citizen Holdings Co.,Ltd.");
        vendorModels.append(0x02EF, "SMART-INNOVATION.inc");
        vendorModels.append(0x02F0, "Blackrat Software");
        vendorModels.append(0x02F1, "The Idea Cave,LLC");
        vendorModels.append(0x02F2, "GoPro, Inc.");
        vendorModels.append(0x02F3, "AuthAir, Inc");
        vendorModels.append(0x02F4, "Vensi, Inc.");
        vendorModels.append(0x02F5, "Indagem Tech LLC");
        vendorModels.append(0x02F6, "Intemo Technologies");
        vendorModels.append(0x02F7, "DreamVisions co.,Ltd.");
        vendorModels.append(0x02F8, "Runteq Oy Ltd");
        vendorModels.append(0x02F9, "IMAGINATION TECHNOLOGIES LTD");
        vendorModels.append(0x02FA, "CoSTAR TEchnologies");
        vendorModels.append(0x02FB, "Clarius Mobile Health Corp.");
        vendorModels.append(0x02FC, "Shanghai Frequen Microelectronics Co.,Ltd.");
        vendorModels.append(0x02FD, "Uwanna, Inc.");
        vendorModels.append(0x02FE, "Lierda Science & Technology Group Co.,Ltd.");
        vendorModels.append(0x02FF, "Silicon Laboratories");
        vendorModels.append(0x0300, "World Moto Inc.");
        vendorModels.append(0x0301, "Giatec Scientific Inc.");
        vendorModels.append(0x0302, "Loop Devices, Inc");
        vendorModels.append(0x0303, "IACA electronique");
        vendorModels.append(0x0304, "Proxy Technologies, Inc.");
        vendorModels.append(0x0305, "Swipp ApS");
        vendorModels.append(0x0306, "Life Laboratory Inc.");
        vendorModels.append(0x0307, "FUJI INDUSTRIAL CO.);LTD.");
        vendorModels.append(0x0308, "Surefire,LLC");
        vendorModels.append(0x0309, "Dolby Labs");
        vendorModels.append(0x030A, "Ellisys");
        vendorModels.append(0x030B, "Magnitude Lighting Converters");
        vendorModels.append(0x030C, "Hilti AG");
        vendorModels.append(0x030D, "Devdata S.r.l.");
        vendorModels.append(0x030E, "Deviceworx");
        vendorModels.append(0x030F, "Shortcut Labs");
        vendorModels.append(0x0310, "SGL Italia S.r.l.");
        vendorModels.append(0x0311, "PEEQ DATA");
        vendorModels.append(0x0312, "Ducere Technologies Pvt Ltd");
        vendorModels.append(0x0313, "DiveNav, Inc.");
        vendorModels.append(0x0314, "RIIG AI Sp. z o.o.");
        vendorModels.append(0x0315, "Thermo Fisher Scientific");
        vendorModels.append(0x0316, "AG Measurematics Pvt. Ltd.");
        vendorModels.append(0x0317, "CHUO Electronics CO.,LTD.");
        vendorModels.append(0x0318, "Aspenta International");
        vendorModels.append(0x0319, "Eugster Frismag AG");
        vendorModels.append(0x031A, "Amber wireless GmbH");
        vendorModels.append(0x031B, "HQ Inc");
        vendorModels.append(0x031C, "Lab Sensor Solutions");
        vendorModels.append(0x031D, "Enterlab ApS");
        vendorModels.append(0x031E, "Eyefi, Inc.");
        vendorModels.append(0x031F, "MetaSystem S.p.A.");
        vendorModels.append(0x0320, "SONO ELECTRONICS. CO.,LTD");
        vendorModels.append(0x0321, "Jewelbots");
        vendorModels.append(0x0322, "Compumedics Limited");
        vendorModels.append(0x0323, "Rotor Bike Components");
        vendorModels.append(0x0324, "Astro, Inc.");
        vendorModels.append(0x0325, "Amotus Solutions");
        vendorModels.append(0x0326, "Healthwear Technologies (Changzhou);Ltd");
        vendorModels.append(0x0327, "Essex Electronics");
        vendorModels.append(0x0328, "Grundfos A/S");
        vendorModels.append(0x0329, "Eargo, Inc.");
        vendorModels.append(0x032A, "Electronic Design Lab");
        vendorModels.append(0x032B, "ESYLUX");
        vendorModels.append(0x032C, "NIPPON SMT.CO.);Ltd");
        vendorModels.append(0x032D, "BM innovations GmbH");
        vendorModels.append(0x032E, "indoormap");
        vendorModels.append(0x032F, "OttoQ Inc");
        vendorModels.append(0x0330, "North Pole Engineering");
        vendorModels.append(0x0331, "3flares Technologies Inc.");
        vendorModels.append(0x0332, "Electrocompaniet A.S.");
        vendorModels.append(0x0333, "Mul-T-Lock");
        vendorModels.append(0x0334, "Corentium AS");
        vendorModels.append(0x0335, "Enlighted Inc");
        vendorModels.append(0x0336, "GISTIC");
        vendorModels.append(0x0337, "AJP2 Holdings,LLC");
        vendorModels.append(0x0338, "COBI GmbH");
        vendorModels.append(0x0339, "Blue Sky Scientific,LLC");
        vendorModels.append(0x033A, "Appception, Inc.");
        vendorModels.append(0x033B, "Courtney Thorne Limited");
        vendorModels.append(0x033C, "Virtuosys");
        vendorModels.append(0x033D, "TPV Technology Limited");
        vendorModels.append(0x033E, "Monitra SA");
        vendorModels.append(0x033F, "Automation Components, Inc.");
        vendorModels.append(0x0340, "Letsense s.r.l.");
        vendorModels.append(0x0341, "Etesian Technologies LLC");
        vendorModels.append(0x0342, "GERTEC BRASIL LTDA.");
        vendorModels.append(0x0343, "Drekker Development Pty. Ltd.");
        vendorModels.append(0x0344, "Whirl Inc");
        vendorModels.append(0x0345, "Locus Positioning");
        vendorModels.append(0x0346, "Acuity Brands Lighting, Inc");
        vendorModels.append(0x0347, "Prevent Biometrics");
        vendorModels.append(0x0348, "Arioneo");
        vendorModels.append(0x0349, "VersaMe");
        vendorModels.append(0x034A, "Vaddio");
        vendorModels.append(0x034B, "Libratone A/S");
        vendorModels.append(0x034C, "HM Electronics, Inc.");
        vendorModels.append(0x034D, "TASER International, Inc.");
        vendorModels.append(0x034E, "SafeTrust Inc.");
        vendorModels.append(0x034F, "Heartland Payment Systems");
        vendorModels.append(0x0350, "Bitstrata Systems Inc.");
        vendorModels.append(0x0351, "Pieps GmbH");
        vendorModels.append(0x0352, "iRiding(Xiamen);Technology Co.);Ltd.");
        vendorModels.append(0x0353, "Alpha Audiotronics, Inc.");
        vendorModels.append(0x0354, "TOPPAN FORMS CO.);LTD.");
        vendorModels.append(0x0355, "Sigma Designs, Inc.");
        vendorModels.append(0x0356, "Spectrum Brands, Inc.");
        vendorModels.append(0x0357, "Polymap Wireless");
        vendorModels.append(0x0358, "MagniWare Ltd.");
        vendorModels.append(0x0359, "Novotec Medical GmbH");
        vendorModels.append(0x035A, "Medicom Innovation Partner a/s");
        vendorModels.append(0x035B, "Matrix Inc.");
        vendorModels.append(0x035C, "Eaton Corporation");
        vendorModels.append(0x035D, "KYS");
        vendorModels.append(0x035E, "Naya Health, Inc.");
        vendorModels.append(0x035F, "Acromag");
        vendorModels.append(0x0360, "Insulet Corporation");
        vendorModels.append(0x0361, "Wellinks Inc.");
        vendorModels.append(0x0362, "ON Semiconductor");
        vendorModels.append(0x0363, "FREELAP SA");
        vendorModels.append(0x0364, "Favero Electronics Srl");
        vendorModels.append(0x0365, "BioMech Sensor LLC");
        vendorModels.append(0x0366, "BOLTT Sports technologies Private limited");
        vendorModels.append(0x0367, "Saphe International");
        vendorModels.append(0x0368, "Metormote AB");
        vendorModels.append(0x0369, "littleBits");
        vendorModels.append(0x036A, "SetPoint Medical");
        vendorModels.append(0x036B, "BRControls Products BV");
        vendorModels.append(0x036C, "Zipcar");
        vendorModels.append(0x036D, "AirBolt Pty Ltd");
        vendorModels.append(0x036E, "KeepTruckin Inc");
        vendorModels.append(0x036F, "Motiv, Inc.");
        vendorModels.append(0x0370, "Wazombi Labs O");
        vendorModels.append(0x0371, "ORBCOMM");
        vendorModels.append(0x0372, "Nixie Labs, Inc.");
        vendorModels.append(0x0373, "AppNearMe Ltd");
        vendorModels.append(0x0374, "Holman Industries");
        vendorModels.append(0x0375, "Expain AS");
        vendorModels.append(0x0376, "Electronic Temperature Instruments Ltd");
        vendorModels.append(0x0377, "Plejd AB");
        vendorModels.append(0x0378, "Propeller Health");
        vendorModels.append(0x0379, "Shenzhen iMCO Electronic Technology Co.);Ltd");
        vendorModels.append(0x037A, "Algoria");
        vendorModels.append(0x037B, "Apption Labs Inc.");
        vendorModels.append(0x037C, "Cronologics Corporation");
        vendorModels.append(0x037D, "MICRODIA Ltd.");
        vendorModels.append(0x037E, "lulabytes S.L.");
        vendorModels.append(0x037F, "Nestec S.A.");
        vendorModels.append(0x0380, "LLC \"MEGA-F service\"");
        vendorModels.append(0x0381, "Sharp Corporation");
        vendorModels.append(0x0382, "Precision Outcomes Ltd");
        vendorModels.append(0x0383, "Kronos Incorporated");
        vendorModels.append(0x0384, "OCOSMOS Co.,Ltd.");
        vendorModels.append(0x0385, "Embedded Electronic Solutions Ltd. dba e2Solutions");
        vendorModels.append(0x0386, "Aterica Inc.");
        vendorModels.append(0x0387, "BluStor PMC, Inc.");
        vendorModels.append(0x0388, "Kapsch TrafficCom AB");
        vendorModels.append(0x0389, "ActiveBlu Corporation");
        vendorModels.append(0x038A, "Kohler Mira Limited");
        vendorModels.append(0x038B, "Noke");
        vendorModels.append(0x038C, "Appion Inc.");
        vendorModels.append(0x038D, "Resmed Ltd");
        vendorModels.append(0x038E, "Crownstone B.V.");
        vendorModels.append(0x038F, "Xiaomi Inc.");
        vendorModels.append(0x0390, "INFOTECH s.r.o.");
        vendorModels.append(0x0391, "Thingsquare AB");
        vendorModels.append(0x0392, "T&D");
        vendorModels.append(0x0393, "LAVAZZA S.p.A.");
        vendorModels.append(0x0394, "Netclearance Systems, Inc.");
        vendorModels.append(0x0395, "SDATAWAY");
        vendorModels.append(0x0396, "BLOKS GmbH");
        vendorModels.append(0x0397, "LEGO System A/S");
        vendorModels.append(0x0398, "Thetatronics Ltd");
        vendorModels.append(0x0399, "Nikon Corporation");
        vendorModels.append(0x039A, "NeST");
        vendorModels.append(0x039B, "South Silicon Valley Microelectronics");
        vendorModels.append(0x039C, "ALE International");
        vendorModels.append(0x039D, "CareView Communications, Inc.");
        vendorModels.append(0x039E, "SchoolBoard Limited");
        vendorModels.append(0x039F, "Molex Corporation");
        vendorModels.append(0x03A0, "IVT Wireless Limited");
        vendorModels.append(0x03A1, "Alpine Labs LLC");
        vendorModels.append(0x03A2, "Candura Instruments");
        vendorModels.append(0x03A3, "SmartMovt Technology Co.,Ltd");
        vendorModels.append(0x03A4, "Token Zero Ltd");
        vendorModels.append(0x03A5, "ACE CAD Enterprise Co.,Ltd. (ACECAD);");
        vendorModels.append(0x03A6, "Medela, Inc");
        vendorModels.append(0x03A7, "AeroScout");
        vendorModels.append(0x03A8, "Esrille Inc.");
        vendorModels.append(0x03A9, "THINKERLY SRL");
        vendorModels.append(0x03AA, "Exon Sp. z o.o.");
        vendorModels.append(0x03AB, "Meizu Technology Co.,Ltd.");
        vendorModels.append(0x03AC, "Smablo LTD");
        vendorModels.append(0x03AD, "XiQ");
        vendorModels.append(0x03AE, "Allswell Inc.");
        vendorModels.append(0x03AF, "Comm-N-Sense Corp DBA Verigo");
        vendorModels.append(0x03B0, "VIBRADORM GmbH");
        vendorModels.append(0x03B1, "Otodata Wireless Network Inc.");
        vendorModels.append(0x03B2, "Propagation Systems Limited");
        vendorModels.append(0x03B3, "Midwest Instruments & Controls");
        vendorModels.append(0x03B4, "Alpha Nodus, Inc.");
        vendorModels.append(0x03B5, "petPOMM, Inc");
        vendorModels.append(0x03B6, "Mattel");
        vendorModels.append(0x03B7, "Airbly Inc.");
        vendorModels.append(0x03B8, "A-Safe Limited");
        vendorModels.append(0x03B9, "FREDERIQUE CONSTANT SA");
        vendorModels.append(0x03BA, "Maxscend Microelectronics Company Limited");
        vendorModels.append(0x03BB, "Abbott Diabetes Care");
        vendorModels.append(0x03BC, "ASB Bank Ltd");
        vendorModels.append(0x03BD, "amadas");
        vendorModels.append(0x03BE, "Applied Science, Inc.");
        vendorModels.append(0x03BF, "iLumi Solutions Inc.");
        vendorModels.append(0x03C0, "Arch Systems Inc.");
        vendorModels.append(0x03C1, "Ember Technologies, Inc.");
        vendorModels.append(0x03C2, "Snapchat Inc");
        vendorModels.append(0x03C3, "Casambi Technologies Oy");
        vendorModels.append(0x03C4, "Pico Technology Inc.");
        vendorModels.append(0x03C5, "St. Jude Medical, Inc.");
        vendorModels.append(0x03C6, "Intricon");
        vendorModels.append(0x03C7, "Structural Health Systems, Inc.");
        vendorModels.append(0x03C8, "Avvel International");
        vendorModels.append(0x03C9, "Gallagher Group");
        vendorModels.append(0x03CA, "In2things Automation Pvt. Ltd.");
        vendorModels.append(0x03CB, "SYSDEV Srl");
        vendorModels.append(0x03CC, "Vonkil Technologies Ltd");
        vendorModels.append(0x03CD, "Wynd Technologies, Inc.");
        vendorModels.append(0x03CE, "CONTRINEX S.A.");
        vendorModels.append(0x03CF, "MIRA, Inc.");
        vendorModels.append(0x03D0, "Watteam Ltd");
        vendorModels.append(0x03D1, "Density Inc.");
        vendorModels.append(0x03D2, "IOT Pot India Private Limited");
        vendorModels.append(0x03D3, "Sigma Connectivity AB");
        vendorModels.append(0x03D4, "PEG PEREGO SPA");
        vendorModels.append(0x03D5, "Wyzelink Systems Inc.");
        vendorModels.append(0x03D6, "Yota Devices LTD");
        vendorModels.append(0x03D7, "FINSECUR");
        vendorModels.append(0x03D8, "Zen-Me Labs Ltd");
        vendorModels.append(0x03D9, "3IWare Co.,Ltd.");
        vendorModels.append(0x03DA, "EnOcean GmbH");
        vendorModels.append(0x03DB, "Instabeat, Inc");
        vendorModels.append(0x03DC, "Nima Labs");
        vendorModels.append(0x03DD, "Andreas Stihl AG & Co. KG");
        vendorModels.append(0x03DE, "Nathan Rhoades LLC");
        vendorModels.append(0x03DF, "Grob Technologies,LLC");
        vendorModels.append(0x03E0, "Actions (Zhuhai,Technology Co.,Limited");
        vendorModels.append(0x03E1, "SPD Development Company Ltd");
        vendorModels.append(0x03E2, "Sensoan Oy");
        vendorModels.append(0x03E3, "Qualcomm Life Inc");
        vendorModels.append(0x03E4, "Chip-ing AG");
        vendorModels.append(0x03E5, "ffly4u");
        vendorModels.append(0x03E6, "IoT Instruments Oy");
        vendorModels.append(0x03E7, "TRUE Fitness Technology");
        vendorModels.append(0x03E8, "Reiner Kartengeraete GmbH & Co. KG.");
        vendorModels.append(0x03E9, "SHENZHEN LEMONJOY TECHNOLOGY CO.,LTD.");
        vendorModels.append(0x03EA, "Hello Inc.");
        vendorModels.append(0x03EB, "Evollve Inc.");
        vendorModels.append(0x03EC, "Jigowatts Inc.");
        vendorModels.append(0x03ED, "BASIC MICRO.COM);INC.");
        vendorModels.append(0x03EE, "CUBE TECHNOLOGIES");
        vendorModels.append(0x03EF, "foolography GmbH");
        vendorModels.append(0x03F0, "CLINK");
        vendorModels.append(0x03F1, "Hestan Smart Cooking Inc.");
        vendorModels.append(0x03F2, "WindowMaster A/S");
        vendorModels.append(0x03F3, "Flowscape AB");
        vendorModels.append(0x03F4, "PAL Technologies Ltd");
        vendorModels.append(0x03F5, "WHERE, Inc.");
        vendorModels.append(0x03F6, "Iton Technology Corp.");
        vendorModels.append(0x03F7, "Owl Labs Inc.");
        vendorModels.append(0x03F8, "Rockford Corp.");
        vendorModels.append(0x03F9, "Becon Technologies Co.);Ltd.");
        vendorModels.append(0x03FA, "Vyassoft Technologies Inc");
        vendorModels.append(0x03FB, "Nox Medical");
        vendorModels.append(0x03FC, "Kimberly-Clark");
        vendorModels.append(0x03FD, "Trimble Navigation Ltd.");
        vendorModels.append(0x03FE, "Littelfuse");
        vendorModels.append(0x03FF, "Withings");
        vendorModels.append(0x0400, "i-developer IT Beratung UG");
        vendorModels.append(0x0401, "Unknown");
        vendorModels.append(0x0402, "Sears Holdings Corporation");
        vendorModels.append(0x0403, "Gantner Electronic GmbH");
        vendorModels.append(0x0404, "Authomate Inc");
        vendorModels.append(0x0405, "Vertex International, Inc.");
        vendorModels.append(0x0406, "Airtago");
        vendorModels.append(0x0407, "Swiss Audio SA");
        vendorModels.append(0x0408, "ToGetHome Inc.");
        vendorModels.append(0x0409, "AXIS");
        vendorModels.append(0x040A, "Openmatics");
        vendorModels.append(0x040B, "Jana Care Inc.");
        vendorModels.append(0x040C, "Senix Corporation");
        vendorModels.append(0x040D, "NorthStar Battery Company,LLC");
        vendorModels.append(0x040E, "SKF (U.K.,Limited");
        vendorModels.append(0x040F, "CO-AX Technology, Inc.");
        vendorModels.append(0x0410, "Fender Musical Instruments");
        vendorModels.append(0x0411, "Luidia Inc");
        vendorModels.append(0x0412, "SEFAM");
        vendorModels.append(0x0413, "Wireless Cables Inc");
        vendorModels.append(0x0414, "Lightning Protection International Pty Ltd");
        vendorModels.append(0x0415, "Uber Technologies Inc");
        vendorModels.append(0x0416, "SODA GmbH");
        vendorModels.append(0x0417, "Fatigue Science");
        vendorModels.append(0x0418, "Alpine Electronics Inc.");
        vendorModels.append(0x0419, "Novalogy LTD");
        vendorModels.append(0x041A, "Friday Labs Limited");
        vendorModels.append(0x041B, "OrthoAccel Technologies");
        vendorModels.append(0x041C, "WaterGuru, Inc.");
        vendorModels.append(0x041D, "Benning Elektrotechnik und Elektronik GmbH & Co. KG");
        vendorModels.append(0x041E, "Dell Computer Corporation");
        vendorModels.append(0x041F, "Kopin Corporation");
        vendorModels.append(0x0420, "TecBakery GmbH");
        vendorModels.append(0x0421, "Backbone Labs, Inc.");
        vendorModels.append(0x0422, "DELSEY SA");
        vendorModels.append(0x0423, "Chargifi Limited");
        vendorModels.append(0x0424, "Trainesense Ltd.");
        vendorModels.append(0x0425, "Unify Software and Solutions GmbH & Co. KG");
        vendorModels.append(0x0426, "Husqvarna AB");
        vendorModels.append(0x0427, "Focus fleet and fuel management inc");
        vendorModels.append(0x0428, "SmallLoop,LLC");
        vendorModels.append(0x0429, "Prolon Inc.");
        vendorModels.append(0x042A, "BD Medical");
        vendorModels.append(0x042B, "iMicroMed Incorporated");
        vendorModels.append(0x042C, "Ticto N.V.");
        vendorModels.append(0x042D, "Meshtech AS");
        vendorModels.append(0x042E, "MemCachier Inc.");
        vendorModels.append(0x042F, "Danfoss A/S");
        vendorModels.append(0x0430, "SnapStyk Inc.");
        vendorModels.append(0x0431, "Amway Corporation");
        vendorModels.append(0x0432, "Silk Labs, Inc.");
        vendorModels.append(0x0433, "Pillsy Inc.");
        vendorModels.append(0x0434, "Hatch Baby, Inc.");
        vendorModels.append(0x0435, "Blocks Wearables Ltd.");
        vendorModels.append(0x0436, "Drayson Technologies (Europe,Limited");
        vendorModels.append(0x0437, "eBest IOT Inc.");
        vendorModels.append(0x0438, "Helvar Ltd");
        vendorModels.append(0x0439, "Radiance Technologies");
        vendorModels.append(0x043A, "Nuheara Limited");
        vendorModels.append(0x043B, "Appside co.,ltd.");
        vendorModels.append(0x043C, "DeLaval");
        vendorModels.append(0x043D, "Coiler Corporation");
        vendorModels.append(0x043E, "Thermomedics, Inc.");
        vendorModels.append(0x043F, "Tentacle Sync GmbH");
        vendorModels.append(0x0440, "Valencell, Inc.");
        vendorModels.append(0x0441, "iProtoXi Oy");
        vendorModels.append(0x0442, "SECOM CO.,LTD.");
        vendorModels.append(0x0443, "Tucker International LLC");
        vendorModels.append(0x0444, "Metanate Limited");
        vendorModels.append(0x0445, "Kobian Canada Inc.");
        vendorModels.append(0x0446, "NETGEAR, Inc.");
        vendorModels.append(0x0447, "Fabtronics Australia Pty Ltd");
        vendorModels.append(0x0448, "Grand Centrix GmbH");
        vendorModels.append(0x0449, "1UP USA.com llc");
        vendorModels.append(0x044A, "SHIMANO INC.");
        vendorModels.append(0x044B, "Nain Inc.");
        vendorModels.append(0x044C, "LifeStyle Lock,LLC");
        vendorModels.append(0x044D, "VEGA Grieshaber KG");
        vendorModels.append(0x044E, "Xtrava Inc.");
        vendorModels.append(0x044F, "TTS Tooltechnic Systems AG & Co. KG");
        vendorModels.append(0x0450, "Teenage Engineering AB");
        vendorModels.append(0x0451, "Tunstall Nordic AB");
        vendorModels.append(0x0452, "Svep Design Center AB");
        vendorModels.append(0x0453, "GreenPeak Technologies BV");
        vendorModels.append(0x0454, "Sphinx Electronics GmbH & Co KG");
        vendorModels.append(0x0455, "Atomation");
        vendorModels.append(0x0456, "Nemik Consulting Inc");
        vendorModels.append(0x0457, "RF INNOVATION");
        vendorModels.append(0x0458, "Mini Solution Co.,Ltd.");
        vendorModels.append(0x0459, "Lumenetix, Inc");
        vendorModels.append(0x045A, "2048450 Ontario Inc");
        vendorModels.append(0x045B, "SPACEEK LTD");
        vendorModels.append(0x045C, "Delta T Corporation");
        vendorModels.append(0x045D, "Boston Scientific Corporation");
        vendorModels.append(0x045E, "Nuviz, Inc.");
        vendorModels.append(0x045F, "Real Time Automation, Inc.");
        vendorModels.append(0x0460, "Kolibree");
        vendorModels.append(0x0461, "vhf elektronik GmbH");
        vendorModels.append(0x0462, "Bonsai Systems GmbH");
        vendorModels.append(0x0463, "Fathom Systems Inc.");
        vendorModels.append(0x0464, "Bellman & Symfon");
        vendorModels.append(0x0465, "International Forte Group LLC");
        vendorModels.append(0x0466, "CycleLabs Solutions inc.");
        vendorModels.append(0x0467, "Codenex Oy");
        vendorModels.append(0x0468, "Kynesim Ltd");
        vendorModels.append(0x0469, "Palago AB");
        vendorModels.append(0x046A, "INSIGMA INC.");
        vendorModels.append(0x046B, "PMD Solutions");
        vendorModels.append(0x046C, "Qingdao Realtime Technology Co.,Ltd.");
        vendorModels.append(0x046D, "BEGA Gantenbrink-Leuchten KG");
        vendorModels.append(0x046E, "Pambor Ltd.");
        vendorModels.append(0x046F, "Develco Products A/S");
        vendorModels.append(0x0470, "iDesign s.r.l.");
        vendorModels.append(0x0471, "TiVo Corp");
        vendorModels.append(0x0472, "Control-J Pty Ltd");
        vendorModels.append(0x0473, "Steelcase, Inc.");
        vendorModels.append(0x0474, "iApartment co.,ltd.");
        vendorModels.append(0x0475, "Icom inc.");
        vendorModels.append(0x0476, "Oxstren Wearable Technologies Private Limited");
        vendorModels.append(0x0477, "Blue Spark Technologies");
        vendorModels.append(0x0478, "FarSite Communications Limited");
        vendorModels.append(0x0479, "mywerk system GmbH");
        vendorModels.append(0x047A, "Sinosun Technology Co.,Ltd.");
        vendorModels.append(0x047B, "MIYOSHI ELECTRONICS CORPORATION");
        vendorModels.append(0x047C, "POWERMAT LTD");
        vendorModels.append(0x047D, "Occly LLC");
        vendorModels.append(0x047E, "OurHub Dev IvS");
        vendorModels.append(0x047F, "Pro-Mark, Inc.");
        vendorModels.append(0x0480, "Dynometrics Inc.");
        vendorModels.append(0x0481, "Quintrax Limited");
        vendorModels.append(0x0482, "POS Tuning Udo Vosshenrich GmbH & Co. KG");
        vendorModels.append(0x0483, "Multi Care Systems B.V.");
        vendorModels.append(0x0484, "Revol Technologies Inc");
        vendorModels.append(0x0485, "SKIDATA AG");
        vendorModels.append(0x0486, "DEV TECNOLOGIA INDUSTRIA,COMERCIO E MANUTENCAO DE EQUIPAMENTOS LTDA. - ME");
        vendorModels.append(0x0487, "Centrica Connected Home");
        vendorModels.append(0x0488, "Automotive Data Solutions Inc");
        vendorModels.append(0x0489, "Igarashi Engineering");
        vendorModels.append(0x048A, "Taelek Oy");
        vendorModels.append(0x048B, "CP Electronics Limited");
        vendorModels.append(0x048C, "Vectronix AG");
        vendorModels.append(0x048D, "S-Labs Sp. z o.o.");
        vendorModels.append(0x048E, "Companion Medical, Inc.");
        vendorModels.append(0x048F, "BlueKitchen GmbH");
        vendorModels.append(0x0490, "Matting AB");
        vendorModels.append(0x0491, "SOREX - Wireless Solutions GmbH");
        vendorModels.append(0x0492, "ADC Technology, Inc.");
        vendorModels.append(0x0493, "Lynxemi Pte Ltd");
        vendorModels.append(0x0494, "SENNHEISER electronic GmbH & Co. KG");
        vendorModels.append(0x0495, "LMT Mercer Group, Inc");
        vendorModels.append(0x0496, "Polymorphic Labs LLC");
        vendorModels.append(0x0497, "Cochlear Limited");
        vendorModels.append(0x0498, "METER Group, Inc. USA");
        vendorModels.append(0x0499, "Ruuvi Innovations Ltd.");
        vendorModels.append(0x049A, "Situne AS");
        vendorModels.append(0x049B, "nVisti,LLC");
        vendorModels.append(0x049C, "DyOcean");
        vendorModels.append(0x049D, "Uhlmann & Zacher GmbH");
        vendorModels.append(0x049E, "AND!XOR LLC");
        vendorModels.append(0x049F, "tictote AB");
        vendorModels.append(0x04A0, "Vypin,LLC");
        vendorModels.append(0x04A1, "PNI Sensor Corporation");
        vendorModels.append(0x04A2, "ovrEngineered,LLC");
        vendorModels.append(0x04A3, "GT-tronics HK Ltd");
        vendorModels.append(0x04A4, "Herbert Waldmann GmbH & Co. KG");
        vendorModels.append(0x04A5, "Guangzhou FiiO Electronics Technology Co.);Ltd");
        vendorModels.append(0x04A6, "Vinetech Co.,Ltd");
        vendorModels.append(0x04A7, "Dallas Logic Corporation");
        vendorModels.append(0x04A8, "BioTex, Inc.");
        vendorModels.append(0x04A9, "DISCOVERY SOUND TECHNOLOGY,LLC");
        vendorModels.append(0x04AA, "LINKIO SAS");
        vendorModels.append(0x04AB, "Harbortronics, Inc.");
        vendorModels.append(0x04AC, "Undagrid B.V.");
        vendorModels.append(0x04AD, "Shure Inc");
        vendorModels.append(0x04AE, "ERM Electronic Systems LTD");
        vendorModels.append(0x04AF, "BIOROWER Handelsagentur GmbH");
        vendorModels.append(0x04B0, "Weba Sport und Med. Artikel GmbH");
        vendorModels.append(0x04B1, "Kartographers Technologies Pvt. Ltd.");
        vendorModels.append(0x04B2, "The Shadow on the Moon");
        vendorModels.append(0x04B3, "mobike (Hong Kong,Limited");
        vendorModels.append(0x04B4, "Inuheat Group AB");
        vendorModels.append(0x04B5, "Swiftronix AB");
        vendorModels.append(0x04B6, "Diagnoptics Technologies");
        vendorModels.append(0x04B7, "Analog Devices, Inc.");
        vendorModels.append(0x04B8, "Soraa Inc.");
        vendorModels.append(0x04B9, "CSR Building Products Limited");
        vendorModels.append(0x04BA, "Crestron Electronics, Inc.");
        vendorModels.append(0x04BB, "Neatebox Ltd");
        vendorModels.append(0x04BC, "Draegerwerk AG & Co. KGaA");
        vendorModels.append(0x04BD, "AlbynMedical");
        vendorModels.append(0x04BE, "Averos FZCO");
        vendorModels.append(0x04BF, "VIT Initiative,LLC");
        vendorModels.append(0x04C0, "Statsports International");
        vendorModels.append(0x04C1, "Sospitas,s.r.o.");
        vendorModels.append(0x04C2, "Dmet Products Corp.");
        vendorModels.append(0x04C3, "Mantracourt Electronics Limited");
        vendorModels.append(0x04C4, "TeAM Hutchins AB");
        vendorModels.append(0x04C5, "Seibert Williams Glass,LLC");
        vendorModels.append(0x04C6, "Insta GmbH");
        vendorModels.append(0x04C7, "Svantek Sp. z o.o.");
        vendorModels.append(0x04C8, "Shanghai Flyco Electrical Appliance Co.,Ltd.");
        vendorModels.append(0x04C9, "Thornwave Labs Inc");
        vendorModels.append(0x04CA, "Steiner-Optik GmbH");
        vendorModels.append(0x04CB, "Novo Nordisk A/S");
        vendorModels.append(0x04CC, "Enflux Inc.");
        vendorModels.append(0x04CD, "Safetech Products LLC");
        vendorModels.append(0x04CE, "GOOOLED S.R.L.");
        vendorModels.append(0x04CF, "DOM Sicherheitstechnik GmbH & Co. KG");
        vendorModels.append(0x04D0, "Olympus Corporation");
        vendorModels.append(0x04D1, "KTS GmbH");
        vendorModels.append(0x04D2, "Anloq Technologies Inc.");
        vendorModels.append(0x04D3, "Queercon, Inc");
        vendorModels.append(0x04D4, "5th Element Ltd");
        vendorModels.append(0x04D5, "Gooee Limited");
        vendorModels.append(0x04D6, "LUGLOC LLC");
        vendorModels.append(0x04D7, "Blincam, Inc.");
        vendorModels.append(0x04D8, "FUJIFILM Corporation");
        vendorModels.append(0x04D9, "RandMcNally");
        vendorModels.append(0x04DA, "Franceschi Marina snc");
        vendorModels.append(0x04DB, "Engineered Audio,LLC.");
        vendorModels.append(0x04DC, "IOTTIVE (OPC,PRIVATE LIMITED");
        vendorModels.append(0x04DD, "4MOD Technology");
        vendorModels.append(0x04DE, "Lutron Electronics Co., Inc.");
        vendorModels.append(0x04DF, "Emerson");
        vendorModels.append(0x04E0, "Guardtec, Inc.");
        vendorModels.append(0x04E1, "REACTEC LIMITED");
        vendorModels.append(0x04E2, "EllieGrid");
        vendorModels.append(0x04E3, "Under Armour");
        vendorModels.append(0x04E4, "Woodenshark");
        vendorModels.append(0x04E5, "Avack Oy");
        vendorModels.append(0x04E6, "Smart Solution Technology, Inc.");
        vendorModels.append(0x04E7, "REHABTRONICS INC.");
        vendorModels.append(0x04E8, "STABILO International");
        vendorModels.append(0x04E9, "Busch Jaeger Elektro GmbH");
        vendorModels.append(0x04EA, "Pacific Bioscience Laboratories, Inc");
        vendorModels.append(0x04EB, "Bird Home Automation GmbH");
        vendorModels.append(0x04EC, "Motorola Solutions");
        vendorModels.append(0x04ED, "R9 Technology, Inc.");
        vendorModels.append(0x04EE, "Auxivia");
        vendorModels.append(0x04EF, "DaisyWorks, Inc");
        vendorModels.append(0x04F0, "Kosi Limited");
        vendorModels.append(0x04F1, "Theben AG");
        vendorModels.append(0x04F2, "InDreamer Techsol Private Limited");
        vendorModels.append(0x04F3, "Cerevast Medical");
        vendorModels.append(0x04F4, "ZanCompute Inc.");
        vendorModels.append(0x04F5, "Pirelli Tyre S.P.A.");
        vendorModels.append(0x04F6, "McLear Limited");
        vendorModels.append(0x04F7, "Shenzhen Huiding Technology Co.);Ltd.");
        vendorModels.append(0x04F8, "Convergence Systems Limited");
        vendorModels.append(0x04F9, "Interactio");
        vendorModels.append(0x04FA, "Androtec GmbH");
        vendorModels.append(0x04FB, "Benchmark Drives GmbH & Co. KG");
        vendorModels.append(0x04FC, "SwingLync L. L. C.");
        vendorModels.append(0x04FD, "Tapkey GmbH");
        vendorModels.append(0x04FE, "Woosim Systems Inc.");
        vendorModels.append(0x04FF, "Microsemi Corporation");
        vendorModels.append(0x0500, "Wiliot LTD.");
        vendorModels.append(0x0501, "Polaris IND");
        vendorModels.append(0x0502, "Specifi-Kali LLC");
        vendorModels.append(0x0503, "Locoroll, Inc");
        vendorModels.append(0x0504, "PHYPLUS Inc");
        vendorModels.append(0x0505, "Inplay Technologies LLC");
        vendorModels.append(0x0506, "Hager");
        vendorModels.append(0x0507, "Yellowcog");
        vendorModels.append(0x0508, "Axes System sp. z o. o.");
        vendorModels.append(0x0509, "myLIFTER Inc.");
        vendorModels.append(0x050A, "Shake-on B.V.");
        vendorModels.append(0x050B, "Vibrissa Inc.");
        vendorModels.append(0x050C, "OSRAM GmbH");
        vendorModels.append(0x050D, "TRSystems GmbH");
        vendorModels.append(0x050E, "Yichip Microelectronics (Hangzhou,Co.);Ltd.");
        vendorModels.append(0x050F, "Foundation Engineering LLC");
        vendorModels.append(0x0510, "UNI-ELECTRONICS, Inc.");
        vendorModels.append(0x0511, "Brookfield Equinox LLC");
        vendorModels.append(0x0512, "Soprod SA");
        vendorModels.append(0x0513, "9974091 Canada Inc.");
        vendorModels.append(0x0514, "FIBRO GmbH");
        vendorModels.append(0x0515, "RB Controls Co.,Ltd.");
        vendorModels.append(0x0516, "Footmarks");
        vendorModels.append(0x0517, "Amcore AB");
        vendorModels.append(0x0518, "MAMORIO.inc");
        vendorModels.append(0x0519, "Tyto Life LLC");
        vendorModels.append(0x051A, "Leica Camera AG");
        vendorModels.append(0x051B, "Angee Technologies Ltd.");
        vendorModels.append(0x051C, "EDPS");
        vendorModels.append(0x051D, "OFF Line Co.,Ltd.");
        vendorModels.append(0x051E, "Detect Blue Limited");
        vendorModels.append(0x051F, "Setec Pty Ltd");
        vendorModels.append(0x0520, "Target Corporation");
        vendorModels.append(0x0521, "IAI Corporation");
        vendorModels.append(0x0522, "NS Tech, Inc.");
        vendorModels.append(0x0523, "MTG Co.,Ltd.");
        vendorModels.append(0x0524, "Hangzhou iMagic Technology Co.,Ltd");
        vendorModels.append(0x0525, "HONGKONG NANO IC TECHNOLOGIES CO.,LIMITED");
        vendorModels.append(0x0526, "Honeywell International Inc.");
        vendorModels.append(0x0527, "Albrecht JUNG");
        vendorModels.append(0x0528, "Lunera Lighting Inc.");
        vendorModels.append(0x0529, "Lumen UAB");
        vendorModels.append(0x052A, "Keynes Controls Ltd");
        vendorModels.append(0x052B, "Novartis AG");
        vendorModels.append(0x052C, "Geosatis SA");
        vendorModels.append(0x052D, "EXFO, Inc.");
        vendorModels.append(0x052E, "LEDVANCE GmbH");
        vendorModels.append(0x052F, "Center ID Corp.");
        vendorModels.append(0x0530, "Adolene, Inc.");
        vendorModels.append(0x0531, "D&M Holdings Inc.");
        vendorModels.append(0x0532, "CRESCO Wireless, Inc.");
        vendorModels.append(0x0533, "Nura Operations Pty Ltd");
        vendorModels.append(0x0534, "Frontiergadget, Inc.");
        vendorModels.append(0x0535, "Smart Component Technologies Limited");
        vendorModels.append(0x0536, "ZTR Control Systems LLC");
        vendorModels.append(0x0537, "MetaLogics Corporation");
        vendorModels.append(0x0538, "Medela AG");
        vendorModels.append(0x0539, "OPPLE Lighting Co.,Ltd");
        vendorModels.append(0x053A, "Savitech Corp.);");
        vendorModels.append(0x053B, "prodigy");
        vendorModels.append(0x053C, "Screenovate Technologies Ltd");
        vendorModels.append(0x053D, "TESA SA");
        vendorModels.append(0x053E, "CLIM8 LIMITED");
        vendorModels.append(0x053F, "Silergy Corp");
        vendorModels.append(0x0540, "SilverPlus, Inc");
        vendorModels.append(0x0541, "Sharknet srl");
        vendorModels.append(0x0542, "Mist Systems, Inc.");
        vendorModels.append(0x0543, "MIWA LOCK CO.);Ltd");
        vendorModels.append(0x0544, "OrthoSensor, Inc.");
        vendorModels.append(0x0545, "Candy Hoover Group s.r.l");
        vendorModels.append(0x0546, "Apexar Technologies S.A.");
        vendorModels.append(0x0547, "LOGICDATA d.o.o.");
        vendorModels.append(0x0548, "Knick Elektronische Messgeraete GmbH & Co. KG");
        vendorModels.append(0x0549, "Smart Technologies and Investment Limited");
        vendorModels.append(0x054A, "Linough Inc.");
        vendorModels.append(0x054B, "Advanced Electronic Designs, Inc.");
        vendorModels.append(0x054C, "Carefree Scott Fetzer Co Inc");
        vendorModels.append(0x054D, "Sensome");
        vendorModels.append(0x054E, "FORTRONIK storitve d.o.o.");
        vendorModels.append(0x054F, "Sinnoz");
        vendorModels.append(0x0550, "Versa Networks, Inc.");
        vendorModels.append(0x0551, "Sylero");
        vendorModels.append(0x0552, "Avempace SARL");
        vendorModels.append(0x0553, "Nintendo Co.,Ltd.");
        vendorModels.append(0x0554, "National Instruments");
        vendorModels.append(0x0555, "KROHNE Messtechnik GmbH");
        vendorModels.append(0x0556, "Otodynamics Ltd");
        vendorModels.append(0x0557, "Arwin Technology Limited");
        vendorModels.append(0x0558, "benegear, Inc.");
        vendorModels.append(0x0559, "Newcon Optik");
        vendorModels.append(0x055A, "CANDY HOUSE, Inc.");
        vendorModels.append(0x055B, "FRANKLIN TECHNOLOGY INC");
        vendorModels.append(0x055C, "Lely");
        vendorModels.append(0x055D, "Valve Corporation");
        vendorModels.append(0x055E, "Hekatron Vertriebs GmbH");
        vendorModels.append(0x055F, "PROTECH S.A.S. DI GIRARDI ANDREA & C.");
        vendorModels.append(0x0560, "Sarita CareTech IVS");
        vendorModels.append(0x0561, "Finder S.p.A.");
        vendorModels.append(0x0562, "Thalmic Labs Inc.");
        vendorModels.append(0x0563, "Steinel Vertrieb GmbH");
        vendorModels.append(0x0564, "Beghelli Spa");
        vendorModels.append(0x0565, "Beijing Smartspace Technologies Inc.");
        vendorModels.append(0x0566, "CORE TRANSPORT TECHNOLOGIES NZ LIMITED");
        vendorModels.append(0x0567, "Xiamen Everesports Goods Co.,Ltd");
        vendorModels.append(0x0568, "Bodyport Inc.");
        vendorModels.append(0x0569, "Audionics System, Inc.");
        vendorModels.append(0x056A, "Flipnavi Co.);Ltd.");
        vendorModels.append(0x056B, "Rion Co.,Ltd.");
        vendorModels.append(0x056C, "Long AddressRange Systems,LLC");
        vendorModels.append(0x056D, "Redmond Industrial Group LLC");
        vendorModels.append(0x056E, "VIZPIN INC.");
        vendorModels.append(0x056F, "BikeFinder AS");
        vendorModels.append(0x0570, "Consumer Sleep Solutions LLC");
        vendorModels.append(0x0571, "PSIKICK, Inc.");
        vendorModels.append(0x0572, "AntTail.com");
        vendorModels.append(0x0573, "Lighting Science Group Corp.");
        vendorModels.append(0x0574, "AFFORDABLE ELECTRONICS INC");
        vendorModels.append(0x0575, "Integral Memroy Plc");
        vendorModels.append(0x0576, "Globalstar, Inc.");
        vendorModels.append(0x0577, "True Wearables, Inc.");
        vendorModels.append(0x0578, "Wellington Drive Technologies Ltd");
        vendorModels.append(0x0579, "Ensemble Tech Private Limited");
        vendorModels.append(0x057A, "OMNI Remotes");
        vendorModels.append(0x057B, "Duracell U.S. Operations Inc.");
        vendorModels.append(0x057C, "Toor Technologies LLC");
        vendorModels.append(0x057D, "Instinct Performance");
        vendorModels.append(0x057E, "Beco, Inc");
        vendorModels.append(0x057F, "Scuf Gaming International,LLC");
        vendorModels.append(0x0580, "ARANZ Medical Limited");
        vendorModels.append(0x0581, "LYS TECHNOLOGIES LTD");
        vendorModels.append(0x0582, "Breakwall Analytics,LLC");
        vendorModels.append(0x0583, "Code Blue Communications");
        vendorModels.append(0x0584, "Gira Giersiepen GmbH & Co. KG");
        vendorModels.append(0x0585, "Hearing Lab Technology");
        vendorModels.append(0x0586, "LEGRAND");
        vendorModels.append(0x0587, "Derichs GmbH");
        vendorModels.append(0x0588, "ALT-TEKNIK LLC");
        vendorModels.append(0x0589, "Star Technologies");
        vendorModels.append(0x058A, "START TODAY CO.);LTD.");
        vendorModels.append(0x058B, "Maxim Integrated Products");
        vendorModels.append(0x058C, "MERCK Kommanditgesellschaft auf Aktien");
        vendorModels.append(0x058D, "Jungheinrich Aktiengesellschaft");
        vendorModels.append(0x058E, "Oculus VR,LLC");
        vendorModels.append(0x058F, "HENDON SEMICONDUCTORS PTY LTD");
        vendorModels.append(0x0590, "Pur3 Ltd");
        vendorModels.append(0x0591, "Viasat Group S.p.A.");
        vendorModels.append(0x0592, "IZITHERM");
        vendorModels.append(0x0593, "Spaulding Clinical Research");
        vendorModels.append(0x0594, "Kohler Company");
        vendorModels.append(0x0595, "Inor Process AB");
        vendorModels.append(0x0596, "My Smart Blinds");
        vendorModels.append(0x0597, "RadioPulse Inc");
        vendorModels.append(0x0598, "rapitag GmbH");
        vendorModels.append(0x0599, "Lazlo326,LLC.");
        vendorModels.append(0x059A, "Teledyne Lecroy, Inc.");
        vendorModels.append(0x059B, "Dataflow Systems Limited");
        vendorModels.append(0x059C, "Macrogiga Electronics");
        vendorModels.append(0x059D, "Tandem Diabetes Care");
        vendorModels.append(0x059E, "Polycom, Inc.");
        vendorModels.append(0x059F, "Fisher & Paykel Healthcare");
        vendorModels.append(0x05A0, "RCP Software Oy");
        vendorModels.append(0x05A1, "Shanghai Xiaoyi Technology Co.);Ltd.");
        vendorModels.append(0x05A2, "ADHERIUM(NZ,LIMITED");
        vendorModels.append(0x05A3, "Axiomware Systems Incorporated");
        vendorModels.append(0x05A4, "O. E. M. Controls, Inc.");
        vendorModels.append(0x05A5, "Kiiroo BV");
        vendorModels.append(0x05A6, "Telecon Mobile Limited");
        vendorModels.append(0x05A7, "Sonos Inc");
        vendorModels.append(0x05A8, "Tom Allebrandi Consulting");
        vendorModels.append(0x05A9, "Monidor");
        vendorModels.append(0x05AA, "Tramex Limited");
        vendorModels.append(0x05AB, "Nofence AS");
        vendorModels.append(0x05AC, "GoerTek Dynaudio Co.,Ltd.");
        vendorModels.append(0x05AD, "INIA");
        vendorModels.append(0x05AE, "CARMATE MFG.CO.);LTD");
        vendorModels.append(0x05AF, "ONvocal");
        vendorModels.append(0x05B0, "NewTec GmbH");
        vendorModels.append(0x05B1, "Medallion Instrumentation Systems");
        vendorModels.append(0x05B2, "CAREL INDUSTRIES S.P.A.");
        vendorModels.append(0x05B3, "Parabit Systems, Inc.");
        vendorModels.append(0x05B4, "White Horse Scientific ltd");
        vendorModels.append(0x05B5, "verisilicon");
        vendorModels.append(0x05B6, "Elecs Industry Co.);Ltd.");
        vendorModels.append(0x05B7, "Beijing Pinecone Electronics Co.);Ltd.");
        vendorModels.append(0x05B8, "Ambystoma Labs Inc.");
        vendorModels.append(0x05B9, "Suzhou Pairlink Network Technology");
        vendorModels.append(0x05BA, "igloohome");
        vendorModels.append(0x05BB, "Oxford Metrics plc");
        vendorModels.append(0x05BC, "Leviton Mfg. Co., Inc.");
        vendorModels.append(0x05BD, "ULC Robotics Inc.");
        vendorModels.append(0x05BE, "RFID Global by Softwork SrL");
        vendorModels.append(0x05BF, "Real-World-Systems Corporation");
        vendorModels.append(0x05C0, "Nalu Medical, Inc.");
        vendorModels.append(0x05C1, "P.I.Engineering");
        vendorModels.append(0x05C2, "Grote Industries");
        vendorModels.append(0x05C3, "Runtime, Inc.");
        vendorModels.append(0x05C4, "Codecoup sp. z o.o. sp. k.");
        vendorModels.append(0x05C5, "SELVE GmbH & Co. KG");
        vendorModels.append(0x05C6, "Smart Animal Training Systems,LLC");
        vendorModels.append(0x05C7, "Lippert Components, Inc");
        vendorModels.append(0x05C8, "SOMFY SAS");
        vendorModels.append(0x05C9, "TBS Electronics B.V.");
        vendorModels.append(0x05CA, "MHL Custom Inc");
        vendorModels.append(0x05CB, "LucentWear LLC");
        vendorModels.append(0x05CC, "WATTS ELECTRONICS");
        vendorModels.append(0x05CD, "RJ Brands LLC");
        vendorModels.append(0x05CE, "V-ZUG Ltd");
        vendorModels.append(0x05CF, "Biowatch SA");
        vendorModels.append(0x05D0, "Anova Applied Electronics");
        vendorModels.append(0x05D1, "Lindab AB");
        vendorModels.append(0x05D2, "frogblue TECHNOLOGY GmbH");
        vendorModels.append(0x05D3, "Acurable Limited");
        vendorModels.append(0x05D4, "LAMPLIGHT Co.,Ltd.");
        vendorModels.append(0x05D5, "TEGAM, Inc.");
        vendorModels.append(0x05D6, "Zhuhai Jieli technology Co.);Ltd");
        vendorModels.append(0x05D7, "modum.io AG");
        vendorModels.append(0x05D8, "Farm Jenny LLC");
        vendorModels.append(0x05D9, "Toyo Electronics Corporation");
        vendorModels.append(0x05DA, "Applied Neural Research Corp");
        vendorModels.append(0x05DB, "Avid Identification Systems, Inc.");
        vendorModels.append(0x05DC, "Petronics Inc.");
        vendorModels.append(0x05DD, "essentim GmbH");
        vendorModels.append(0x05DE, "QT Medical INC.");
        vendorModels.append(0x05DF, "VIRTUALCLINIC.DIRECT LIMITED");
        vendorModels.append(0x05E0, "Viper Design LLC");
        vendorModels.append(0x05E1, "Human, Incorporated");
        vendorModels.append(0x05E2, "stAPPtronics GmbH");
        vendorModels.append(0x05E3, "Elemental Machines, Inc.");
        vendorModels.append(0x05E4, "Taiyo Yuden Co.,Ltd");
        vendorModels.append(0x05E5, "INEO ENERGY& SYSTEMS");
        vendorModels.append(0x05E6, "Motion Instruments Inc.");
        vendorModels.append(0x05E7, "PressurePro");
        vendorModels.append(0x05E8, "COWBOY");
        vendorModels.append(0x05E9, "iconmobile GmbH");
        vendorModels.append(0x05EA, "ACS-Control-System GmbH");
        vendorModels.append(0x05EB, "Bayerische Motoren Werke AG");
        vendorModels.append(0x05EC, "Gycom Svenska AB");
        vendorModels.append(0x05ED, "Fuji Xerox Co.,Ltd");
        vendorModels.append(0x05EE, "Glide Inc.");
        vendorModels.append(0x05EF, "SIKOM AS");
        vendorModels.append(0x05F0, "beken");
        vendorModels.append(0x05F1, "The Linux Foundation");
        vendorModels.append(0x05F2, "Try and E CO.);LTD.");
        vendorModels.append(0x05F3, "SeeScan");
        vendorModels.append(0x05F4, "Clearity,LLC");
        vendorModels.append(0x05F5, "GS TAG");
        vendorModels.append(0x05F6, "DPTechnics");
        vendorModels.append(0x05F7, "TRACMO, Inc.");
        vendorModels.append(0x05F8, "Anki Inc.");
        vendorModels.append(0x05F9, "Hagleitner Hygiene International GmbH");
        vendorModels.append(0x05FA, "Konami Sports Life Co.,Ltd.");
        vendorModels.append(0x05FB, "Arblet Inc.");
        vendorModels.append(0x05FC, "Masbando GmbH");
        vendorModels.append(0x05FD, "Innoseis");
        vendorModels.append(0x05FE, "Niko");
        vendorModels.append(0x05FF, "Wellnomics Ltd");
        vendorModels.append(0x0600, "iRobot Corporation");
        vendorModels.append(0x0601, "Schrader Electronics");
        vendorModels.append(0x0602, "Geberit International AG");
        vendorModels.append(0x0603, "Fourth Evolution Inc");
        vendorModels.append(0x0604, "Cell2Jack LLC");
        vendorModels.append(0x0605, "FMW electronic Futterer u. Maier-Wolf OHG");
        vendorModels.append(0x0606, "John Deere");
        vendorModels.append(0x0607, "Rookery Technology Ltd");
        vendorModels.append(0x0608, "KeySafe-Cloud");
        vendorModels.append(0x0609, "Bchi Labortechnik AG");
        vendorModels.append(0x060A, "IQAir AG");
        vendorModels.append(0x060B, "Triax Technologies Inc");
        vendorModels.append(0x060C, "Vuzix Corporation");
        vendorModels.append(0x060D, "TDK Corporation");
        vendorModels.append(0x060E, "Blueair AB");
        vendorModels.append(0x060F, "Philips Lighting B.V.");
        vendorModels.append(0x0610, "ADH GUARDIAN USA LLC");
        vendorModels.append(0x0611, "Beurer GmbH");
        vendorModels.append(0x0612, "Playfinity AS");
        vendorModels.append(0x0613, "Hans Dinslage GmbH");
        vendorModels.append(0x0614, "OnAsset Intelligence, Inc.");
        vendorModels.append(0x0615, "INTER ACTION Corporation");
        vendorModels.append(0x0616, "OS42 UG (haftungsbeschraenkt);");
        vendorModels.append(0x0617, "WIZCONNECTED COMPANY LIMITED");
        vendorModels.append(0x0618, "Audio-Technica Corporation");
        vendorModels.append(0x0619,	"Six Guys Labs, s.r.o.");
        vendorModels.append(0x061A,	"R.W. Beckett Corporation");
        vendorModels.append(0x061B,	"silex technology, inc.");
        vendorModels.append(0x061C,	"Univations Limited");
        vendorModels.append(0x061D,	"SENS Innovation ApS");
        vendorModels.append(0x061E,	"Diamond Kinetics, Inc.");
        vendorModels.append(0x061F,	"Phrame Inc.");
        vendorModels.append(0x0620,	"Forciot Oy");
        vendorModels.append(0x0621,	"Noordung d.o.o.");
        vendorModels.append(0x0622,	"Beam Labs, LLC");
        vendorModels.append(0x0623,	"Philadelphia Scientific (U.K.) Limited");
        vendorModels.append(0x0624,	"Biovotion AG");
        vendorModels.append(0x0625,	"Square Panda, Inc.");
        vendorModels.append(0x0626,	"Amplifico");
        vendorModels.append(0x0627,	"WEG S.A.");
        vendorModels.append(0x0628,	"Ensto Oy");
        vendorModels.append(0x0629,	"PHONEPE PVT LTD");
        vendorModels.append(0x062A,	"Lunatico Astronomia SL");
        vendorModels.append(0x062B,	"MinebeaMitsumi Inc.");
        vendorModels.append(0x062C,	"ASPion GmbH");
        vendorModels.append(0x062D,	"Vossloh-Schwabe Deutschland GmbH");
        vendorModels.append(0x062E,	"Procept");
        vendorModels.append(0x062F,	"ONKYO Corporation");
        vendorModels.append(0x0630,	"Asthrea D.O.O.");
        vendorModels.append(0x0631,	"Fortiori Design LLC");
        vendorModels.append(0x0632,	"Hugo Muller GmbH & Co KG");
        vendorModels.append(0x0633,	"Wangi Lai PLT");
        vendorModels.append(0x0634,	"Fanstel Corp");
        vendorModels.append(0x0635,	"Crookwood");
        vendorModels.append(0x0636,	"ELECTRONICA INTEGRAL DE SONIDO S.A.");
        vendorModels.append(0x0637,	"GiP Innovation Tools GmbH");
        vendorModels.append(0x0638,	"LX SOLUTIONS PTY LIMITED");
        vendorModels.append(0x0639,	"Shenzhen Minew Technologies Co., Ltd.");
        vendorModels.append(0x063A,	"Prolojik Limited");
        vendorModels.append(0x063B,	"Kromek Group Plc");
        vendorModels.append(0x063C,	"Contec Medical Systems Co., Ltd.");
        vendorModels.append(0x063D,	"Xradio Technology Co.,Ltd.");
        vendorModels.append(0x063E,	"The Indoor Lab, LLC");
        vendorModels.append(0x063F,	"LDL TECHNOLOGY");
        vendorModels.append(0x0640,	"Parkifi");
        vendorModels.append(0x0641,	"Revenue Collection Systems FRANCE SAS");
        vendorModels.append(0x0642,	"Bluetrum Technology Co.,Ltd");
        vendorModels.append(0x0643,	"makita corporation");
        vendorModels.append(0x0644,	"Apogee Instruments");
        vendorModels.append(0x0645,	"BM3");
        vendorModels.append(0x0646,	"SGV Group Holding GmbH & Co. KG");
        vendorModels.append(0x0647,	"MED-EL");
        vendorModels.append(0x0648,	"Ultune Technologies");
        vendorModels.append(0x0649,	"Ryeex Technology Co.,Ltd.");
        vendorModels.append(0x064A,	"Open Research Institute, Inc.");
        vendorModels.append(0x064B,	"Scale-Tec, Ltd");
        vendorModels.append(0x064C,	"Zumtobel Group AG");
        vendorModels.append(0x064D,	"iLOQ Oy");
        vendorModels.append(0x064E,	"KRUXWorks Technologies Private Limited");
        vendorModels.append(0x064F,	"Digital Matter Pty Ltd");
        vendorModels.append(0x0650,	"Coravin, Inc.");
        vendorModels.append(0x0651,	"Stasis Labs, Inc.");
        vendorModels.append(0x0652,	"ITZ Innovations- und Technologiezentrum GmbH");
        vendorModels.append(0x0653,	"Meggitt SA");
        vendorModels.append(0x0654,	"Ledlenser GmbH & Co. KG");
        vendorModels.append(0x0655,	"Renishaw PLC");
        vendorModels.append(0x0656,	"ZhuHai AdvanPro Technology Company Limited");
        vendorModels.append(0x0657,	"Meshtronix Limited");
        vendorModels.append(0x0658,	"Payex Norge AS");
        vendorModels.append(0x0659,	"UnSeen Technologies Oy");
        vendorModels.append(0x065A,	"Zound Industries International AB");
        vendorModels.append(0x065B,	"Sesam Solutions BV");
        vendorModels.append(0x065C,	"PixArt Imaging Inc.");
        vendorModels.append(0x065D,	"Panduit Corp.");
        vendorModels.append(0x065E,	"Alo AB");
        vendorModels.append(0x065F,	"Ricoh Company Ltd");
        vendorModels.append(0x0660,	"RTC Industries, Inc.");
        vendorModels.append(0x0661,	"Mode Lighting Limited");
        vendorModels.append(0x0662,	"Particle Industries, Inc.");
        vendorModels.append(0x0663,	"Advanced Telemetry Systems, Inc.");
        vendorModels.append(0x0664,	"RHA TECHNOLOGIES LTD");
        vendorModels.append(0x0665,	"Pure International Limited");
        vendorModels.append(0x0666,	"WTO Werkzeug-Einrichtungen GmbH");
        vendorModels.append(0x0667,	"Spark Technology Labs Inc.");
        vendorModels.append(0x0668,	"Bleb Technology srl");
        vendorModels.append(0x0669,	"Livanova USA, Inc.");
        vendorModels.append(0x066A,	"Brady Worldwide Inc.");
        vendorModels.append(0x066B,	"DewertOkin GmbH");
        vendorModels.append(0x066C,	"Ztove ApS");
        vendorModels.append(0x066D,	"Venso EcoSolutions AB");
        vendorModels.append(0x066E,	"Eurotronik Kranj d.o.o.");
        vendorModels.append(0x066F,	"Hug Technology Ltd");
        vendorModels.append(0x0670,	"Gema Switzerland GmbH");
        vendorModels.append(0x0671,	"Buzz Products Ltd.");
        vendorModels.append(0x0672,	"Kopi");
        vendorModels.append(0x0673,	"Innova Ideas Limited");
        vendorModels.append(0x0674,	"BeSpoon");
        vendorModels.append(0x0675,	"Deco Enterprises, Inc.");
        vendorModels.append(0x0676,	"Expai Solutions Private Limited");
        vendorModels.append(0x0677,	"Innovation First, Inc.");
        vendorModels.append(0x0678,	"SABIK Offshore GmbH");
        vendorModels.append(0x0679,	"4iiii Innovations Inc.");
        vendorModels.append(0x067A,	"The Energy Conservatory, Inc.");
        vendorModels.append(0x067B,	"I.FARM, INC.");
        vendorModels.append(0x067C,	"Tile, Inc.");
        vendorModels.append(0x067D,	"Form Athletica Inc.");
        vendorModels.append(0x067E,	"MbientLab Inc");
        vendorModels.append(0x067F,	"NETGRID S.N.C. DI BISSOLI MATTEO, CAMPOREALE SIMONE, TOGNETTI FEDERICO");
        vendorModels.append(0x0680,	"Mannkind Corporation");
        vendorModels.append(0x0681,	"Trade FIDES a.s.");
        vendorModels.append(0x0682,	"Photron Limited");
        vendorModels.append(0x0683,	"Eltako GmbH");
        vendorModels.append(0x0684,	"Dermalapps, LLC");
        vendorModels.append(0x0685,	"Greenwald Industries");
        vendorModels.append(0x0686,	"inQs Co., Ltd.");
        vendorModels.append(0x0687,	"Cherry GmbH");
        vendorModels.append(0x0688,	"Amsted Digital Solutions Inc.");
        vendorModels.append(0x0689,	"Tacx b.v.");
        vendorModels.append(0x068A,	"Raytac Corporation");
        vendorModels.append(0x068B,	"Jiangsu Teranovo Tech Co., Ltd.");
        vendorModels.append(0x068C,	"Changzhou Sound Dragon Electronics and Acoustics Co., Ltd");
        vendorModels.append(0x068D,	"JetBeep Inc.");
        vendorModels.append(0x068E,	"Razer Inc.");
        vendorModels.append(0x068F,	"JRM Group Limited");
        vendorModels.append(0x0690,	"Eccrine Systems, Inc.");
        vendorModels.append(0x0691,	"Curie Point AB");
        vendorModels.append(0x0692,	"Georg Fischer AG");
        vendorModels.append(0x0693,	"Hach - Danaher");
        vendorModels.append(0x0694,	"T&A Laboratories LLC");
        vendorModels.append(0x0695,	"Koki Holdings Co., Ltd.");
        vendorModels.append(0x0696,	"Gunakar Private Limited");
        vendorModels.append(0x0697,	"Stemco Products Inc");
        vendorModels.append(0x0698,	"Wood IT Security, LLC");
        vendorModels.append(0x0699,	"RandomLab SAS");
        vendorModels.append(0x069A,	"Adero, Inc. (formerly as TrackR, Inc.)");
        vendorModels.append(0x069B,	"Dragonchip Limited");
        vendorModels.append(0x069C,	"Noomi AB");
        vendorModels.append(0x069D,	"Vakaros LLC");
        vendorModels.append(0x069E,	"Delta Electronics, Inc.");
        vendorModels.append(0x069F,	"FlowMotion Technologies AS");
        vendorModels.append(0x06A0,	"OBIQ Location Technology Inc.");
        vendorModels.append(0x06A1,	"Cardo Systems, Ltd");
        vendorModels.append(0x06A2,	"Globalworx GmbH");
        vendorModels.append(0x06A3,	"Nymbus, LLC");
        vendorModels.append(0x06A4,	"Sanyo Techno Solutions Tottori Co., Ltd.");
        vendorModels.append(0x06A5,	"TEKZITEL PTY LTD");
        vendorModels.append(0x06A6,	"Roambee Corporation");
        vendorModels.append(0x06A7,	"Chipsea Technologies (ShenZhen) Corp.");
        vendorModels.append(0x06A8,	"GD Midea Air-Conditioning Equipment Co., Ltd.");
        vendorModels.append(0x06A9,	"Soundmax Electronics Limited");
        vendorModels.append(0x06AA,	"Produal Oy");
        vendorModels.append(0x06AB,	"HMS Industrial Networks AB");
        vendorModels.append(0x06AC,	"Ingchips Technology Co., Ltd.");
        vendorModels.append(0x06AD,	"InnovaSea Systems Inc.");
        vendorModels.append(0x06AE,	"SenseQ Inc.");
        vendorModels.append(0x06AF,	"Shoof Technologies");
        vendorModels.append(0x06B0,	"BRK Brands, Inc.");
        vendorModels.append(0x06B1,	"SimpliSafe, Inc.");
        vendorModels.append(0x06B2,	"Tussock Innovation 2013 Limited");
        vendorModels.append(0x06B3,	"The Hablab ApS");
        vendorModels.append(0x06B4,	"Sencilion Oy");
        vendorModels.append(0x06B5,	"Wabilogic Ltd.");
        vendorModels.append(0x06B6,	"Sociometric Solutions, Inc.");
        vendorModels.append(0x06B7,	"iCOGNIZE GmbH");
        vendorModels.append(0x06B8,	"ShadeCraft, Inc");
        vendorModels.append(0x06B9,	"Beflex Inc.");
        vendorModels.append(0x06BA,	"Beaconzone Ltd");
        vendorModels.append(0x06BB,	"Leaftronix Analogic Solutions Private Limited");
        vendorModels.append(0x06BC,	"TWS Srl");
        vendorModels.append(0x06BD,	"ABB Oy");
        vendorModels.append(0x06BE,	"HitSeed Oy");
        vendorModels.append(0x06BF,	"Delcom Products Inc.");
        vendorModels.append(0x06C0,	"CAME S.p.A.");
        vendorModels.append(0x06C1,	"Alarm.com Holdings, Inc");
        vendorModels.append(0x06C2,	"Measurlogic Inc.");
        vendorModels.append(0x06C3,	"King I Electronics.Co.,Ltd");
        vendorModels.append(0x06C4,	"Dream Labs GmbH");
        vendorModels.append(0x06C5,	"Urban Compass, Inc");
        vendorModels.append(0x06C6,	"Simm Tronic Limited");
        vendorModels.append(0x06C7,	"Somatix Inc");
        vendorModels.append(0x06C8,	"Storz & Bickel GmbH & Co. KG");
        vendorModels.append(0x06C9,	"MYLAPS B.V.");
        vendorModels.append(0x06CA,	"Shenzhen Zhongguang Infotech Technology Development Co., Ltd");
        vendorModels.append(0x06CB,	"Dyeware, LLC");
        vendorModels.append(0x06CC,	"Dongguan SmartAction Technology Co.,Ltd.");
        vendorModels.append(0x06CD,	"DIG Corporation");
        vendorModels.append(0x06CE,	"FIOR & GENTZ");
        vendorModels.append(0x06CF,	"Belparts N.V.");
        vendorModels.append(0x06D0,	"Etekcity Corporation");
        vendorModels.append(0x06D1,	"Meyer Sound Laboratories, Incorporated");
        vendorModels.append(0x06D2,	"CeoTronics AG");
        vendorModels.append(0x06D3,	"TriTeq Lock and Security, LLC");
        vendorModels.append(0x06D4,	"DYNAKODE TECHNOLOGY PRIVATE LIMITED");
        vendorModels.append(0x06D5,	"Sensirion AG");
        vendorModels.append(0x06D6,	"JCT Healthcare Pty Ltd");
        vendorModels.append(0x06D7,	"FUBA Automotive Electronics GmbH");
        vendorModels.append(0x06D8,	"AW Company");
        vendorModels.append(0x06D9,	"Shanghai Mountain View Silicon Co.,Ltd.");
        vendorModels.append(0x06DA,	"Zliide Technologies ApS");
        vendorModels.append(0x06DB,	"Automatic Labs, Inc.");
        vendorModels.append(0x06DC,	"Industrial Network Controls, LLC");
        vendorModels.append(0x06DD,	"Intellithings Ltd.");
        vendorModels.append(0x06DE,	"Navcast, Inc.");
        vendorModels.append(0x06DF,	"Hubbell Lighting, Inc.");
        vendorModels.append(0x06E0,	"Avaya");
        vendorModels.append(0x06E1,	"Milestone AV Technologies LLC");
        vendorModels.append(0x06E2,	"Alango Technologies Ltd");
        vendorModels.append(0x06E3,	"Spinlock Ltd");
        vendorModels.append(0x06E4,	"Aluna");
        vendorModels.append(0x06E5,	"OPTEX CO.,LTD.");
        vendorModels.append(0x06E6,	"NIHON DENGYO KOUSAKU");
        vendorModels.append(0x06E7,	"VELUX A/S");
        vendorModels.append(0x06E8,	"Almendo Technologies GmbH");
        vendorModels.append(0x06E9,	"Zmartfun Electronics, Inc.");
        vendorModels.append(0x06EA,	"SafeLine Sweden AB");
        vendorModels.append(0x06EB,	"Houston Radar LLC");
        vendorModels.append(0x06EC,	"Sigur");
        vendorModels.append(0x06ED,	"J Neades Ltd");
        vendorModels.append(0x06EE,	"Avantis Systems Limited");
        vendorModels.append(0x06EF,	"ALCARE Co., Ltd.");
        vendorModels.append(0x06F0,	"Chargy Technologies, SL");
        vendorModels.append(0x06F1,	"Shibutani Co., Ltd.");
        vendorModels.append(0x06F2,	"Trapper Data AB");
        vendorModels.append(0x06F3,	"Alfred International Inc.");
        vendorModels.append(0x06F4,	"Near Field Solutions Ltd");
        vendorModels.append(0x06F5,	"Vigil Technologies Inc.");
        vendorModels.append(0x06F6,	"Vitulo Plus BV");
        vendorModels.append(0x06F7,	"WILKA Schliesstechnik GmbH");
        vendorModels.append(0x06F8,	"BodyPlus Technology Co.,Ltd");
        vendorModels.append(0x06F9,	"happybrush GmbH");
        vendorModels.append(0x06FA,	"Enequi AB");
        vendorModels.append(0x06FB,	"Sartorius AG");
        vendorModels.append(0x06FC,	"Tom Communication Industrial Co.,Ltd.");
        vendorModels.append(0x06FD,	"ESS Embedded System Solutions Inc.");
        vendorModels.append(0x06FE,	"Mahr GmbH");
        vendorModels.append(0x06FF,	"Redpine Signals Inc");
        vendorModels.append(0x0700,	"TraqFreq LLC");
        vendorModels.append(0x0701,	"PAFERS TECH");
        vendorModels.append(0x0702,	"Akciju sabiedriba \"SAF TEHNIKA\"");
        vendorModels.append(0x0703,	"Beijing Jingdong Century Trading Co., Ltd.");
        vendorModels.append(0x0704,	"JBX Designs Inc.");
        vendorModels.append(0x0705,	"AB Electrolux");
        vendorModels.append(0x0706,	"Wernher von Braun Center for ASdvanced Research");
        vendorModels.append(0x0707,	"Essity Hygiene and Health Aktiebolag");
        vendorModels.append(0x0708,	"Be Interactive Co., Ltd");
        vendorModels.append(0x0709,	"Carewear Corp.");
        vendorModels.append(0x070A,	"Huf Hlsbeck & Frst GmbH & Co. KG");
        vendorModels.append(0x070B,	"Element Products, Inc.");
        vendorModels.append(0x070C,	"Beijing Winner Microelectronics Co.,Ltd");
        vendorModels.append(0x070D,	"SmartSnugg Pty Ltd");
        vendorModels.append(0x070E,	"FiveCo Sarl");
        vendorModels.append(0x070F,	"California Things Inc.");
        vendorModels.append(0x0710,	"Audiodo AB");
        vendorModels.append(0x0711,	"ABAX AS");
        vendorModels.append(0x0712,	"Bull Group Company Limited");
        vendorModels.append(0x0713,	"Respiri Limited");
        vendorModels.append(0x0714,	"MindPeace Safety LLC");
        vendorModels.append(0x0715,	"Vgyan Solutions");
        vendorModels.append(0x0716,	"Altonics");
        vendorModels.append(0x0717,	"iQsquare BV");
        vendorModels.append(0x0718,	"IDIBAIX enginneering");
        vendorModels.append(0x0719,	"ECSG");
        vendorModels.append(0x071A,	"REVSMART WEARABLE HK CO LTD");
        vendorModels.append(0x071B,	"Precor");
        vendorModels.append(0x071C,	"F5 Sports, Inc");
        vendorModels.append(0x071D,	"exoTIC Systems");
        vendorModels.append(0x071E,	"DONGGUAN HELE ELECTRONICS CO., LTD");
        vendorModels.append(0x071F,	"Dongguan Liesheng Electronic Co.Ltd");
        vendorModels.append(0x0720,	"Oculeve, Inc.");
        vendorModels.append(0x0721,	"Clover Network, Inc.");
        vendorModels.append(0x0722,	"Xiamen Eholder Electronics Co.Ltd");
        vendorModels.append(0x0723,	"Ford Motor Company");
        vendorModels.append(0x0724,	"Guangzhou SuperSound Information Technology Co.,Ltd");
        vendorModels.append(0x0725,	"Tedee Sp. z o.o.");
        vendorModels.append(0x0726,	"PHC Corporation");
        vendorModels.append(0x0727,	"STALKIT AS");
        vendorModels.append(0x0728,	"Eli Lilly and Company");
        vendorModels.append(0x0729,	"SwaraLink Technologies");
        vendorModels.append(0x072A,	"JMR embedded systems GmbH");
        vendorModels.append(0x072B,	"Bitkey Inc.");
        vendorModels.append(0x072C,	"GWA Hygiene GmbH");
        vendorModels.append(0x072D,	"Safera Oy");
        vendorModels.append(0x072E,	"Open Platform Systems LLC");
        vendorModels.append(0x072F,	"OnePlus Electronics (Shenzhen) Co., Ltd.");
        vendorModels.append(0x0730,	"Wildlife Acoustics, Inc.");
        vendorModels.append(0x0731,	"ABLIC Inc.");
        vendorModels.append(0x0732,	"Dairy Tech, Inc.");
        vendorModels.append(0x0733,	"Iguanavation, Inc.");
        vendorModels.append(0x0734,	"DiUS Computing Pty Ltd");
        vendorModels.append(0x0735,	"UpRight Technologies LTD");
        vendorModels.append(0x0736,	"FrancisFund, LLC");
        vendorModels.append(0x0737,	"LLC Navitek");
        vendorModels.append(0x0738,	"Glass Security Pte Ltd");
        vendorModels.append(0x0739,	"Jiangsu Qinheng Co., Ltd.");
        vendorModels.append(0x073A,	"Chandler Systems Inc.");
        vendorModels.append(0x073B,	"Fantini Cosmi s.p.a.");
        vendorModels.append(0x073C,	"Acubit ApS");
        vendorModels.append(0x073D,	"Beijing Hao Heng Tian Tech Co., Ltd.");
        vendorModels.append(0x073E,	"Bluepack S.R.L.");
        vendorModels.append(0x073F,	"Beijing Unisoc Technologies Co., Ltd.");
        vendorModels.append(0x0740,	"HITIQ LIMITED");
        vendorModels.append(0x0741,	"MAC SRL");
        vendorModels.append(0x0742,	"DML LLC");
        vendorModels.append(0x0743,	"Sanofi");
    }

    /**
     * Returns the company name for the given company identifier
     *
     * @param companyIdentifier 16-bit company identifier
     * @return company name;
     */
    public static String getCompanyName(final short companyIdentifier) {
        final String companyName = vendorModels.get(companyIdentifier);
        return companyName == null ? "Company ID unavailable" : companyName;
    }
}
