/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.Index;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.google.gson.annotations.Expose;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshTypeConverters;

@Entity(tableName="scene", foreignKeys={@ForeignKey(entity=MeshNetwork.class, parentColumns={"mesh_uuid"}, childColumns={"mesh_uuid"}, onUpdate=5, onDelete=5)}, indices={@Index(value={"mesh_uuid"})})
public class Scene
implements Parcelable {
    @Expose
    @ColumnInfo(name="mesh_uuid")
    private final String meshUuid;
    @Expose
    @ColumnInfo(name="name")
    private String name = "nRF Scene";
    @Expose
    @TypeConverters(value={MeshTypeConverters.class})
    protected List<Integer> addresses = new ArrayList<Integer>();
    @Expose
    @PrimaryKey
    @ColumnInfo(name="number")
    private int number;
    public static final Parcelable.Creator<Scene> CREATOR = new Parcelable.Creator<Scene>(){

        public Scene createFromParcel(Parcel in) {
            return new Scene(in);
        }

        public Scene[] newArray(int size) {
            return new Scene[size];
        }
    };

    public Scene(int number, @NonNull String meshUuid) {
        this.number = number;
        this.meshUuid = meshUuid;
    }

    @Ignore
    public Scene(int number, @NonNull List<Integer> addresses, @NonNull String meshUuid) {
        this.number = number;
        this.addresses.addAll(addresses);
        this.meshUuid = meshUuid;
    }

    protected Scene(Parcel in) {
        this.meshUuid = in.readString();
        this.name = in.readString();
        this.number = in.readInt();
    }

    public String getMeshUuid() {
        return this.meshUuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Integer> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public void setAddresses(List<Integer> addresses) {
        this.addresses.clear();
        this.addresses.addAll(addresses);
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.meshUuid);
        dest.writeString(this.name);
        dest.writeInt(this.number);
    }

    public static boolean isValidSceneNumber(int sceneNumber) {
        if (sceneNumber > 0 && sceneNumber <= 65535) {
            return true;
        }
        throw new IllegalArgumentException("Scene number must range from 0x0001 to 0xFFFF!");
    }

    public static String formatSceneNumber(int number, boolean add0x) {
        return add0x ? "0x" + String.format(Locale.US, "%04X", number) : String.format(Locale.US, "%04X", number);
    }

    public String toString() {
        return "Scene{meshUuid='" + this.meshUuid + '\'' + ", name='" + this.name + '\'' + ", addresses=" + this.addresses + ", number=" + this.number + '}';
    }
}

