/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.sensorutils.Bool;
import no.nordicsemi.android.mesh.sensorutils.Coefficient;
import no.nordicsemi.android.mesh.sensorutils.Count;
import no.nordicsemi.android.mesh.sensorutils.DateUtc;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.sensorutils.FixedString;
import no.nordicsemi.android.mesh.sensorutils.Humidity;
import no.nordicsemi.android.mesh.sensorutils.Illuminance;
import no.nordicsemi.android.mesh.sensorutils.PerceivedLightness;
import no.nordicsemi.android.mesh.sensorutils.Percentage8;
import no.nordicsemi.android.mesh.sensorutils.Pressure;
import no.nordicsemi.android.mesh.sensorutils.Temperature;
import no.nordicsemi.android.mesh.sensorutils.TimeHour24;
import no.nordicsemi.android.mesh.sensorutils.TimeMillisecond24;
import no.nordicsemi.android.mesh.sensorutils.TimeSecond;
import no.nordicsemi.android.mesh.sensorutils.UnknownCharacteristic;
import no.nordicsemi.android.mesh.utils.SensorFormat;

public enum DeviceProperty {
    AVERAGE_AMBIENT_TEMPERATURE_IN_A_PERIOD_OF_DAY(1),
    AVERAGE_INPUT_CURRENT(2),
    AVERAGE_INPUT_VOLTAGE(3),
    AVERAGE_OUTPUT_CURRENT(4),
    AVERAGE_OUTPUT_VOLTAGE(5),
    CENTER_BEAM_INTENSITY_AT_FULL_POWER(6),
    CHROMATICITY_TOLERANCE(7),
    COLOR_RENDERING_INDEX_R9(8),
    COLOR_RENDERING_INDEX_RA(9),
    DEVICE_APPEARANCE(10),
    DEVICE_COUNTRY_OF_ORIGIN(11),
    DEVICE_DATE_OF_MANUFACTURE(12),
    DEVICE_ENERGY_USE_SINCE_TURN_ON(13),
    DEVICE_FIRMWARE_REVISION(14),
    DEVICE_GLOBAL_TRADE_ITEM_NUMBER(15),
    DEVICE_HARDWARE_REVISION(16),
    DEVICE_MANUFACTURER_NAME(17),
    DEVICE_MODEL_NUMBER(18),
    DEVICE_OPERATING_TEMPERATURE_RANGE_SPECIFICATION(19),
    DEVICE_OPERATING_TEMPERATURE_STATISTICAL_VALUES(20),
    DEVICE_OVER_TEMPERATURE_EVENT_STATISTICS(21),
    DEVICE_POWER_RANGE_SPECIFICATION(22),
    DEVICE_RUN_TIME_SINCE_TURN_ON(23),
    DEVICE_RUNTIME_WARRANTY(24),
    DEVICE_SERIAL_NUMBER(25),
    DEVICE_SOFTWARE_REVISION(26),
    DEVICE_UNDER_TEMPERATURE_EVENT_STATISTICS(27),
    INDOOR_AMBIENT_TEMPERATURE_STATISTICAL_VALUES(28),
    INITIAL_CIE1931_CHROMATICITY_COORDINATES(29),
    INITIAL_CORRELATED_COLOR_TEMPERATURE(30),
    INITIAL_LUMINOUS_FLUX(31),
    INITIAL_PLANCKIAN_DISTANCE(32),
    INPUT_CURRENT_RANGE_SPECIFICATION(33),
    INPUT_CURRENT_STATISTICS(34),
    INPUT_OVER_CURRENT_EVENT_STATISTICS(35),
    INPUT_OVER_RIPPLE_VOLTAGE_EVENT_STATISTICS(36),
    INPUT_OVER_VOLTAGE_EVENT_STATISTICS(37),
    INPUT_UNDERCURRENT_EVENT_STATISTICS(38),
    INPUT_UNDER_VOLTAGE_EVENT_STATISTICS(39),
    INPUT_VOLTAGE_RANGE_SPECIFICATION(40),
    INPUT_VOLTAGE_RIPPLE_SPECIFICATION(41),
    INPUT_VOLTAGE_STATISTICS(42),
    LIGHT_CONTROL_AMBIENT_LUX_LEVEL_ON(43),
    LIGHT_CONTROL_AMBIENT_LUX_LEVEL_PROLONG(44),
    LIGHT_CONTROL_AMBIENT_LUX_LEVEL_STANDBY(45),
    LIGHT_CONTROL_LIGHTNESS_ON(46),
    LIGHT_CONTROL_LIGHTNESS_PROLONG(47),
    LIGHT_CONTROL_LIGHTNESS_STANDBY(48),
    LIGHT_CONTROL_REGULATOR_ACCURACY(49),
    LIGHT_CONTROL_REGULATOR_KID(50),
    LIGHT_CONTROL_REGULATOR_KIU(51),
    LIGHT_CONTROL_REGULATOR_KPD(52),
    LIGHT_CONTROL_REGULATOR_KPU(53),
    LIGHT_CONTROL_TIME_FADE(54),
    LIGHT_CONTROL_TIME_FADE_ON(55),
    LIGHT_CONTROL_TIME_FADE_STANDBY_AUTO(56),
    LIGHT_CONTROL_TIME_FADE_STANDBY_MANUAL(57),
    LIGHT_CONTROL_TIME_OCCUPANCY_DELAY(58),
    LIGHT_CONTROL_TIME_PROLONG(59),
    LIGHT_CONTROL_TIME_RUN_ON(60),
    LUMEN_MAINTENANCE_FACTOR(61),
    LUMINOUS_EFFICACY(62),
    LUMINOUS_ENERGY_SINCE_TURN_ON(63),
    LUMINOUS_EXPOSURE(64),
    LUMINOUS_FLUX_RANGE(65),
    MOTION_SENSED(66),
    MOTION_THRESHOLD(67),
    OPEN_CIRCUIT_EVENT_STATISTICS(68),
    OUTDOOR_STATISTICAL_VALUES(69),
    OUTPUT_CURRENT_RANGE(70),
    OUTPUT_CURRENT_STATISTICS(71),
    OUTPUT_RIPPLE_VOLTAGE_SPECIFICATION(72),
    OUTPUT_VOLTAGE_RANGE(73),
    OUTPUT_VOLTAGE_STATISTICS(74),
    OVER_OUTPUT_RIPPLE_VOLTAGE_EVENT_STATISTICS(75),
    PEOPLE_COUNT(76),
    PRESENCE_DETECTED(77),
    PRESENT_AMBIENT_LIGHT_LEVEL(78),
    PRESENT_AMBIENT_TEMPERATURE(79),
    PRESENT_CIE1931_CHROMATICITY_COORDINATES(80),
    PRESENT_CORRELATED_COLOR_TEMPERATURE(81),
    PRESENT_DEVICE_INPUT_POWER(82),
    PRESENT_DEVICE_OPERATING_EFFICIENCY(83),
    PRESENT_DEVICE_OPERATING_TEMPERATURE(84),
    PRESENT_ILLUMINANCE(85),
    PRESENT_INDOOR_AMBIENT_TEMPERATURE(86),
    PRESENT_INPUT_CURRENT(87),
    PRESENT_INPUT_RIPPLE_VOLTAGE(88),
    PRESENT_INPUT_VOLTAGE(89),
    PRESENT_LUMINOUS_FLUX(90),
    PRESENT_OUTDOOR_AMBIENT_TEMPERATURE(91),
    PRESENT_OUTPUT_CURRENT(92),
    PRESENT_OUTPUT_VOLTAGE(93),
    PRESENT_PLANCKIAN_DISTANCE(94),
    PRESENT_RELATIVE_OUTPUT_RIPPLE_VOLTAGE(95),
    RELATIVE_DEVICE_ENERGY_USE_IN_A_PERIOD_OF_DAY(96),
    RELATIVE_DEVICE_RUNTIME_IN_A_GENERIC_LEVEL_RANGE(97),
    RELATIVE_EXPOSURE_TIME_IN_AN_ILLUMINANCE_RANGE(98),
    RELATIVE_RUNTIME_IN_A_CORRELATED_COLOR_TEMPERATURE_RANGE(99),
    RELATIVE_RUNTIME_IN_A_DEVICE_OPERATING_TEMPERATURE_RANGE(100),
    RELATIVE_RUNTIME_IN_AN_INPUT_CURRENT_RANGE(101),
    RELATIVE_RUNTIME_IN_AN_INPUT_VOLTAGE_RANGE(102),
    SHORT_CIRCUIT_EVENT_STATISTICS(103),
    TIME_SINCE_MOTION_SENSED(104),
    TIME_SINCE_PRESENCE_DETECTED(105),
    TOTAL_DEVICE_ENERGY_USE(106),
    TOTAL_DEVICE_OFF_ON_CYCLES(107),
    TOTAL_DEVICE_POWER_ON_CYCLES(108),
    TOTAL_DEVICE_POWER_ON_TIME(109),
    TOTAL_DEVICE_RUNTIME(110),
    TOTAL_LIGHT_EXPOSURE_TIME(111),
    TOTAL_LUMINOUS_ENERGY(112),
    DESIRED_AMBIENT_TEMPERATURE(113),
    PRECISE_TOTAL_DEVICE_ENERGY_USE(114),
    POWER_FACTOR(115),
    SENSOR_GAIN(116),
    PRECISE_PRESENT_AMBIENT_TEMPERATURE(117),
    PRESENT_AMBIENT_RELATIVE_HUMIDITY(118),
    PRESENT_AMBIENT_CARBONDIOXIDE_CONCENTRATION(119),
    PRESENT_AMBIENT_VOLATILE_ORGANIC_COMPOUNDS_CONCENTRATION(120),
    PRESENT_AMBIENT_NOISE(121),
    ACTIVE_ENERGY_LOAD_SIDE(128),
    ACTIVE_POWER_LOAD_SIDE(129),
    AIR_PRESSURE(130),
    APPARENT_ENERGY(131),
    APPARENT_POWER(132),
    APPARENT_WIND_DIRECTION(133),
    APPARENT_WIND_SPEED(134),
    DEW_POINT(135),
    EXTERNAL_SUPPLY_VOLTAGE(136),
    EXTERNAL_SUPPLY_VOLTAGE_FREQUENCY(137),
    GUST_FACTOR(138),
    HEAT_INDEX(139),
    LIGHT_DISTRIBUTION(140),
    LIGHT_SOURCE_CURRENT(141),
    LIGHT_SOURCE_ON_TIME_NOT_RESETTABLE(142),
    LIGHT_SOURCE_ON_TIME_RESETTABLE(143),
    LIGHT_SOURCE_OPEN_CIRCUIT_STATISTICS(144),
    LIGHT_SOURCE_OVERALL_FAILURES_STATISTICS(145),
    LIGHT_SOURCE_SHORT_CIRCUIT_STATISTICS(146),
    LIGHT_SOURCE_START_COUNTER_RESETTABLE(147),
    LIGHT_SOURCE_TEMPERATURE(148),
    LIGHT_SOURCE_THERMAL_DERATING_STATISTICS(149),
    LIGHT_SOURCE_THERMAL_SHUTDOWN_STATISTICS(150),
    LIGHT_SOURCE_TOTAL_POWER_ON_CYCLES(151),
    LIGHT_SOURCE_VOLTAGE(152),
    LUMINAIRE_COLOR(153),
    LUMINAIRE_IDENTIFICATION_NUMBER(154),
    LUMINAIRE_MANUFACTURER_GTIN(155),
    LUMINAIRE_NOMINAL_INPUT_POWER(156),
    LUMINAIRE_NOMINAL_MAXIMUM_AC_MAINS_VOLTAGE(157),
    LUMINAIRE_NOMINAL_MINIMUM_AC_MAINS_VOLTAGE(158),
    LUMINAIRE_POWER_AT_MINIMUM_DIM_LEVEL(159),
    LUMINAIRE_TIME_OF_MANUFACTURE(160),
    MAGNETIC_DECLINATION(161),
    MAGNETIC_FLUX_DENSITY_2D(162),
    MAGNETIC_FLUX_DENSITY_3D(163),
    NOMINAL_LIGHT_OUTPUT(164),
    OVERALL_FAILURE_CONDITION(165),
    POLLEN_CONCENTRATION(166),
    PRESENT_INDOOR_RELATIVE_HUMIDITY(167),
    PRESENT_OUTDOOR_RELATIVE_HUMIDITY(168),
    PRESSURE(169),
    RAINFALL(170),
    RATED_MEDIAN_USEFUL_LIFE_OF_LUMINAIRE(171),
    RATED_MEDIAN_USEFUL_LIGHT_SOURCE_STARTS(172),
    REFERENCE_TEMPERATURE(173),
    TOTAL_DEVICE_STARTS(174),
    TRUE_WIND_DIRECTION(175),
    TRUE_WIND_SPEED(176),
    UV_INDEX(177),
    WIND_CHILL(178),
    LIGHT_SOURCE_TYPE(179),
    LUMINAIRE_IDENTIFICATION_STRING(180),
    OUTPUT_POWER_LIMITATION(181),
    THERMAL_DERATING(182),
    OUTPUT_CURRENT_PERCENT(183),
    UNKNOWN(-1);

    private final short propertyId;

    private DeviceProperty(short property) {
        this.propertyId = property;
    }

    public short getPropertyId() {
        return this.propertyId;
    }

    public static DeviceProperty from(short propertyId) {
        switch (propertyId) {
            case 1: {
                return AVERAGE_AMBIENT_TEMPERATURE_IN_A_PERIOD_OF_DAY;
            }
            case 2: {
                return AVERAGE_INPUT_CURRENT;
            }
            case 3: {
                return AVERAGE_INPUT_VOLTAGE;
            }
            case 4: {
                return AVERAGE_OUTPUT_CURRENT;
            }
            case 5: {
                return AVERAGE_OUTPUT_VOLTAGE;
            }
            case 6: {
                return CENTER_BEAM_INTENSITY_AT_FULL_POWER;
            }
            case 7: {
                return CHROMATICITY_TOLERANCE;
            }
            case 8: {
                return COLOR_RENDERING_INDEX_R9;
            }
            case 9: {
                return COLOR_RENDERING_INDEX_RA;
            }
            case 10: {
                return DEVICE_APPEARANCE;
            }
            case 11: {
                return DEVICE_COUNTRY_OF_ORIGIN;
            }
            case 12: {
                return DEVICE_DATE_OF_MANUFACTURE;
            }
            case 13: {
                return DEVICE_ENERGY_USE_SINCE_TURN_ON;
            }
            case 14: {
                return DEVICE_FIRMWARE_REVISION;
            }
            case 15: {
                return DEVICE_GLOBAL_TRADE_ITEM_NUMBER;
            }
            case 16: {
                return DEVICE_HARDWARE_REVISION;
            }
            case 17: {
                return DEVICE_MANUFACTURER_NAME;
            }
            case 18: {
                return DEVICE_MODEL_NUMBER;
            }
            case 19: {
                return DEVICE_OPERATING_TEMPERATURE_RANGE_SPECIFICATION;
            }
            case 20: {
                return DEVICE_OPERATING_TEMPERATURE_STATISTICAL_VALUES;
            }
            case 21: {
                return DEVICE_OVER_TEMPERATURE_EVENT_STATISTICS;
            }
            case 22: {
                return DEVICE_POWER_RANGE_SPECIFICATION;
            }
            case 23: {
                return DEVICE_RUN_TIME_SINCE_TURN_ON;
            }
            case 24: {
                return DEVICE_RUNTIME_WARRANTY;
            }
            case 25: {
                return DEVICE_SERIAL_NUMBER;
            }
            case 26: {
                return DEVICE_SOFTWARE_REVISION;
            }
            case 27: {
                return DEVICE_UNDER_TEMPERATURE_EVENT_STATISTICS;
            }
            case 28: {
                return INDOOR_AMBIENT_TEMPERATURE_STATISTICAL_VALUES;
            }
            case 29: {
                return INITIAL_CIE1931_CHROMATICITY_COORDINATES;
            }
            case 30: {
                return INITIAL_CORRELATED_COLOR_TEMPERATURE;
            }
            case 31: {
                return INITIAL_LUMINOUS_FLUX;
            }
            case 32: {
                return INITIAL_PLANCKIAN_DISTANCE;
            }
            case 33: {
                return INPUT_CURRENT_RANGE_SPECIFICATION;
            }
            case 34: {
                return INPUT_CURRENT_STATISTICS;
            }
            case 35: {
                return INPUT_OVER_CURRENT_EVENT_STATISTICS;
            }
            case 36: {
                return INPUT_OVER_RIPPLE_VOLTAGE_EVENT_STATISTICS;
            }
            case 37: {
                return INPUT_OVER_VOLTAGE_EVENT_STATISTICS;
            }
            case 38: {
                return INPUT_UNDERCURRENT_EVENT_STATISTICS;
            }
            case 39: {
                return INPUT_UNDER_VOLTAGE_EVENT_STATISTICS;
            }
            case 40: {
                return INPUT_VOLTAGE_RANGE_SPECIFICATION;
            }
            case 41: {
                return INPUT_VOLTAGE_RIPPLE_SPECIFICATION;
            }
            case 42: {
                return INPUT_VOLTAGE_STATISTICS;
            }
            case 43: {
                return LIGHT_CONTROL_AMBIENT_LUX_LEVEL_ON;
            }
            case 44: {
                return LIGHT_CONTROL_AMBIENT_LUX_LEVEL_PROLONG;
            }
            case 45: {
                return LIGHT_CONTROL_AMBIENT_LUX_LEVEL_STANDBY;
            }
            case 46: {
                return LIGHT_CONTROL_LIGHTNESS_ON;
            }
            case 47: {
                return LIGHT_CONTROL_LIGHTNESS_PROLONG;
            }
            case 48: {
                return LIGHT_CONTROL_LIGHTNESS_STANDBY;
            }
            case 49: {
                return LIGHT_CONTROL_REGULATOR_ACCURACY;
            }
            case 50: {
                return LIGHT_CONTROL_REGULATOR_KID;
            }
            case 51: {
                return LIGHT_CONTROL_REGULATOR_KIU;
            }
            case 52: {
                return LIGHT_CONTROL_REGULATOR_KPD;
            }
            case 53: {
                return LIGHT_CONTROL_REGULATOR_KPU;
            }
            case 54: {
                return LIGHT_CONTROL_TIME_FADE;
            }
            case 55: {
                return LIGHT_CONTROL_TIME_FADE_ON;
            }
            case 56: {
                return LIGHT_CONTROL_TIME_FADE_STANDBY_AUTO;
            }
            case 57: {
                return LIGHT_CONTROL_TIME_FADE_STANDBY_MANUAL;
            }
            case 58: {
                return LIGHT_CONTROL_TIME_OCCUPANCY_DELAY;
            }
            case 59: {
                return LIGHT_CONTROL_TIME_PROLONG;
            }
            case 60: {
                return LIGHT_CONTROL_TIME_RUN_ON;
            }
            case 61: {
                return LUMEN_MAINTENANCE_FACTOR;
            }
            case 62: {
                return LUMINOUS_EFFICACY;
            }
            case 63: {
                return LUMINOUS_ENERGY_SINCE_TURN_ON;
            }
            case 64: {
                return LUMINOUS_EXPOSURE;
            }
            case 65: {
                return LUMINOUS_FLUX_RANGE;
            }
            case 66: {
                return MOTION_SENSED;
            }
            case 67: {
                return MOTION_THRESHOLD;
            }
            case 68: {
                return OPEN_CIRCUIT_EVENT_STATISTICS;
            }
            case 69: {
                return OUTDOOR_STATISTICAL_VALUES;
            }
            case 70: {
                return OUTPUT_CURRENT_RANGE;
            }
            case 71: {
                return OUTPUT_CURRENT_STATISTICS;
            }
            case 72: {
                return OUTPUT_RIPPLE_VOLTAGE_SPECIFICATION;
            }
            case 73: {
                return OUTPUT_VOLTAGE_RANGE;
            }
            case 74: {
                return OUTPUT_VOLTAGE_STATISTICS;
            }
            case 75: {
                return OVER_OUTPUT_RIPPLE_VOLTAGE_EVENT_STATISTICS;
            }
            case 76: {
                return PEOPLE_COUNT;
            }
            case 77: {
                return PRESENCE_DETECTED;
            }
            case 78: {
                return PRESENT_AMBIENT_LIGHT_LEVEL;
            }
            case 79: {
                return PRESENT_AMBIENT_TEMPERATURE;
            }
            case 80: {
                return PRESENT_CIE1931_CHROMATICITY_COORDINATES;
            }
            case 81: {
                return PRESENT_CORRELATED_COLOR_TEMPERATURE;
            }
            case 82: {
                return PRESENT_DEVICE_INPUT_POWER;
            }
            case 83: {
                return PRESENT_DEVICE_OPERATING_EFFICIENCY;
            }
            case 84: {
                return PRESENT_DEVICE_OPERATING_TEMPERATURE;
            }
            case 85: {
                return PRESENT_ILLUMINANCE;
            }
            case 86: {
                return PRESENT_INDOOR_AMBIENT_TEMPERATURE;
            }
            case 87: {
                return PRESENT_INPUT_CURRENT;
            }
            case 88: {
                return PRESENT_INPUT_RIPPLE_VOLTAGE;
            }
            case 89: {
                return PRESENT_INPUT_VOLTAGE;
            }
            case 90: {
                return PRESENT_LUMINOUS_FLUX;
            }
            case 91: {
                return PRESENT_OUTDOOR_AMBIENT_TEMPERATURE;
            }
            case 92: {
                return PRESENT_OUTPUT_CURRENT;
            }
            case 93: {
                return PRESENT_OUTPUT_VOLTAGE;
            }
            case 94: {
                return PRESENT_PLANCKIAN_DISTANCE;
            }
            case 95: {
                return PRESENT_RELATIVE_OUTPUT_RIPPLE_VOLTAGE;
            }
            case 96: {
                return RELATIVE_DEVICE_ENERGY_USE_IN_A_PERIOD_OF_DAY;
            }
            case 97: {
                return RELATIVE_DEVICE_RUNTIME_IN_A_GENERIC_LEVEL_RANGE;
            }
            case 98: {
                return RELATIVE_EXPOSURE_TIME_IN_AN_ILLUMINANCE_RANGE;
            }
            case 99: {
                return RELATIVE_RUNTIME_IN_A_CORRELATED_COLOR_TEMPERATURE_RANGE;
            }
            case 100: {
                return RELATIVE_RUNTIME_IN_A_DEVICE_OPERATING_TEMPERATURE_RANGE;
            }
            case 101: {
                return RELATIVE_RUNTIME_IN_AN_INPUT_CURRENT_RANGE;
            }
            case 102: {
                return RELATIVE_RUNTIME_IN_AN_INPUT_VOLTAGE_RANGE;
            }
            case 103: {
                return SHORT_CIRCUIT_EVENT_STATISTICS;
            }
            case 104: {
                return TIME_SINCE_MOTION_SENSED;
            }
            case 105: {
                return TIME_SINCE_PRESENCE_DETECTED;
            }
            case 106: {
                return TOTAL_DEVICE_ENERGY_USE;
            }
            case 107: {
                return TOTAL_DEVICE_OFF_ON_CYCLES;
            }
            case 108: {
                return TOTAL_DEVICE_POWER_ON_CYCLES;
            }
            case 109: {
                return TOTAL_DEVICE_POWER_ON_TIME;
            }
            case 110: {
                return TOTAL_DEVICE_RUNTIME;
            }
            case 111: {
                return TOTAL_LIGHT_EXPOSURE_TIME;
            }
            case 112: {
                return TOTAL_LUMINOUS_ENERGY;
            }
            case 113: {
                return DESIRED_AMBIENT_TEMPERATURE;
            }
            case 114: {
                return PRECISE_TOTAL_DEVICE_ENERGY_USE;
            }
            case 115: {
                return POWER_FACTOR;
            }
            case 116: {
                return SENSOR_GAIN;
            }
            case 117: {
                return PRECISE_PRESENT_AMBIENT_TEMPERATURE;
            }
            case 118: {
                return PRESENT_AMBIENT_RELATIVE_HUMIDITY;
            }
            case 119: {
                return PRESENT_AMBIENT_CARBONDIOXIDE_CONCENTRATION;
            }
            case 120: {
                return PRESENT_AMBIENT_VOLATILE_ORGANIC_COMPOUNDS_CONCENTRATION;
            }
            case 121: {
                return PRESENT_AMBIENT_NOISE;
            }
            case 128: {
                return ACTIVE_ENERGY_LOAD_SIDE;
            }
            case 129: {
                return ACTIVE_POWER_LOAD_SIDE;
            }
            case 130: {
                return AIR_PRESSURE;
            }
            case 131: {
                return APPARENT_ENERGY;
            }
            case 132: {
                return APPARENT_POWER;
            }
            case 133: {
                return APPARENT_WIND_DIRECTION;
            }
            case 134: {
                return APPARENT_WIND_SPEED;
            }
            case 135: {
                return DEW_POINT;
            }
            case 136: {
                return EXTERNAL_SUPPLY_VOLTAGE;
            }
            case 137: {
                return EXTERNAL_SUPPLY_VOLTAGE_FREQUENCY;
            }
            case 138: {
                return GUST_FACTOR;
            }
            case 139: {
                return HEAT_INDEX;
            }
            case 140: {
                return LIGHT_DISTRIBUTION;
            }
            case 141: {
                return LIGHT_SOURCE_CURRENT;
            }
            case 142: {
                return LIGHT_SOURCE_ON_TIME_NOT_RESETTABLE;
            }
            case 143: {
                return LIGHT_SOURCE_ON_TIME_RESETTABLE;
            }
            case 144: {
                return LIGHT_SOURCE_OPEN_CIRCUIT_STATISTICS;
            }
            case 145: {
                return LIGHT_SOURCE_OVERALL_FAILURES_STATISTICS;
            }
            case 146: {
                return LIGHT_SOURCE_SHORT_CIRCUIT_STATISTICS;
            }
            case 147: {
                return LIGHT_SOURCE_START_COUNTER_RESETTABLE;
            }
            case 148: {
                return LIGHT_SOURCE_TEMPERATURE;
            }
            case 149: {
                return LIGHT_SOURCE_THERMAL_DERATING_STATISTICS;
            }
            case 150: {
                return LIGHT_SOURCE_THERMAL_SHUTDOWN_STATISTICS;
            }
            case 151: {
                return LIGHT_SOURCE_TOTAL_POWER_ON_CYCLES;
            }
            case 152: {
                return LIGHT_SOURCE_VOLTAGE;
            }
            case 153: {
                return LUMINAIRE_COLOR;
            }
            case 154: {
                return LUMINAIRE_IDENTIFICATION_NUMBER;
            }
            case 155: {
                return LUMINAIRE_MANUFACTURER_GTIN;
            }
            case 156: {
                return LUMINAIRE_NOMINAL_INPUT_POWER;
            }
            case 157: {
                return LUMINAIRE_NOMINAL_MAXIMUM_AC_MAINS_VOLTAGE;
            }
            case 158: {
                return LUMINAIRE_NOMINAL_MINIMUM_AC_MAINS_VOLTAGE;
            }
            case 159: {
                return LUMINAIRE_POWER_AT_MINIMUM_DIM_LEVEL;
            }
            case 160: {
                return LUMINAIRE_TIME_OF_MANUFACTURE;
            }
            case 161: {
                return MAGNETIC_DECLINATION;
            }
            case 162: {
                return MAGNETIC_FLUX_DENSITY_2D;
            }
            case 163: {
                return MAGNETIC_FLUX_DENSITY_3D;
            }
            case 164: {
                return NOMINAL_LIGHT_OUTPUT;
            }
            case 165: {
                return OVERALL_FAILURE_CONDITION;
            }
            case 166: {
                return POLLEN_CONCENTRATION;
            }
            case 167: {
                return PRESENT_INDOOR_RELATIVE_HUMIDITY;
            }
            case 168: {
                return PRESENT_OUTDOOR_RELATIVE_HUMIDITY;
            }
            case 169: {
                return PRESSURE;
            }
            case 170: {
                return RAINFALL;
            }
            case 171: {
                return RATED_MEDIAN_USEFUL_LIFE_OF_LUMINAIRE;
            }
            case 172: {
                return RATED_MEDIAN_USEFUL_LIGHT_SOURCE_STARTS;
            }
            case 173: {
                return REFERENCE_TEMPERATURE;
            }
            case 174: {
                return TOTAL_DEVICE_STARTS;
            }
            case 175: {
                return TRUE_WIND_DIRECTION;
            }
            case 176: {
                return TRUE_WIND_SPEED;
            }
            case 177: {
                return UV_INDEX;
            }
            case 178: {
                return WIND_CHILL;
            }
            case 179: {
                return LIGHT_SOURCE_TYPE;
            }
            case 180: {
                return LUMINAIRE_IDENTIFICATION_STRING;
            }
            case 181: {
                return OUTPUT_POWER_LIMITATION;
            }
            case 182: {
                return THERMAL_DERATING;
            }
            case 183: {
                return OUTPUT_CURRENT_PERCENT;
            }
        }
        return UNKNOWN;
    }

    public static DeviceProperty from(SensorFormat sensorFormat, short propertyId) {
        switch (sensorFormat) {
            case FORMAT_A: {
                for (DeviceProperty deviceProperty : DeviceProperty.values()) {
                    if ((deviceProperty.propertyId & 0x7FF) != propertyId) continue;
                    return deviceProperty;
                }
            }
            case FORMAT_B: {
                return DeviceProperty.from(propertyId);
            }
        }
        return UNKNOWN;
    }

    public static String getPropertyName(DeviceProperty deviceProperty) {
        switch (deviceProperty) {
            case AVERAGE_AMBIENT_TEMPERATURE_IN_A_PERIOD_OF_DAY: {
                return "Average Ambient Temperature In A Period Of Day";
            }
            case AVERAGE_INPUT_CURRENT: {
                return "Average Input Current";
            }
            case AVERAGE_INPUT_VOLTAGE: {
                return "Average Input Voltage";
            }
            case AVERAGE_OUTPUT_CURRENT: {
                return "Average Output Current";
            }
            case AVERAGE_OUTPUT_VOLTAGE: {
                return "Average Output Voltage";
            }
            case CENTER_BEAM_INTENSITY_AT_FULL_POWER: {
                return "Center Beam Intensity At Full Power";
            }
            case CHROMATICITY_TOLERANCE: {
                return "Chromaticity Tolerance";
            }
            case COLOR_RENDERING_INDEX_R9: {
                return "Color Rendering Index R9";
            }
            case COLOR_RENDERING_INDEX_RA: {
                return "Color Rendering Index Ra";
            }
            case DEVICE_APPEARANCE: {
                return "Device Appearance";
            }
            case DEVICE_COUNTRY_OF_ORIGIN: {
                return "Device Country Of Origin";
            }
            case DEVICE_DATE_OF_MANUFACTURE: {
                return "Device Date Of Manufacture";
            }
            case DEVICE_ENERGY_USE_SINCE_TURN_ON: {
                return "Device Energy Use Since Turn On";
            }
            case DEVICE_FIRMWARE_REVISION: {
                return "Device Firmware Revision";
            }
            case DEVICE_GLOBAL_TRADE_ITEM_NUMBER: {
                return "Device Global Trade Item Number";
            }
            case DEVICE_HARDWARE_REVISION: {
                return "Device Hardware Revision";
            }
            case DEVICE_MANUFACTURER_NAME: {
                return "Device Manufacturer Name";
            }
            case DEVICE_MODEL_NUMBER: {
                return "Device Model Number";
            }
            case DEVICE_OPERATING_TEMPERATURE_RANGE_SPECIFICATION: {
                return "Device Operating Temperature Range Specification";
            }
            case DEVICE_OPERATING_TEMPERATURE_STATISTICAL_VALUES: {
                return "Device Operating Temperature Statistical Values";
            }
            case DEVICE_OVER_TEMPERATURE_EVENT_STATISTICS: {
                return "Device Over Temperature Event Statistics";
            }
            case DEVICE_POWER_RANGE_SPECIFICATION: {
                return "Device Power Range Specification";
            }
            case DEVICE_RUN_TIME_SINCE_TURN_ON: {
                return "Device Runtime Since Turn On";
            }
            case DEVICE_RUNTIME_WARRANTY: {
                return "Device Runtime Warranty";
            }
            case DEVICE_SERIAL_NUMBER: {
                return "Device Serial Number";
            }
            case DEVICE_SOFTWARE_REVISION: {
                return "Device Software Revision";
            }
            case DEVICE_UNDER_TEMPERATURE_EVENT_STATISTICS: {
                return "Device Under Temperature Event Statistics";
            }
            case INDOOR_AMBIENT_TEMPERATURE_STATISTICAL_VALUES: {
                return "Indoor Ambient Temperature Statistical Values";
            }
            case INITIAL_CIE1931_CHROMATICITY_COORDINATES: {
                return "Initial CIE 1931 Chromaticity Coordinates";
            }
            case INITIAL_CORRELATED_COLOR_TEMPERATURE: {
                return "Initial Correlated Color Temperature";
            }
            case INITIAL_LUMINOUS_FLUX: {
                return "Initial Luminous Flux";
            }
            case INITIAL_PLANCKIAN_DISTANCE: {
                return "Initial Planckian Distance";
            }
            case INPUT_CURRENT_RANGE_SPECIFICATION: {
                return "Input Current Range Specification";
            }
            case INPUT_CURRENT_STATISTICS: {
                return "Input Current Statistics";
            }
            case INPUT_OVER_CURRENT_EVENT_STATISTICS: {
                return "Input Over Current Event Statistics";
            }
            case INPUT_OVER_RIPPLE_VOLTAGE_EVENT_STATISTICS: {
                return "Input Over Ripple Voltage Event Statistics";
            }
            case INPUT_OVER_VOLTAGE_EVENT_STATISTICS: {
                return "Input Over Voltage Event Statistics";
            }
            case INPUT_UNDERCURRENT_EVENT_STATISTICS: {
                return "Input Under Current Event Statistics";
            }
            case INPUT_UNDER_VOLTAGE_EVENT_STATISTICS: {
                return "Input Under Voltage Event Statistics";
            }
            case INPUT_VOLTAGE_RANGE_SPECIFICATION: {
                return "Input Voltage Range Specification";
            }
            case INPUT_VOLTAGE_RIPPLE_SPECIFICATION: {
                return "Input Voltage Ripple Specification";
            }
            case INPUT_VOLTAGE_STATISTICS: {
                return "Input Voltage Statistics";
            }
            case LIGHT_CONTROL_AMBIENT_LUX_LEVEL_ON: {
                return "Light Control Ambient LuxLevel On";
            }
            case LIGHT_CONTROL_AMBIENT_LUX_LEVEL_PROLONG: {
                return "Light Control Ambient LuxLevel Prolong";
            }
            case LIGHT_CONTROL_AMBIENT_LUX_LEVEL_STANDBY: {
                return "Light Control Ambient LuxLevel Standby";
            }
            case LIGHT_CONTROL_LIGHTNESS_ON: {
                return "Light Control Lightness On";
            }
            case LIGHT_CONTROL_LIGHTNESS_PROLONG: {
                return "Light Control Lightness Prolong";
            }
            case LIGHT_CONTROL_LIGHTNESS_STANDBY: {
                return "Light Control Lightness Standby";
            }
            case LIGHT_CONTROL_REGULATOR_ACCURACY: {
                return "Light Control Regulator Accuracy";
            }
            case LIGHT_CONTROL_REGULATOR_KID: {
                return "Light Control Regulator Kid";
            }
            case LIGHT_CONTROL_REGULATOR_KIU: {
                return "Light Control Regulator Kiu";
            }
            case LIGHT_CONTROL_REGULATOR_KPD: {
                return "Light Control Regulator Kpd";
            }
            case LIGHT_CONTROL_REGULATOR_KPU: {
                return "Light Control Regulator Kpu";
            }
            case LIGHT_CONTROL_TIME_FADE: {
                return "Light Control Time Fade";
            }
            case LIGHT_CONTROL_TIME_FADE_ON: {
                return "Light Control Time Fade On";
            }
            case LIGHT_CONTROL_TIME_FADE_STANDBY_AUTO: {
                return "Light Control Time Fade Standby Auto";
            }
            case LIGHT_CONTROL_TIME_FADE_STANDBY_MANUAL: {
                return "Light Control Time Fade Standby Manual";
            }
            case LIGHT_CONTROL_TIME_OCCUPANCY_DELAY: {
                return "Light Control Time Occupancy Delay";
            }
            case LIGHT_CONTROL_TIME_PROLONG: {
                return "Light Control Time Prolong";
            }
            case LIGHT_CONTROL_TIME_RUN_ON: {
                return "Light Control Time Run On";
            }
            case LUMEN_MAINTENANCE_FACTOR: {
                return "Lumen Maintenance Factor";
            }
            case LUMINOUS_EFFICACY: {
                return "Luminous Efficacy";
            }
            case LUMINOUS_ENERGY_SINCE_TURN_ON: {
                return "Luminous Energy Since Turn On";
            }
            case LUMINOUS_EXPOSURE: {
                return "Luminous Exposure";
            }
            case LUMINOUS_FLUX_RANGE: {
                return "Luminous Flux Range";
            }
            case MOTION_SENSED: {
                return "Motion Sensed";
            }
            case MOTION_THRESHOLD: {
                return "Motion Threshold";
            }
            case OPEN_CIRCUIT_EVENT_STATISTICS: {
                return "Open Circuit Event Statistics";
            }
            case OUTDOOR_STATISTICAL_VALUES: {
                return "Outdoor Statistical Values";
            }
            case OUTPUT_CURRENT_RANGE: {
                return "Output Current Range";
            }
            case OUTPUT_CURRENT_STATISTICS: {
                return "Output Current Statistics";
            }
            case OUTPUT_RIPPLE_VOLTAGE_SPECIFICATION: {
                return "Output Ripple Voltage Specification";
            }
            case OUTPUT_VOLTAGE_RANGE: {
                return "Output Voltage Range";
            }
            case OUTPUT_VOLTAGE_STATISTICS: {
                return "Output Voltage Statistics";
            }
            case OVER_OUTPUT_RIPPLE_VOLTAGE_EVENT_STATISTICS: {
                return "Over Output Ripple Voltage Event Statistics";
            }
            case PEOPLE_COUNT: {
                return "People Count";
            }
            case PRESENCE_DETECTED: {
                return "Presence Detected";
            }
            case PRESENT_AMBIENT_LIGHT_LEVEL: {
                return "Present Ambient Light Level";
            }
            case PRESENT_AMBIENT_TEMPERATURE: {
                return "Present Ambient Temperature";
            }
            case PRESENT_CIE1931_CHROMATICITY_COORDINATES: {
                return "Present CIE 1931 Chromaticity Coordinates";
            }
            case PRESENT_CORRELATED_COLOR_TEMPERATURE: {
                return "Present Correlated Color Temperature";
            }
            case PRESENT_DEVICE_INPUT_POWER: {
                return "Present Device Input Power";
            }
            case PRESENT_DEVICE_OPERATING_EFFICIENCY: {
                return "Present Device Operating Efficiency";
            }
            case PRESENT_DEVICE_OPERATING_TEMPERATURE: {
                return "Present Device Operating Temperature";
            }
            case PRESENT_ILLUMINANCE: {
                return "Present Illuminance";
            }
            case PRESENT_INDOOR_AMBIENT_TEMPERATURE: {
                return "Present Indoor Ambient Temperature";
            }
            case PRESENT_INPUT_CURRENT: {
                return "Present Input Current";
            }
            case PRESENT_INPUT_RIPPLE_VOLTAGE: {
                return "Present Input Ripple Voltage";
            }
            case PRESENT_INPUT_VOLTAGE: {
                return "Present Input Voltage";
            }
            case PRESENT_LUMINOUS_FLUX: {
                return "Present Luminous Flux";
            }
            case PRESENT_OUTDOOR_AMBIENT_TEMPERATURE: {
                return "Present Outdoor Ambient Temperature";
            }
            case PRESENT_OUTPUT_CURRENT: {
                return "Present Output Current";
            }
            case PRESENT_OUTPUT_VOLTAGE: {
                return "Present Output Voltage";
            }
            case PRESENT_PLANCKIAN_DISTANCE: {
                return "Present Planckian Distance";
            }
            case PRESENT_RELATIVE_OUTPUT_RIPPLE_VOLTAGE: {
                return "Present Relative Output Ripple Voltage";
            }
            case RELATIVE_DEVICE_ENERGY_USE_IN_A_PERIOD_OF_DAY: {
                return "Relative Device Energy Use In A Period Of Day";
            }
            case RELATIVE_DEVICE_RUNTIME_IN_A_GENERIC_LEVEL_RANGE: {
                return "Relative Device Runtime In A Generic Level Range";
            }
            case RELATIVE_EXPOSURE_TIME_IN_AN_ILLUMINANCE_RANGE: {
                return "Relative Exposure Time In An Illuminance Range";
            }
            case RELATIVE_RUNTIME_IN_A_CORRELATED_COLOR_TEMPERATURE_RANGE: {
                return "Relative Runtime In A Correlated Color Temperature Range";
            }
            case RELATIVE_RUNTIME_IN_A_DEVICE_OPERATING_TEMPERATURE_RANGE: {
                return "Relative Runtime In A Device Operating Temperature Range";
            }
            case RELATIVE_RUNTIME_IN_AN_INPUT_CURRENT_RANGE: {
                return "Relative Runtime In An Input Current Range";
            }
            case RELATIVE_RUNTIME_IN_AN_INPUT_VOLTAGE_RANGE: {
                return "Relative Runtime In An Input Voltage Range";
            }
            case SHORT_CIRCUIT_EVENT_STATISTICS: {
                return "Short Circuit Event Statistics";
            }
            case TIME_SINCE_MOTION_SENSED: {
                return "Time Since Motion Sensed";
            }
            case TIME_SINCE_PRESENCE_DETECTED: {
                return "Time Since Presence Detected";
            }
            case TOTAL_DEVICE_ENERGY_USE: {
                return "Total Device Energy Use";
            }
            case TOTAL_DEVICE_OFF_ON_CYCLES: {
                return "Total Device Off On Cycles";
            }
            case TOTAL_DEVICE_POWER_ON_CYCLES: {
                return "Total Device Power On Cycles";
            }
            case TOTAL_DEVICE_POWER_ON_TIME: {
                return "Total Device Power On Time";
            }
            case TOTAL_DEVICE_RUNTIME: {
                return "Total Device Runtime";
            }
            case TOTAL_LIGHT_EXPOSURE_TIME: {
                return "Total Light Exposure Time";
            }
            case TOTAL_LUMINOUS_ENERGY: {
                return "Total Luminous Energy";
            }
            case DESIRED_AMBIENT_TEMPERATURE: {
                return "Desired Ambient Temperature";
            }
            case PRECISE_TOTAL_DEVICE_ENERGY_USE: {
                return "Precise Total Device Energy Use";
            }
            case POWER_FACTOR: {
                return "Power Factor";
            }
            case SENSOR_GAIN: {
                return "Sensor Gain";
            }
            case PRECISE_PRESENT_AMBIENT_TEMPERATURE: {
                return "Precise Present Ambient Temperature";
            }
            case PRESENT_AMBIENT_RELATIVE_HUMIDITY: {
                return "Present Ambient Relative Humidity";
            }
            case PRESENT_AMBIENT_CARBONDIOXIDE_CONCENTRATION: {
                return "Present Ambient Carbon Dioxide Concentration";
            }
            case PRESENT_AMBIENT_VOLATILE_ORGANIC_COMPOUNDS_CONCENTRATION: {
                return "Present Ambient Volatile Organic Compounds Concentration";
            }
            case PRESENT_AMBIENT_NOISE: {
                return "Present Ambient Noise";
            }
            case ACTIVE_ENERGY_LOAD_SIDE: {
                return "Active Energy Loadside";
            }
            case ACTIVE_POWER_LOAD_SIDE: {
                return "Active Power Loadside";
            }
            case AIR_PRESSURE: {
                return "Air Pressure";
            }
            case APPARENT_ENERGY: {
                return "Apparent Energy";
            }
            case APPARENT_POWER: {
                return "Apparent Power";
            }
            case APPARENT_WIND_DIRECTION: {
                return "Apparent Wind Direction";
            }
            case APPARENT_WIND_SPEED: {
                return "Apparent Wind Speed";
            }
            case DEW_POINT: {
                return "Dew Point";
            }
            case EXTERNAL_SUPPLY_VOLTAGE: {
                return "External Supply Voltage";
            }
            case EXTERNAL_SUPPLY_VOLTAGE_FREQUENCY: {
                return "External Supply Voltage Frequency";
            }
            case GUST_FACTOR: {
                return "Gust Factor";
            }
            case HEAT_INDEX: {
                return "Heat Index";
            }
            case LIGHT_DISTRIBUTION: {
                return "Light Distribution";
            }
            case LIGHT_SOURCE_CURRENT: {
                return "Light Source Current";
            }
            case LIGHT_SOURCE_ON_TIME_NOT_RESETTABLE: {
                return "Light Source On Time Not Resettable";
            }
            case LIGHT_SOURCE_ON_TIME_RESETTABLE: {
                return "Light Source On Time Resettable";
            }
            case LIGHT_SOURCE_OPEN_CIRCUIT_STATISTICS: {
                return "Light Source Open Circuit Statistics";
            }
            case LIGHT_SOURCE_OVERALL_FAILURES_STATISTICS: {
                return "Light Source Overall Failures Statistics";
            }
            case LIGHT_SOURCE_SHORT_CIRCUIT_STATISTICS: {
                return "Light Source Short Circuit Statistics";
            }
            case LIGHT_SOURCE_START_COUNTER_RESETTABLE: {
                return "Light Source Start Counter Resettable";
            }
            case LIGHT_SOURCE_TEMPERATURE: {
                return "Light Source Temperature";
            }
            case LIGHT_SOURCE_THERMAL_DERATING_STATISTICS: {
                return "Light Source Thermal Derating Statistics";
            }
            case LIGHT_SOURCE_THERMAL_SHUTDOWN_STATISTICS: {
                return "Light Source Thermal Shutdown Statistics";
            }
            case LIGHT_SOURCE_TOTAL_POWER_ON_CYCLES: {
                return "Light Source Total Power On Cycles";
            }
            case LIGHT_SOURCE_VOLTAGE: {
                return "Light Source Voltage";
            }
            case LUMINAIRE_COLOR: {
                return "Luminaire Color";
            }
            case LUMINAIRE_IDENTIFICATION_NUMBER: {
                return "Luminaire Identification Number";
            }
            case LUMINAIRE_MANUFACTURER_GTIN: {
                return "Luminaire Manufacturer GTIN";
            }
            case LUMINAIRE_NOMINAL_INPUT_POWER: {
                return "Luminaire Nominal Input Power";
            }
            case LUMINAIRE_NOMINAL_MAXIMUM_AC_MAINS_VOLTAGE: {
                return "Luminaire Nominal Maximum AC Mains Voltage";
            }
            case LUMINAIRE_NOMINAL_MINIMUM_AC_MAINS_VOLTAGE: {
                return "Luminaire Nominal Minimum AC Mains Voltage";
            }
            case LUMINAIRE_POWER_AT_MINIMUM_DIM_LEVEL: {
                return "Luminaire Power At Minimum Dim Level";
            }
            case LUMINAIRE_TIME_OF_MANUFACTURE: {
                return "Luminaire Time Of Manufacture";
            }
            case MAGNETIC_DECLINATION: {
                return "Magnetic Declination";
            }
            case MAGNETIC_FLUX_DENSITY_2D: {
                return "Magnetic Flux Density - 2D";
            }
            case MAGNETIC_FLUX_DENSITY_3D: {
                return "Magnetic Flux Density - 3D";
            }
            case NOMINAL_LIGHT_OUTPUT: {
                return "Nominal Light Output";
            }
            case OVERALL_FAILURE_CONDITION: {
                return "Overall Failure Condition";
            }
            case POLLEN_CONCENTRATION: {
                return "Pollen Concentration";
            }
            case PRESENT_INDOOR_RELATIVE_HUMIDITY: {
                return "Present Indoor Relative Humidity";
            }
            case PRESENT_OUTDOOR_RELATIVE_HUMIDITY: {
                return "Present Outdoor Relative Humidity";
            }
            case PRESSURE: {
                return "Pressure";
            }
            case RAINFALL: {
                return "Rainfall";
            }
            case RATED_MEDIAN_USEFUL_LIFE_OF_LUMINAIRE: {
                return "Rated Median Useful Life Of Luminaire";
            }
            case RATED_MEDIAN_USEFUL_LIGHT_SOURCE_STARTS: {
                return "Rated Median Useful Light Source Starts";
            }
            case REFERENCE_TEMPERATURE: {
                return "Reference Temperature";
            }
            case TOTAL_DEVICE_STARTS: {
                return "Total Device Starts";
            }
            case TRUE_WIND_DIRECTION: {
                return "True Wind Direction";
            }
            case TRUE_WIND_SPEED: {
                return "True Wind Speed";
            }
            case UV_INDEX: {
                return "UV Index";
            }
            case WIND_CHILL: {
                return "Wind Chill";
            }
            case LIGHT_SOURCE_TYPE: {
                return "Light Source Type";
            }
            case LUMINAIRE_IDENTIFICATION_STRING: {
                return "Luminaire Identification String";
            }
            case OUTPUT_POWER_LIMITATION: {
                return "Output Power Limitation";
            }
            case THERMAL_DERATING: {
                return "Thermal Derating";
            }
            case OUTPUT_CURRENT_PERCENT: {
                return "Output Current Percent";
            }
        }
        return "Unknown Device Property";
    }

    public static DevicePropertyCharacteristic<?> getCharacteristic(@NonNull DeviceProperty deviceProperty, @NonNull byte[] data, int offset, int length) {
        switch (deviceProperty) {
            case PRESENCE_DETECTED: {
                return data.length == 0 ? new Bool(false) : new Bool(data[offset] == 1);
            }
            case INPUT_VOLTAGE_RIPPLE_SPECIFICATION: 
            case LIGHT_CONTROL_REGULATOR_ACCURACY: 
            case LUMEN_MAINTENANCE_FACTOR: 
            case MOTION_SENSED: 
            case MOTION_THRESHOLD: 
            case OUTPUT_RIPPLE_VOLTAGE_SPECIFICATION: 
            case PRESENT_DEVICE_OPERATING_EFFICIENCY: 
            case PRESENT_INPUT_RIPPLE_VOLTAGE: 
            case PRESENT_RELATIVE_OUTPUT_RIPPLE_VOLTAGE: 
            case OUTPUT_CURRENT_PERCENT: {
                return new Percentage8(data, offset);
            }
            case PRESENT_AMBIENT_TEMPERATURE: 
            case PRESENT_INDOOR_AMBIENT_TEMPERATURE: 
            case PRESENT_OUTDOOR_AMBIENT_TEMPERATURE: 
            case DESIRED_AMBIENT_TEMPERATURE: {
                return new Temperature(data, offset, 1);
            }
            case PRESENT_DEVICE_OPERATING_TEMPERATURE: 
            case PRECISE_PRESENT_AMBIENT_TEMPERATURE: {
                return new Temperature(data, offset, 2);
            }
            case PEOPLE_COUNT: {
                return new Count(data, offset, 2);
            }
            case PRESENT_AMBIENT_RELATIVE_HUMIDITY: 
            case PRESENT_INDOOR_RELATIVE_HUMIDITY: 
            case PRESENT_OUTDOOR_RELATIVE_HUMIDITY: {
                return new Humidity(data, offset);
            }
            case LIGHT_CONTROL_LIGHTNESS_ON: 
            case LIGHT_CONTROL_LIGHTNESS_PROLONG: 
            case LIGHT_CONTROL_LIGHTNESS_STANDBY: {
                return new PerceivedLightness(data, offset);
            }
            case TIME_SINCE_MOTION_SENSED: 
            case TIME_SINCE_PRESENCE_DETECTED: {
                return new TimeSecond(data, offset, 2);
            }
            case TOTAL_DEVICE_OFF_ON_CYCLES: 
            case TOTAL_DEVICE_POWER_ON_CYCLES: 
            case LIGHT_SOURCE_START_COUNTER_RESETTABLE: 
            case LIGHT_SOURCE_TOTAL_POWER_ON_CYCLES: 
            case RATED_MEDIAN_USEFUL_LIGHT_SOURCE_STARTS: 
            case TOTAL_DEVICE_STARTS: {
                return new Count(data, offset, 3);
            }
            case LIGHT_CONTROL_AMBIENT_LUX_LEVEL_ON: 
            case LIGHT_CONTROL_AMBIENT_LUX_LEVEL_PROLONG: 
            case LIGHT_CONTROL_AMBIENT_LUX_LEVEL_STANDBY: 
            case PRESENT_AMBIENT_LIGHT_LEVEL: 
            case PRESENT_ILLUMINANCE: {
                return new Illuminance(data, offset);
            }
            case DEVICE_RUN_TIME_SINCE_TURN_ON: 
            case DEVICE_RUNTIME_WARRANTY: 
            case TOTAL_DEVICE_POWER_ON_TIME: 
            case TOTAL_DEVICE_RUNTIME: 
            case TOTAL_LIGHT_EXPOSURE_TIME: 
            case RATED_MEDIAN_USEFUL_LIFE_OF_LUMINAIRE: {
                return new TimeHour24(data, offset);
            }
            case LIGHT_CONTROL_TIME_FADE: 
            case LIGHT_CONTROL_TIME_FADE_ON: 
            case LIGHT_CONTROL_TIME_FADE_STANDBY_AUTO: 
            case LIGHT_CONTROL_TIME_FADE_STANDBY_MANUAL: 
            case LIGHT_CONTROL_TIME_OCCUPANCY_DELAY: 
            case LIGHT_CONTROL_TIME_PROLONG: 
            case LIGHT_CONTROL_TIME_RUN_ON: {
                return new TimeMillisecond24(data, offset);
            }
            case DEVICE_DATE_OF_MANUFACTURE: 
            case LUMINAIRE_TIME_OF_MANUFACTURE: {
                return new DateUtc(data, offset);
            }
            case AIR_PRESSURE: 
            case PRESSURE: {
                return new Pressure(data, offset);
            }
            case LIGHT_CONTROL_REGULATOR_KID: 
            case LIGHT_CONTROL_REGULATOR_KIU: 
            case LIGHT_CONTROL_REGULATOR_KPD: 
            case LIGHT_CONTROL_REGULATOR_KPU: 
            case SENSOR_GAIN: {
                return new Coefficient(data, offset);
            }
            case DEVICE_FIRMWARE_REVISION: 
            case DEVICE_SOFTWARE_REVISION: {
                return new FixedString(data, offset, 8);
            }
            case DEVICE_HARDWARE_REVISION: 
            case DEVICE_SERIAL_NUMBER: {
                return new FixedString(data, offset, 16);
            }
            case DEVICE_MODEL_NUMBER: 
            case LUMINAIRE_COLOR: 
            case LUMINAIRE_IDENTIFICATION_NUMBER: {
                return new FixedString(data, offset, 24);
            }
            case DEVICE_MANUFACTURER_NAME: {
                return new FixedString(data, offset, 36);
            }
            case LUMINAIRE_IDENTIFICATION_STRING: {
                return new FixedString(data, offset, 64);
            }
        }
        return new UnknownCharacteristic(data, offset, length);
    }
}

