/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.utils.SensorFormat;

public class MarshalledPropertyId
implements Parcelable {
    private final SensorFormat sensorFormat;
    private final int length;
    private final DeviceProperty propertyId;
    public static final Parcelable.Creator<MarshalledPropertyId> CREATOR = new Parcelable.Creator<MarshalledPropertyId>(){

        public MarshalledPropertyId createFromParcel(Parcel in) {
            return new MarshalledPropertyId(in);
        }

        public MarshalledPropertyId[] newArray(int size) {
            return new MarshalledPropertyId[size];
        }
    };

    public MarshalledPropertyId(@NonNull SensorFormat sensorFormat, int length, DeviceProperty propertyId) {
        this.sensorFormat = sensorFormat;
        this.length = length;
        this.propertyId = propertyId;
    }

    protected MarshalledPropertyId(Parcel in) {
        this.sensorFormat = SensorFormat.from((byte)in.readInt());
        this.length = in.readInt();
        this.propertyId = DeviceProperty.from((short)in.readInt());
    }

    public SensorFormat getSensorFormat() {
        return this.sensorFormat;
    }

    public int getLength() {
        return this.length;
    }

    public DeviceProperty getPropertyId() {
        return this.propertyId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.sensorFormat.ordinal());
        dest.writeInt(this.length);
        dest.writeInt(this.propertyId.ordinal());
    }

    public String toString() {
        return "MarshalledPropertyId{sensorFormat=" + SensorFormat.formatField(this.sensorFormat) + ", length=" + this.length + ", propertyId=" + DeviceProperty.getPropertyName(this.propertyId) + '}';
    }
}

