/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.sensorutils.SensorSamplingFunction;

public class SensorDescriptor {
    private final DeviceProperty property;
    private final short positiveTolerance;
    private final short negativeTolerance;
    private final SensorSamplingFunction sensorSamplingFunction;
    private final byte measurementPeriod;
    private final byte updateInterval;

    public SensorDescriptor(@NonNull DeviceProperty property, short positiveTolerance, short negativeTolerance, @NonNull SensorSamplingFunction sensorSamplingFunction, byte measurementPeriod, byte updateInterval) {
        this.property = property;
        this.positiveTolerance = positiveTolerance;
        this.negativeTolerance = negativeTolerance;
        this.sensorSamplingFunction = sensorSamplingFunction;
        this.measurementPeriod = measurementPeriod;
        this.updateInterval = updateInterval;
    }

    public DeviceProperty getProperty() {
        return this.property;
    }

    public short getPositiveTolerance() {
        return this.positiveTolerance;
    }

    public short getNegativeTolerance() {
        return this.negativeTolerance;
    }

    public SensorSamplingFunction getSensorSamplingFunction() {
        return this.sensorSamplingFunction;
    }

    public byte getMeasurementPeriod() {
        return this.measurementPeriod;
    }

    public byte getUpdateInterval() {
        return this.updateInterval;
    }

    public String toString() {
        return "SensorDescriptor{property=" + Integer.toString(this.property.getPropertyId(), 16) + ", positiveTolerance=" + Integer.toHexString(this.positiveTolerance) + ", negativeTolerance=" + Integer.toHexString(this.negativeTolerance) + ", sensorSamplingFunction=" + this.sensorSamplingFunction.getSensorSamplingFunction() + ", measurementPeriod=" + Integer.toHexString(this.measurementPeriod) + ", updateInterval=" + Integer.toHexString(this.updateInterval) + '}';
    }
}

