/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.UUID;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.models.ConfigurationServerModel;
import no.nordicsemi.android.mesh.models.SceneServer;
import no.nordicsemi.android.mesh.models.SigModelParser;
import no.nordicsemi.android.mesh.models.VendorModel;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.transport.PublicationSettings;
import no.nordicsemi.android.mesh.utils.HeartbeatPublication;
import no.nordicsemi.android.mesh.utils.HeartbeatSubscription;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class InternalMeshModelDeserializer
implements JsonDeserializer<MeshModel> {
    public MeshModel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.getAsJsonObject().has("data")) {
            JsonObject jsonObject = json.getAsJsonObject().getAsJsonObject("data");
            return this.parsePreMigrationMeshModel(jsonObject);
        }
        JsonObject jsonObject = json.getAsJsonObject();
        return this.parseMigratedMeshModel(jsonObject);
    }

    private MeshModel parsePreMigrationMeshModel(JsonObject jsonObject) {
        int modelId = jsonObject.getAsJsonObject().get("mModelId").getAsInt();
        MeshModel meshModel = this.getMeshModel(modelId);
        JsonArray jsonArrayBoundKeyIndexes = jsonObject.getAsJsonObject().getAsJsonArray("mBoundAppKeyIndexes");
        JsonObject jsonBoundKeys = jsonObject.getAsJsonObject().get("mBoundAppKeys").getAsJsonObject();
        for (int i = 0; i < jsonArrayBoundKeyIndexes.size(); ++i) {
            int index = jsonArrayBoundKeyIndexes.get(i).getAsInt();
            String key = jsonBoundKeys.get(String.valueOf(index)).getAsString();
            meshModel.mBoundAppKeyIndexes.add(index);
        }
        JsonArray jsonSubscriptionAddresses = jsonObject.getAsJsonObject().get("mSubscriptionAddress").getAsJsonArray();
        for (int i = 0; i < jsonSubscriptionAddresses.size(); ++i) {
            JsonArray jsonArray = jsonSubscriptionAddresses.get(i).getAsJsonArray();
            byte[] subscriptionAddress = new byte[2];
            for (int j = 0; j < jsonArray.size(); ++j) {
                subscriptionAddress[j] = jsonArray.get(j).getAsByte();
            }
            meshModel.addSubscriptionAddress(MeshAddress.addressBytesToInt(subscriptionAddress));
        }
        if (jsonObject.getAsJsonObject().has("mPublicationSettings")) {
            JsonObject jsonPublicationSettings = jsonObject.getAsJsonObject().get("mPublicationSettings").getAsJsonObject();
            if (jsonPublicationSettings != null) {
                int appKeyIndex = jsonPublicationSettings.get("appKeyIndex").getAsInt();
                boolean credentialFlag = jsonPublicationSettings.get("credentialFlag").getAsBoolean();
                int publicationResolution = jsonPublicationSettings.get("publicationResolution").getAsInt();
                int publicationSteps = jsonPublicationSettings.get("publicationSteps").getAsInt();
                if (jsonPublicationSettings.has("publishAddress")) {
                    int publishAddress;
                    JsonElement jsonElement = jsonPublicationSettings.get("publishAddress");
                    if (jsonElement.isJsonArray()) {
                        JsonArray jsonPublishAddress = jsonElement.getAsJsonArray();
                        byte[] address = new byte[jsonPublishAddress.size()];
                        for (int i = 0; i < jsonPublishAddress.size(); ++i) {
                            address[i] = jsonPublishAddress.get(i).getAsByte();
                        }
                        publishAddress = MeshParserUtils.unsignedBytesToInt(address[1], address[0]);
                    } else {
                        publishAddress = jsonElement.getAsInt();
                    }
                    int publishRetransmitCount = jsonPublicationSettings.get("publishRetransmitCount").getAsInt();
                    int publishRetransmitIntervalSteps = jsonPublicationSettings.get("publishRetransmitIntervalSteps").getAsInt();
                    byte publishTtl = jsonPublicationSettings.get("publishRetransmitIntervalSteps").getAsByte();
                    meshModel.mPublicationSettings = new PublicationSettings(publishAddress, appKeyIndex, credentialFlag, publishTtl, publicationSteps, publicationResolution, publishRetransmitCount, publishRetransmitIntervalSteps);
                }
            }
        } else {
            byte[] publishKeyAppIndex = new byte[2];
            JsonObject jsonPublicationSettings = jsonObject.getAsJsonObject();
            if (jsonPublicationSettings.has("publishAppKeyIndex")) {
                JsonArray jsonPublishKeyIndex = jsonObject.getAsJsonObject().get("publishAppKeyIndex").getAsJsonArray();
                for (int i = 0; i < jsonPublishKeyIndex.size(); ++i) {
                    publishKeyAppIndex[i] = jsonPublishKeyIndex.get(i).getAsByte();
                }
            }
            if (jsonPublicationSettings.has("publishAddress")) {
                int publishAddress;
                JsonElement jsonElement = jsonPublicationSettings.get("publishAddress");
                if (jsonElement.isJsonArray()) {
                    JsonArray jsonPublishAddress = jsonElement.getAsJsonArray();
                    byte[] address = new byte[jsonPublishAddress.size()];
                    for (int i = 0; i < jsonPublishAddress.size(); ++i) {
                        address[i] = jsonPublishAddress.get(i).getAsByte();
                    }
                    publishAddress = MeshParserUtils.unsignedBytesToInt(address[1], address[0]);
                } else {
                    publishAddress = jsonElement.getAsInt();
                }
                int publicationResolution = jsonPublicationSettings.get("publicationResolution").getAsInt();
                int publicationSteps = jsonPublicationSettings.get("publicationSteps").getAsInt();
                int publishPeriod = jsonPublicationSettings.get("publishPeriod").getAsInt();
                int publishRetransmitCount = jsonPublicationSettings.get("publishRetransmitCount").getAsInt();
                int publishRetransmitIntervalSteps = jsonPublicationSettings.get("publishRetransmitIntervalSteps").getAsInt();
                int publishTtl = jsonPublicationSettings.get("publishTtl").getAsInt();
                meshModel.mPublicationSettings = new PublicationSettings(publishAddress, MeshParserUtils.removeKeyIndexPadding(publishKeyAppIndex), false, publishTtl, publicationSteps, publicationResolution, publishRetransmitCount, publishRetransmitIntervalSteps);
            }
        }
        return meshModel;
    }

    private MeshModel parseMigratedMeshModel(JsonObject jsonObject) {
        JsonObject jsonPublicationSettings;
        int i;
        JsonArray addresses;
        int modelId = jsonObject.get("mModelId").getAsInt();
        MeshModel meshModel = this.getMeshModel(modelId);
        if (meshModel instanceof ConfigurationServerModel) {
            int period;
            JsonObject heartbeatPub;
            int destination;
            if (jsonObject.has("heartbeatPub") && !MeshAddress.isValidUnassignedAddress(destination = (heartbeatPub = jsonObject.get("heartbeatPub").getAsJsonObject()).has("address") && !heartbeatPub.has("destination") ? heartbeatPub.get("address").getAsInt() : heartbeatPub.get("destination").getAsInt())) {
                int countLog = heartbeatPub.get("count").getAsInt();
                period = heartbeatPub.get("period").getAsInt();
                int ttl = heartbeatPub.get("ttl").getAsInt();
                int index = heartbeatPub.get("index").getAsInt();
                JsonObject featuresJson = heartbeatPub.get("features").getAsJsonObject();
                Features features = new Features(featuresJson.get("friend").getAsInt(), featuresJson.get("lowPower").getAsInt(), featuresJson.get("relay").getAsInt(), featuresJson.get("proxy").getAsInt());
                ((ConfigurationServerModel)meshModel).setHeartbeatPublication(new HeartbeatPublication(destination, (byte)countLog, (byte)period, ttl, features, index));
            }
            if (jsonObject.has("heartbeatSub")) {
                JsonObject heartbeatSub = jsonObject.get("heartbeatSub").getAsJsonObject();
                int source = heartbeatSub.get("source").getAsInt();
                int destination2 = heartbeatSub.has("address") && !heartbeatSub.has("destination") ? heartbeatSub.get("address").getAsInt() : heartbeatSub.get("destination").getAsInt();
                if (MeshAddress.isValidUnassignedAddress(destination2)) {
                    period = heartbeatSub.get("period").getAsInt();
                    int countLog = heartbeatSub.get("count").getAsInt();
                    int minHops = heartbeatSub.get("minHops").getAsInt();
                    int maxHops = heartbeatSub.get("maxHops").getAsInt();
                    ((ConfigurationServerModel)meshModel).setHeartbeatSubscription(new HeartbeatSubscription(source, destination2, (byte)period, (byte)countLog, minHops, maxHops));
                }
            }
        }
        if (meshModel instanceof SceneServer && jsonObject.has("sceneNumbers")) {
            JsonArray scenesArray = jsonObject.get("sceneNumbers").getAsJsonArray();
            for (JsonElement element : scenesArray) {
                meshModel.sceneNumbers.add(element.getAsInt());
            }
        }
        JsonArray jsonArrayBoundKeyIndexes = jsonObject.getAsJsonArray("mBoundAppKeyIndexes");
        for (int i2 = 0; i2 < jsonArrayBoundKeyIndexes.size(); ++i2) {
            int index = jsonArrayBoundKeyIndexes.get(i2).getAsInt();
            meshModel.mBoundAppKeyIndexes.add(index);
        }
        if (jsonObject.has("mSubscriptionAddress") && (addresses = jsonObject.getAsJsonArray("mSubscriptionAddress")).size() > 0) {
            for (i = 0; i < addresses.size(); ++i) {
                JsonArray jsonArray = addresses.get(i).getAsJsonArray();
                int address = MeshParserUtils.unsignedBytesToInt(jsonArray.get(1).getAsByte(), jsonArray.get(0).getAsByte());
                meshModel.addSubscriptionAddress(address);
            }
        }
        if (jsonObject.has("labelUuids")) {
            JsonArray labelUuids = jsonObject.get("labelUuids").getAsJsonArray();
            for (i = 0; i < labelUuids.size(); ++i) {
                String hexUuid = labelUuids.get(i).getAsString().toUpperCase(Locale.US);
                UUID uuid = UUID.fromString(hexUuid);
                if (uuid == null) continue;
                meshModel.labelUuids.add(uuid);
            }
        }
        if (jsonObject.has("subscriptionAddresses") && (addresses = jsonObject.get("subscriptionAddresses").getAsJsonArray()) != null) {
            for (i = 0; i < addresses.size(); ++i) {
                meshModel.addSubscriptionAddress(addresses.get(i).getAsInt());
            }
        }
        if (jsonObject.getAsJsonObject().has("mPublicationSettings") && (jsonPublicationSettings = jsonObject.get("mPublicationSettings").getAsJsonObject()) != null) {
            int appKeyIndex = jsonPublicationSettings.get("appKeyIndex").getAsInt();
            boolean credentialFlag = jsonPublicationSettings.get("credentialFlag").getAsBoolean();
            int publicationResolution = jsonPublicationSettings.get("publicationResolution").getAsInt();
            int publicationSteps = jsonPublicationSettings.get("publicationSteps").getAsInt();
            if (jsonPublicationSettings.has("publishAddress")) {
                int publishAddress;
                UUID labelUUID = null;
                JsonElement jsonElement = jsonPublicationSettings.get("publishAddress");
                if (jsonElement.isJsonArray()) {
                    JsonArray jsonPublishAddress = jsonElement.getAsJsonArray();
                    byte[] address = new byte[jsonPublishAddress.size()];
                    for (int i3 = 0; i3 < jsonPublishAddress.size(); ++i3) {
                        address[i3] = jsonPublishAddress.get(i3).getAsByte();
                    }
                    publishAddress = MeshParserUtils.unsignedBytesToInt(address[1], address[0]);
                } else {
                    publishAddress = jsonElement.getAsInt();
                }
                if (MeshAddress.isValidUnassignedAddress(publishAddress)) {
                    return meshModel;
                }
                if (jsonPublicationSettings.has("labelUUID")) {
                    String uuid = jsonPublicationSettings.get("labelUUID").getAsString();
                    labelUUID = UUID.fromString(uuid);
                }
                int publishRetransmitCount = jsonPublicationSettings.get("publishRetransmitCount").getAsInt();
                int publishRetransmitIntervalSteps = jsonPublicationSettings.get("publishRetransmitIntervalSteps").getAsInt();
                byte publishTtl = jsonPublicationSettings.get("publishRetransmitIntervalSteps").getAsByte();
                meshModel.mPublicationSettings = new PublicationSettings(publishAddress, appKeyIndex, credentialFlag, publishTtl, publicationSteps, publicationResolution, publishRetransmitCount, publishRetransmitIntervalSteps);
                meshModel.mPublicationSettings.setLabelUUID(labelUUID);
            }
        }
        return meshModel;
    }

    private byte[] getKey(JsonArray array) {
        byte[] key = new byte[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            key[i] = array.get(i).getAsByte();
        }
        return key;
    }

    private MeshModel getMeshModel(int modelId) {
        if (modelId < Short.MIN_VALUE || modelId > Short.MAX_VALUE) {
            return new VendorModel(modelId);
        }
        return SigModelParser.getSigModel(modelId);
    }
}

