/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class LightLightnessStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = LightLightnessStatus.class.getSimpleName();
    private static final int LIGHT_LIGHTNESS_STATUS_MANDATORY_LENGTH = 2;
    private static final int OP_CODE = 33358;
    private int mPresentLightness;
    private Integer mTargetLightness;
    private int mTransitionSteps;
    private int mTransitionResolution;
    private static final Parcelable.Creator<LightLightnessStatus> CREATOR = new Parcelable.Creator<LightLightnessStatus>(){

        public LightLightnessStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new LightLightnessStatus(message);
        }

        public LightLightnessStatus[] newArray(int size) {
            return new LightLightnessStatus[size];
        }
    };

    public LightLightnessStatus(@NonNull AccessMessage message) {
        super(message);
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        Log.v((String)TAG, (String)("Received light lightness status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true)));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.mPresentLightness = buffer.getShort() & 0xFFFF;
        Log.v((String)TAG, (String)("Present level: " + this.mPresentLightness));
        if (buffer.limit() > 2) {
            this.mTargetLightness = buffer.getShort() & 0xFFFF;
            int remainingTime = buffer.get() & 0xFF;
            this.mTransitionSteps = remainingTime & 0x3F;
            this.mTransitionResolution = remainingTime >> 6;
            Log.v((String)TAG, (String)("Target level: " + this.mTargetLightness));
            Log.v((String)TAG, (String)("Remaining time, transition number of steps: " + this.mTransitionSteps));
            Log.v((String)TAG, (String)("Remaining time, transition number of step resolution: " + this.mTransitionResolution));
            Log.v((String)TAG, (String)("Remaining time: " + MeshParserUtils.getRemainingTime(remainingTime)));
        }
    }

    @Override
    public int getOpCode() {
        return 33358;
    }

    public final int getPresentLightness() {
        return this.mPresentLightness;
    }

    public final Integer getTargetLightness() {
        return this.mTargetLightness;
    }

    public int getTransitionSteps() {
        return this.mTransitionSteps;
    }

    public int getTransitionResolution() {
        return this.mTransitionResolution;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

