/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class SensorSettingSet
extends ApplicationMessage {
    private static final String TAG = SensorSettingSet.class.getSimpleName();
    private static final int OP_CODE = 89;
    private final DeviceProperty propertyId;
    private final DeviceProperty sensorSettingPropertyId;
    private final DevicePropertyCharacteristic<?> sensorSetting;

    public SensorSettingSet(@NonNull ApplicationKey appKey, @NonNull DeviceProperty propertyId, @NonNull DeviceProperty sensorSettingPropertyId, @NonNull DevicePropertyCharacteristic<?> sensorSetting) {
        super(appKey);
        this.propertyId = propertyId;
        this.sensorSettingPropertyId = sensorSettingPropertyId;
        this.sensorSetting = sensorSetting;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 89;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        this.mParameters = ByteBuffer.allocate(4 + this.sensorSetting.getLength()).order(ByteOrder.LITTLE_ENDIAN).putShort(this.propertyId.getPropertyId()).putShort(this.sensorSettingPropertyId.getPropertyId()).put(this.sensorSetting.getBytes()).array();
    }

    public DeviceProperty getPropertyId() {
        return this.propertyId;
    }

    public DeviceProperty getSensorSettingPropertyId() {
        return this.sensorSettingPropertyId;
    }
}

