/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.UUID;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.ApplicationMessageState;
import no.nordicsemi.android.mesh.transport.InternalMeshMsgHandlerCallbacks;
import no.nordicsemi.android.mesh.transport.MeshMessageState;
import no.nordicsemi.android.mesh.transport.MeshTransport;
import no.nordicsemi.android.mesh.transport.VendorModelMessageUnacked;

class VendorModelMessageUnackedState
extends ApplicationMessageState {
    private static final String TAG = VendorModelMessageUnackedState.class.getSimpleName();

    VendorModelMessageUnackedState(int src, int dst, @NonNull VendorModelMessageUnacked vendorModelMessageUnacked, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        this(src, dst, null, vendorModelMessageUnacked, meshTransport, callbacks);
    }

    VendorModelMessageUnackedState(int src, int dst, @Nullable UUID label, @NonNull VendorModelMessageUnacked vendorModelMessageUnacked, @NonNull MeshTransport meshTransport, @NonNull InternalMeshMsgHandlerCallbacks callbacks) throws IllegalArgumentException {
        super(src, dst, vendorModelMessageUnacked, meshTransport, callbacks);
    }

    @Override
    public MeshMessageState.MessageState getState() {
        return MeshMessageState.MessageState.VENDOR_MODEL_UNACKNOWLEDGED_STATE;
    }

    @Override
    protected final void createAccessMessage() {
        VendorModelMessageUnacked message = (VendorModelMessageUnacked)this.mMeshMessage;
        ApplicationKey key = message.getAppKey();
        int akf = message.getAkf();
        int aid = message.getAid();
        int aszmic = message.getAszmic();
        int opCode = message.getOpCode();
        byte[] parameters = message.getParameters();
        int companyIdentifier = message.getCompanyIdentifier();
        this.message = this.mMeshTransport.createVendorMeshMessage(companyIdentifier, this.mSrc, this.mDst, this.mLabel, message.messageTtl, key, akf, aid, aszmic, opCode, parameters);
        message.setMessage(this.message);
    }

    @Override
    public void executeSend() {
        Log.v((String)TAG, (String)"Sending acknowledged vendor model message");
        super.executeSend();
    }
}

