/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import no.nordicsemi.android.mesh.IvIndex;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.data.MeshNetworkDao;

public final class MeshNetworkDao_Impl
implements MeshNetworkDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MeshNetwork> __insertionAdapterOfMeshNetwork;
    private final EntityDeletionOrUpdateAdapter<MeshNetwork> __deletionAdapterOfMeshNetwork;
    private final EntityDeletionOrUpdateAdapter<MeshNetwork> __updateAdapterOfMeshNetwork;
    private final SharedSQLiteStatement __preparedStmtOfUpdate;
    private final SharedSQLiteStatement __preparedStmtOfUpdate_1;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public MeshNetworkDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMeshNetwork = new EntityInsertionAdapter<MeshNetwork>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `mesh_network` (`mesh_uuid`,`mesh_name`,`timestamp`,`partial`,`iv_index`,`network_exclusions`,`last_selected`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, MeshNetwork value) {
                if (value.getMeshUUID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUUID());
                }
                if (value.getMeshName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshName());
                }
                stmt.bindLong(3, value.getTimestamp());
                int _tmp = value.isPartial() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                String _tmp_1 = MeshTypeConverters.ivIndexToJson(value.getIvIndex());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = MeshTypeConverters.networkExclusionsToJson(value.getNetworkExclusions());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                int _tmp_3 = value.isLastSelected() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_3);
            }
        };
        this.__deletionAdapterOfMeshNetwork = new EntityDeletionOrUpdateAdapter<MeshNetwork>(__db){

            public String createQuery() {
                return "DELETE FROM `mesh_network` WHERE `mesh_uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MeshNetwork value) {
                if (value.getMeshUUID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUUID());
                }
            }
        };
        this.__updateAdapterOfMeshNetwork = new EntityDeletionOrUpdateAdapter<MeshNetwork>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `mesh_network` SET `mesh_uuid` = ?,`mesh_name` = ?,`timestamp` = ?,`partial` = ?,`iv_index` = ?,`network_exclusions` = ?,`last_selected` = ? WHERE `mesh_uuid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, MeshNetwork value) {
                if (value.getMeshUUID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMeshUUID());
                }
                if (value.getMeshName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMeshName());
                }
                stmt.bindLong(3, value.getTimestamp());
                int _tmp = value.isPartial() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                String _tmp_1 = MeshTypeConverters.ivIndexToJson(value.getIvIndex());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = MeshTypeConverters.networkExclusionsToJson(value.getNetworkExclusions());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                int _tmp_3 = value.isLastSelected() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_3);
                if (value.getMeshUUID() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getMeshUUID());
                }
            }
        };
        this.__preparedStmtOfUpdate = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE mesh_network SET last_selected = ? WHERE mesh_uuid IS NOT ?";
                return "UPDATE mesh_network SET last_selected = ? WHERE mesh_uuid IS NOT ?";
            }
        };
        this.__preparedStmtOfUpdate_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE mesh_network SET mesh_name = ?, timestamp = ?, partial =?, iv_index =?, last_selected =?, network_exclusions =? WHERE mesh_uuid = ?";
                return "UPDATE mesh_network SET mesh_name = ?, timestamp = ?, partial =?, iv_index =?, last_selected =?, network_exclusions =? WHERE mesh_uuid = ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM mesh_network";
                return "DELETE FROM mesh_network";
            }
        };
    }

    @Override
    public void insert(MeshNetwork meshNetwork) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMeshNetwork.insert((Object)meshNetwork);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(MeshNetwork meshNetwork) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMeshNetwork.handle((Object)meshNetwork);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(MeshNetwork meshNetwork) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMeshNetwork.handle((Object)meshNetwork);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<MeshNetwork> networks) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMeshNetwork.handleMultiple(networks);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String uuid, boolean lastSelected) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdate.acquire();
        int _argIndex = 1;
        int _tmp = lastSelected ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        if (uuid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, uuid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdate.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String meshUUID, String meshName, long timestamp, boolean partial, String ivIndex, boolean lastSelected, String networkExclusions) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdate_1.acquire();
        int _argIndex = 1;
        if (meshName == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, meshName);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, timestamp);
        _argIndex = 3;
        int _tmp = partial ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 4;
        if (ivIndex == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, ivIndex);
        }
        _argIndex = 5;
        int _tmp_1 = lastSelected ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 6;
        if (networkExclusions == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, networkExclusions);
        }
        _argIndex = 7;
        if (meshUUID == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, meshUUID);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdate_1.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MeshNetwork> getMeshNetworks() {
        String _sql = "SELECT * from mesh_network";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from mesh_network", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMeshUUID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfMeshName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_name");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"partial");
            int _cursorIndexOfIvIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_index");
            int _cursorIndexOfNetworkExclusions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"network_exclusions");
            int _cursorIndexOfLastSelected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_selected");
            ArrayList<MeshNetwork> _result = new ArrayList<MeshNetwork>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpMeshUUID = _cursor.isNull(_cursorIndexOfMeshUUID) ? null : _cursor.getString(_cursorIndexOfMeshUUID);
                MeshNetwork _item = new MeshNetwork(_tmpMeshUUID);
                String _tmpMeshName = _cursor.isNull(_cursorIndexOfMeshName) ? null : _cursor.getString(_cursorIndexOfMeshName);
                _item.setMeshName(_tmpMeshName);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                int _tmp = _cursor.getInt(_cursorIndexOfPartial);
                boolean _tmpPartial = _tmp != 0;
                _item.setPartial(_tmpPartial);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfIvIndex) ? null : _cursor.getString(_cursorIndexOfIvIndex);
                IvIndex _tmpIvIndex = MeshTypeConverters.fromJsonToIvIndex(_tmp_1);
                _item.setIvIndex(_tmpIvIndex);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfNetworkExclusions) ? null : _cursor.getString(_cursorIndexOfNetworkExclusions);
                Map<Integer, ArrayList<Integer>> _tmpNetworkExclusions = MeshTypeConverters.fromJsonToNetworkExclusions(_tmp_2);
                _item.setNetworkExclusions((Map)_tmpNetworkExclusions);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfLastSelected);
                boolean _tmpLastSelected = _tmp_3 != 0;
                _item.setLastSelected(_tmpLastSelected);
                _result.add(_item);
            }
            ArrayList<MeshNetwork> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeshNetwork getMeshNetwork(String meshUuid) {
        String _sql = "SELECT * from mesh_network WHERE mesh_uuid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from mesh_network WHERE mesh_uuid = ?", (int)1);
        int _argIndex = 1;
        if (meshUuid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, meshUuid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            MeshNetwork _result;
            int _cursorIndexOfMeshUUID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfMeshName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_name");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"partial");
            int _cursorIndexOfIvIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_index");
            int _cursorIndexOfNetworkExclusions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"network_exclusions");
            int _cursorIndexOfLastSelected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_selected");
            if (_cursor.moveToFirst()) {
                String _tmpMeshUUID = _cursor.isNull(_cursorIndexOfMeshUUID) ? null : _cursor.getString(_cursorIndexOfMeshUUID);
                _result = new MeshNetwork(_tmpMeshUUID);
                String _tmpMeshName = _cursor.isNull(_cursorIndexOfMeshName) ? null : _cursor.getString(_cursorIndexOfMeshName);
                _result.setMeshName(_tmpMeshName);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
                int _tmp = _cursor.getInt(_cursorIndexOfPartial);
                boolean _tmpPartial = _tmp != 0;
                _result.setPartial(_tmpPartial);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfIvIndex) ? null : _cursor.getString(_cursorIndexOfIvIndex);
                IvIndex _tmpIvIndex = MeshTypeConverters.fromJsonToIvIndex(_tmp_1);
                _result.setIvIndex(_tmpIvIndex);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfNetworkExclusions) ? null : _cursor.getString(_cursorIndexOfNetworkExclusions);
                Map<Integer, ArrayList<Integer>> _tmpNetworkExclusions = MeshTypeConverters.fromJsonToNetworkExclusions(_tmp_2);
                _result.setNetworkExclusions((Map)_tmpNetworkExclusions);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfLastSelected);
                boolean _tmpLastSelected = _tmp_3 != 0;
                _result.setLastSelected(_tmpLastSelected);
            } else {
                _result = null;
            }
            MeshNetwork meshNetwork = _result;
            return meshNetwork;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeshNetwork getMeshNetwork(boolean lastSelected) {
        String _sql = "SELECT * from mesh_network WHERE last_selected IS ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from mesh_network WHERE last_selected IS ?", (int)1);
        int _argIndex = 1;
        int _tmp = lastSelected ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            MeshNetwork _result;
            int _cursorIndexOfMeshUUID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_uuid");
            int _cursorIndexOfMeshName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mesh_name");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfPartial = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"partial");
            int _cursorIndexOfIvIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"iv_index");
            int _cursorIndexOfNetworkExclusions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"network_exclusions");
            int _cursorIndexOfLastSelected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"last_selected");
            if (_cursor.moveToFirst()) {
                String _tmpMeshUUID = _cursor.isNull(_cursorIndexOfMeshUUID) ? null : _cursor.getString(_cursorIndexOfMeshUUID);
                _result = new MeshNetwork(_tmpMeshUUID);
                String _tmpMeshName = _cursor.isNull(_cursorIndexOfMeshName) ? null : _cursor.getString(_cursorIndexOfMeshName);
                _result.setMeshName(_tmpMeshName);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfPartial);
                boolean _tmpPartial = _tmp_1 != 0;
                _result.setPartial(_tmpPartial);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfIvIndex) ? null : _cursor.getString(_cursorIndexOfIvIndex);
                IvIndex _tmpIvIndex = MeshTypeConverters.fromJsonToIvIndex(_tmp_2);
                _result.setIvIndex(_tmpIvIndex);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfNetworkExclusions) ? null : _cursor.getString(_cursorIndexOfNetworkExclusions);
                Map<Integer, ArrayList<Integer>> _tmpNetworkExclusions = MeshTypeConverters.fromJsonToNetworkExclusions(_tmp_3);
                _result.setNetworkExclusions((Map)_tmpNetworkExclusions);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfLastSelected);
                boolean _tmpLastSelected = _tmp_4 != 0;
                _result.setLastSelected(_tmpLastSelected);
            } else {
                _result = null;
            }
            MeshNetwork meshNetwork = _result;
            return meshNetwork;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

