/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import java.security.InvalidParameterException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import no.nordicsemi.android.mesh.data.GenericTransitionTime;
import no.nordicsemi.android.mesh.utils.BitReader;
import no.nordicsemi.android.mesh.utils.BitWriter;

public class ScheduleEntry {
    public static final int SCHEDULER_ENTRY_PARAMS_BITS_LENGTH = 76;
    public Year year = Year.Any;
    public Month month = Month.Any(Collections.emptyList());
    public Day day = Day.Any;
    public Hour hour = Hour.Value(12);
    public Minute minute = Minute.Value(0);
    public Second second = Second.Value(0);
    public DayOfWeek dayOfWeek = DayOfWeek.Any(Collections.emptyList());
    public Action action = Action.NoAction;
    public Scene scene = Scene.NoScene;
    public GenericTransitionTime transitionTime = new GenericTransitionTime(GenericTransitionTime.TransitionResolution.SECOND, GenericTransitionTime.TransitionStep.Immediate);

    public ScheduleEntry setYear(Year year) {
        this.year = year;
        return this;
    }

    public ScheduleEntry setMonth(Month month) {
        this.month = month;
        return this;
    }

    public ScheduleEntry setDay(Day day) {
        this.day = day;
        return this;
    }

    public ScheduleEntry setHour(Hour hour) {
        this.hour = hour;
        return this;
    }

    public ScheduleEntry setMinute(Minute minute) {
        this.minute = minute;
        return this;
    }

    public ScheduleEntry setSecond(Second second) {
        this.second = second;
        return this;
    }

    public ScheduleEntry setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    public ScheduleEntry setAction(Action action) {
        this.action = action;
        return this;
    }

    public ScheduleEntry setScene(Scene scene) {
        this.scene = scene;
        return this;
    }

    public ScheduleEntry setGenericTransitionTime(GenericTransitionTime genericTransitionTime) {
        this.transitionTime = genericTransitionTime;
        return this;
    }

    public void assembleMessageParameters(BitWriter bitWriter) {
        bitWriter.write(this.scene.value, 16);
        bitWriter.write(this.transitionTime.getValue(), 8);
        bitWriter.write(this.action.value, 4);
        bitWriter.write(this.dayOfWeek.value, 7);
        bitWriter.write(this.second.value, 6);
        bitWriter.write(this.minute.value, 6);
        bitWriter.write(this.hour.value, 5);
        bitWriter.write(this.day.value, 5);
        bitWriter.write(this.month.value, 12);
        bitWriter.write(this.year.value, 7);
    }

    public ScheduleEntry(BitReader bitReader) {
        if (bitReader.bitsLeft() <= 76) {
            throw new InvalidParameterException("Bitreader has not enough bits");
        }
        this.scene = new Scene(bitReader.getBits(16));
        this.transitionTime = new GenericTransitionTime(bitReader.getBits(8));
        this.action = new Action(bitReader.getBits(4));
        this.dayOfWeek = new DayOfWeek(bitReader.getBits(7));
        this.second = new Second(bitReader.getBits(6));
        this.minute = new Minute(bitReader.getBits(6));
        this.hour = new Hour(bitReader.getBits(5));
        this.day = new Day(bitReader.getBits(5));
        this.month = new Month(bitReader.getBits(12));
        this.year = new Year(bitReader.getBits(7));
    }

    public ScheduleEntry() {
    }

    public static int calculateBitValue(BitSet bitSet) {
        int value = 0;
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            value += i;
            i = bitSet.nextSetBit(i + 1);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleEntry entry = (ScheduleEntry)o;
        return this.year.equals(entry.year) && this.month.equals(entry.month) && this.day.equals(entry.day) && this.hour.equals(entry.hour) && this.minute.equals(entry.minute) && this.second.equals(entry.second) && this.dayOfWeek.equals(entry.dayOfWeek) && this.action.equals(entry.action) && this.scene.equals(entry.scene) && this.transitionTime.equals(entry.transitionTime);
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.day, this.hour, this.minute, this.second, this.dayOfWeek, this.action, this.scene, this.transitionTime);
    }

    public String toString() {
        return "ScheduleEntry{year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", second=" + this.second + ", dayOfWeek=" + this.dayOfWeek + ", action=" + this.action + ", scene=" + this.scene + ", transitionTime=" + this.transitionTime + '}';
    }

    public static final class Scene
    extends EntryType {
        public static Scene NoScene = new Scene(0);

        private Scene(int value) {
            super(value);
        }

        public static Scene Address(int address) {
            return new Scene(address);
        }

        public String toString() {
            return "Scene{value=" + this.value + '}';
        }
    }

    public static final class Action
    extends EntryType {
        public static Action TurnOff = new Action(0);
        public static Action TurnOn = new Action(1);
        public static Action SceneRecall = new Action(2);
        public static Action NoAction = new Action(15);

        private Action(int value) {
            super(value);
        }

        public String toString() {
            return "Action{value=" + this.value + '}';
        }
    }

    public static final class DayOfWeek
    extends EntryType {
        public static DayOfWeek MONDAY = new DayOfWeek(1);
        public static DayOfWeek TUESDAY = new DayOfWeek(2);
        public static DayOfWeek WEDNESDAY = new DayOfWeek(4);
        public static DayOfWeek THURSDAY = new DayOfWeek(8);
        public static DayOfWeek FRIDAY = new DayOfWeek(16);
        public static DayOfWeek SATURDAY = new DayOfWeek(32);
        public static DayOfWeek SUNDAY = new DayOfWeek(64);

        private DayOfWeek(int value) {
            super(value);
        }

        public static DayOfWeek Any(List<DayOfWeek> values) {
            BitSet bitSet = new BitSet(12);
            for (DayOfWeek dayOfWeek : values) {
                BitSet dayOfWeekBit = new BitSet();
                dayOfWeekBit.set(dayOfWeek.value);
                bitSet.or(dayOfWeekBit);
            }
            return new DayOfWeek(ScheduleEntry.calculateBitValue(bitSet));
        }

        public String toString() {
            return "DayOfWeek{value=" + this.value + '}';
        }
    }

    public static final class Second
    extends EntryType {
        public static Second Any = new Second(60);
        public static Second Every15 = new Second(61);
        public static Second Every20 = new Second(62);
        public static Second Random = new Second(63);

        private Second(int value) {
            super(value);
        }

        public static Second Value(int value) {
            return new Second(Math.min(value, 59));
        }

        public String toString() {
            return "Second{value=" + this.value + '}';
        }
    }

    public static final class Minute
    extends EntryType {
        public static Minute Any = new Minute(60);
        public static Minute Every15 = new Minute(61);
        public static Minute Every20 = new Minute(62);
        public static Minute Random = new Minute(63);

        private Minute(int value) {
            super(value);
        }

        public static Minute Value(int value) {
            return new Minute(Math.min(value, 59));
        }

        public String toString() {
            return "Minute{value=" + this.value + '}';
        }
    }

    public static final class Hour
    extends EntryType {
        public static Hour Any = new Hour(24);
        public static Hour Random = new Hour(25);

        private Hour(int value) {
            super(value);
        }

        public static Hour Value(int value) {
            return new Hour(Math.min(value, 23));
        }

        public String toString() {
            return "Hour{value=" + this.value + '}';
        }
    }

    public static final class Day
    extends EntryType {
        public static Day Any = new Day(0);

        private Day(int value) {
            super(value);
        }

        public static Day Value(int value) {
            return new Day(Math.min(value, 31));
        }

        public String toString() {
            return "Day{value=" + this.value + '}';
        }
    }

    public static final class Month
    extends EntryType {
        public static Month JANUARY = new Month(1);
        public static Month FEBRUARY = new Month(2);
        public static Month MARCH = new Month(4);
        public static Month APRIL = new Month(8);
        public static Month MAY = new Month(16);
        public static Month JUNE = new Month(32);
        public static Month JULY = new Month(64);
        public static Month AUGUST = new Month(128);
        public static Month SEPTEMBER = new Month(256);
        public static Month OCTOBER = new Month(512);
        public static Month NOVEMBER = new Month(1024);
        public static Month DECEMBER = new Month(2048);

        private Month(int value) {
            super(value);
        }

        public static Month Any(List<Month> values) {
            BitSet bitSet = new BitSet(12);
            for (Month month : values) {
                BitSet monthBit = new BitSet();
                monthBit.set(month.value);
                bitSet.or(monthBit);
            }
            return new Month(ScheduleEntry.calculateBitValue(bitSet));
        }

        public String toString() {
            return "Month{value=" + this.value + '}';
        }
    }

    public static final class Year
    extends EntryType {
        public static Year Any = new Year(100);

        private Year(int value) {
            super(value);
        }

        public static Year Specific(int lastTwoDigest) {
            return new Year(Math.min(lastTwoDigest, 99));
        }

        public String toString() {
            return "Year{value=" + this.value + '}';
        }
    }

    private static abstract class EntryType {
        protected int value;

        public int getValue() {
            return this.value;
        }

        protected EntryType(int value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryType entry = (EntryType)o;
            return this.value == entry.value;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

