/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public final class ConfigModelAppUnbind
extends ConfigMessage {
    private static final String TAG = ConfigModelAppUnbind.class.getSimpleName();
    private static final int OP_CODE = 32831;
    private static final int SIG_MODEL_APP_KEY_BIND_PARAMS_LENGTH = 6;
    private static final int VENDOR_MODEL_APP_KEY_BIND_PARAMS_LENGTH = 8;
    private final int mElementAddress;
    private final int mModelIdentifier;
    private final int mAppKeyIndex;

    public ConfigModelAppUnbind(int elementAddress, int modelIdentifier, int appKeyIndex) throws IllegalArgumentException {
        if (!MeshAddress.isValidUnicastAddress(elementAddress)) {
            throw new IllegalArgumentException("Invalid unicast address, unicast address must be a 16-bit value, and must range from 0x0001 to 0x7FFF");
        }
        this.mElementAddress = elementAddress;
        this.mModelIdentifier = modelIdentifier;
        this.mAppKeyIndex = appKeyIndex;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 32831;
    }

    @Override
    void assembleMessageParameters() {
        byte[] applicationKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mAppKeyIndex);
        if (this.mModelIdentifier >= Short.MIN_VALUE && this.mModelIdentifier <= Short.MAX_VALUE) {
            ByteBuffer paramsBuffer = ByteBuffer.allocate(6).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mElementAddress);
            paramsBuffer.put(applicationKeyIndex[1]);
            paramsBuffer.put(applicationKeyIndex[0]);
            paramsBuffer.putShort((short)this.mModelIdentifier);
            this.mParameters = paramsBuffer.array();
        } else {
            ByteBuffer paramsBuffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
            paramsBuffer.putShort((short)this.mElementAddress);
            paramsBuffer.put(applicationKeyIndex[1]);
            paramsBuffer.put(applicationKeyIndex[0]);
            byte[] modelIdentifier = new byte[]{(byte)(this.mModelIdentifier >> 24 & 0xFF), (byte)(this.mModelIdentifier >> 16 & 0xFF), (byte)(this.mModelIdentifier >> 8 & 0xFF), (byte)(this.mModelIdentifier & 0xFF)};
            paramsBuffer.put(modelIdentifier[1]);
            paramsBuffer.put(modelIdentifier[0]);
            paramsBuffer.put(modelIdentifier[3]);
            paramsBuffer.put(modelIdentifier[2]);
            this.mParameters = paramsBuffer.array();
        }
    }

    public int getElementAddress() {
        return this.mElementAddress;
    }

    public int getModelIdentifier() {
        return this.mModelIdentifier;
    }

    public int getAppKeyIndex() {
        return this.mAppKeyIndex;
    }
}

