/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class GenericManufacturerPropertySet
extends ApplicationMessage {
    private static final int PROPERTY_SET_PARAMS_LENGTH = 3;
    private final short propertyId;
    private final byte userAccess;

    public GenericManufacturerPropertySet(@NonNull ApplicationKey appKey, short propertyId, byte userAccess) {
        super(appKey);
        this.propertyId = propertyId;
        this.userAccess = userAccess;
        this.assembleMessageParameters();
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        this.mParameters = ByteBuffer.allocate(3).order(ByteOrder.LITTLE_ENDIAN).putShort(this.propertyId).put(this.userAccess).array();
    }

    @Override
    public int getOpCode() {
        return 68;
    }
}

