/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class GenericUserPropertySet
extends ApplicationMessage {
    private static final int PROPERTY_SET_PARAMS_LENGTH = 2;
    private final short propertyId;
    final byte[] values;

    public GenericUserPropertySet(@NonNull ApplicationKey appKey, short propertyId, byte[] values) {
        super(appKey);
        this.propertyId = propertyId;
        this.values = values;
        this.assembleMessageParameters();
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        this.mParameters = ByteBuffer.allocate(2 + this.values.length).order(ByteOrder.LITTLE_ENDIAN).putShort(this.propertyId).put(this.values).array();
    }

    @Override
    public int getOpCode() {
        return 76;
    }
}

