/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.data.ScheduleEntry;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.MeshAddress;

public class SchedulerStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = SchedulerStatus.class.getSimpleName();
    private static final int OP_CODE = 33354;
    private int schedules = ScheduleEntry.Action.NoAction.getValue();
    private static final Parcelable.Creator<SchedulerStatus> CREATOR = new Parcelable.Creator<SchedulerStatus>(){

        public SchedulerStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new SchedulerStatus(message);
        }

        public SchedulerStatus[] newArray(int size) {
            return new SchedulerStatus[size];
        }
    };

    public SchedulerStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        Log.v((String)TAG, (String)("Received scheduler status from: " + MeshAddress.formatAddress(this.mMessage.getSrc(), true)));
        ByteBuffer buffer = ByteBuffer.wrap(this.mParameters).order(ByteOrder.LITTLE_ENDIAN);
        this.schedules = buffer.get();
        Log.v((String)TAG, (String)("Schedules action: " + this.schedules));
    }

    @Override
    public int getOpCode() {
        return 33354;
    }

    public int getSchedules() {
        return this.schedules;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }
}

