/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.utils;

public class BitWriter {
    private byte[] buf;
    private int index;
    private int bit;

    public BitWriter() {
        this(10);
    }

    public BitWriter(int size) {
        this.buf = new byte[size];
    }

    public void write(int value, int numBits) {
        int i;
        if (numBits <= 0) {
            return;
        }
        byte[] bits = new byte[numBits];
        for (i = 0; i < numBits; ++i) {
            bits[i] = (byte)(value & 1);
            value >>= 1;
        }
        for (i = numBits - 1; i >= 0; --i) {
            int b = bits[i] << 7 - this.bit;
            int n = this.index++;
            this.buf[n] = (byte)(this.buf[n] | b);
            ++this.bit;
            if (this.bit <= 7) continue;
            this.bit = 0;
            if (this.index < this.buf.length) continue;
            byte[] newBuf = new byte[this.buf.length * 2];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    public byte[] toByteArray() {
        int size = this.index;
        if (this.bit > 0) {
            ++size;
        }
        byte[] b = new byte[size];
        System.arraycopy(this.buf, 0, b, 0, size);
        return b;
    }
}

