/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh;

import android.text.TextUtils;
import android.util.Log;
import android.util.SparseIntArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.room.ColumnInfo;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import no.nordicsemi.android.mesh.AllocatedGroupRange;
import no.nordicsemi.android.mesh.AllocatedSceneRange;
import no.nordicsemi.android.mesh.AllocatedUnicastRange;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.Group;
import no.nordicsemi.android.mesh.IvIndex;
import no.nordicsemi.android.mesh.MeshKey;
import no.nordicsemi.android.mesh.MeshNetworkCallbacks;
import no.nordicsemi.android.mesh.MeshTypeConverters;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.Scene;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.ProvisionedMeshNode;
import no.nordicsemi.android.mesh.utils.MeshAddress;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.ProxyFilter;
import no.nordicsemi.android.mesh.utils.SecureUtils;

abstract class BaseMeshNetwork {
    private static final String TAG = "BaseMeshNetwork";
    public static final int NORMAL_OPERATION = 0;
    public static final int IV_UPDATE_ACTIVE = 1;
    @SerializedName(value="meshUUID")
    @Expose
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="mesh_uuid")
    final String meshUUID;
    @Ignore
    protected final Comparator<ApplicationKey> appKeyComparator = (key1, key2) -> Integer.compare(key1.getKeyIndex(), key2.getKeyIndex());
    @Ignore
    protected final Comparator<NetworkKey> netKeyComparator = (key1, key2) -> Integer.compare(key1.getKeyIndex(), key2.getKeyIndex());
    @Ignore
    protected MeshNetworkCallbacks mCallbacks;
    @SerializedName(value="$schema")
    @Expose
    @Ignore
    String schema = "http://json-schema.org/draft-04/schema#";
    @SerializedName(value="id")
    @Expose
    @Ignore
    String id = "http://www.bluetooth.com/specifications/assigned-numbers/mesh-profile/cdb-schema.json#";
    @SerializedName(value="version")
    @Expose
    @Ignore
    String version = "1.0.0";
    @SerializedName(value="meshName")
    @Expose
    @ColumnInfo(name="mesh_name")
    String meshName = "nRF Mesh Network";
    @SerializedName(value="timestamp")
    @Expose
    @ColumnInfo(name="timestamp", defaultValue="0")
    long timestamp = System.currentTimeMillis();
    @SerializedName(value="partial")
    @Expose
    @ColumnInfo(name="partial", defaultValue="0")
    boolean partial = false;
    @Expose
    @ColumnInfo(name="iv_index")
    @TypeConverters(value={MeshTypeConverters.class})
    @NonNull
    IvIndex ivIndex = new IvIndex(0, false, Calendar.getInstance());
    @SerializedName(value="netKeys")
    @Expose
    @Ignore
    List<NetworkKey> netKeys = new ArrayList<NetworkKey>();
    @SerializedName(value="appKeys")
    @Expose
    @Ignore
    List<ApplicationKey> appKeys = new ArrayList<ApplicationKey>();
    @SerializedName(value="provisioners")
    @Expose
    @Ignore
    List<Provisioner> provisioners = new ArrayList<Provisioner>();
    @SerializedName(value="nodes")
    @Expose
    @Ignore
    List<ProvisionedMeshNode> nodes = new ArrayList<ProvisionedMeshNode>();
    @SerializedName(value="groups")
    @Expose
    @Ignore
    List<Group> groups = new ArrayList<Group>();
    @SerializedName(value="scenes")
    @Expose
    @Ignore
    List<Scene> scenes = new ArrayList<Scene>();
    @SerializedName(value="networkExclusions")
    @Expose
    @TypeConverters(value={MeshTypeConverters.class})
    @NonNull
    @ColumnInfo(name="network_exclusions", defaultValue="{}")
    protected Map<Integer, List<Integer>> networkExclusions = new HashMap<Integer, List<Integer>>();
    @Expose
    @Ignore
    @ColumnInfo(name="unicast_address")
    int unicastAddress = 1;
    @Expose
    @ColumnInfo(name="last_selected")
    boolean lastSelected;
    @Expose(serialize=false, deserialize=false)
    @Ignore
    protected SparseIntArray sequenceNumbers = new SparseIntArray();
    @Expose(serialize=false, deserialize=false)
    @Ignore
    private ProxyFilter proxyFilter;
    @Ignore
    protected final Comparator<ProvisionedMeshNode> nodeComparator = (node1, node2) -> Integer.compare(node1.getUnicastAddress(), node2.getUnicastAddress());
    @Ignore
    protected final Comparator<Group> groupComparator = (group1, group2) -> Integer.compare(group1.getAddress(), group2.getAddress());
    @Ignore
    protected final Comparator<Scene> sceneComparator = (scene1, scene2) -> Integer.compare(scene1.getNumber(), scene2.getNumber());
    @Ignore
    protected final Comparator<AllocatedUnicastRange> unicastRangeComparator = (range1, range2) -> Integer.compare(range1.getLowAddress(), range2.getLowAddress());
    @Ignore
    protected final Comparator<AllocatedGroupRange> groupRangeComparator = (range1, range2) -> Integer.compare(range1.getLowAddress(), range2.getLowAddress());
    @Ignore
    protected final Comparator<AllocatedSceneRange> sceneRangeComparator = (range1, range2) -> Integer.compare(range1.getFirstScene(), range2.getFirstScene());

    BaseMeshNetwork(@NonNull String meshUUID) {
        this.meshUUID = meshUUID;
    }

    private boolean isNetKeyExists(@NonNull byte[] key) {
        for (int i = 0; i < this.netKeys.size(); ++i) {
            if (!Arrays.equals(key, this.netKeys.get(i).getKey())) continue;
            return true;
        }
        return false;
    }

    public NetworkKey createNetworkKey() throws IllegalArgumentException {
        NetworkKey key = new NetworkKey(this.getAvailableNetKeyIndex(), MeshParserUtils.toByteArray(SecureUtils.generateRandomNetworkKey()));
        key.setMeshUuid(this.meshUUID);
        return key;
    }

    public boolean addNetKey(@NonNull NetworkKey newNetKey) {
        if (this.isNetKeyExists(newNetKey.getKey())) {
            throw new IllegalArgumentException("Net key already exists, check the contents of the key!");
        }
        newNetKey.setMeshUuid(this.meshUUID);
        this.netKeys.add(newNetKey);
        this.notifyNetKeyAdded(newNetKey);
        return true;
    }

    private int getAvailableNetKeyIndex() {
        if (this.netKeys.isEmpty()) {
            return 0;
        }
        Collections.sort(this.netKeys, this.netKeyComparator);
        int index = this.netKeys.size() - 1;
        return this.netKeys.get(index).getKeyIndex() + 1;
    }

    public boolean updateNetKey(@NonNull NetworkKey networkKey, @NonNull String newNetKey) throws IllegalArgumentException {
        if (MeshParserUtils.validateKeyInput(newNetKey)) {
            byte[] key = MeshParserUtils.toByteArray(newNetKey);
            if (this.isNetKeyExists(key)) {
                throw new IllegalArgumentException("Net key value is already in use.");
            }
            int keyIndex = networkKey.getKeyIndex();
            NetworkKey netKey = this.getNetKey(keyIndex);
            if (!this.isKeyInUse(netKey)) {
                if (netKey.equals(networkKey)) {
                    netKey.setKey(key);
                    return this.updateMeshKey(netKey);
                }
                return false;
            }
            throw new IllegalArgumentException("Unable to update a network key that's already in use. ");
        }
        return false;
    }

    public boolean updateNetKey(@NonNull NetworkKey networkKey) throws IllegalArgumentException {
        int keyIndex = networkKey.getKeyIndex();
        NetworkKey key = this.getNetKey(keyIndex);
        if (key.equals(networkKey)) {
            return this.updateMeshKey(networkKey);
        }
        if (!this.isKeyInUse(key)) {
            return this.updateMeshKey(networkKey);
        }
        throw new IllegalArgumentException("Unable to update a network key that's already in use.");
    }

    public NetworkKey distributeNetKey(@NonNull NetworkKey networkKey, @NonNull byte[] newNetKey) throws IllegalArgumentException {
        if (this.validateKey(newNetKey)) {
            if (this.isNetKeyExists(newNetKey)) {
                throw new IllegalArgumentException("Net key value is already in use.");
            }
            int keyIndex = networkKey.getKeyIndex();
            NetworkKey netKey = this.getNetKey(keyIndex);
            if (netKey.equals(networkKey) && netKey.distributeKey(newNetKey)) {
                this.updateNodeKeyStatus(netKey);
                if (this.updateMeshKey(netKey)) {
                    return netKey;
                }
            }
        }
        return null;
    }

    private void updateNodeKeyStatus(@NonNull MeshKey meshKey) {
        for (Provisioner provisioner : this.provisioners) {
            for (ProvisionedMeshNode node : this.nodes) {
                if (!node.getUuid().equalsIgnoreCase(provisioner.getProvisionerUuid())) continue;
                if (meshKey instanceof NetworkKey) {
                    for (NodeKey key : node.getAddedNetKeys()) {
                        if (key.getIndex() != meshKey.getKeyIndex()) continue;
                        key.setUpdated(true);
                    }
                    continue;
                }
                for (NodeKey key : node.getAddedAppKeys()) {
                    if (key.getIndex() != meshKey.getKeyIndex()) continue;
                    key.setUpdated(true);
                }
            }
        }
    }

    public boolean switchToNewKey(@NonNull NetworkKey networkKey) throws IllegalArgumentException {
        if (!this.netKeys.contains(networkKey)) {
            throw new IllegalArgumentException("Network Key not distributed");
        }
        return networkKey.switchToNewKey();
    }

    public boolean revokeOldKey(@NonNull NetworkKey networkKey) {
        if (this.netKeys.contains(networkKey)) {
            return networkKey.revokeOldKey();
        }
        return false;
    }

    public boolean removeNetKey(@NonNull NetworkKey networkKey) throws IllegalArgumentException {
        if (!this.isKeyInUse(networkKey)) {
            if (this.netKeys.remove(networkKey)) {
                this.notifyNetKeyDeleted(networkKey);
                return true;
            }
            throw new IllegalArgumentException("Key does not exist.");
        }
        throw new IllegalArgumentException("Unable to delete a network key that's already in use.");
    }

    public NetworkKey getNetKey(int keyIndex) {
        for (NetworkKey key : this.netKeys) {
            if (keyIndex != key.getKeyIndex()) continue;
            try {
                return key.clone();
            }
            catch (CloneNotSupportedException e) {
                Log.e((String)TAG, (String)("Error while cloning key: " + e.getMessage()));
            }
        }
        return null;
    }

    public ApplicationKey createAppKey() throws IllegalArgumentException {
        if (this.netKeys.isEmpty()) {
            throw new IllegalStateException("Cannot create an App Key without a Network key. Consider creating a network key first");
        }
        ApplicationKey key = new ApplicationKey(this.getAvailableAppKeyIndex(), MeshParserUtils.toByteArray(SecureUtils.generateRandomApplicationKey()));
        key.setMeshUuid(this.meshUUID);
        return key;
    }

    public boolean addAppKey(@NonNull ApplicationKey newAppKey) {
        if (this.netKeys.isEmpty()) {
            throw new IllegalStateException("Cannot create an App Key without a Network key. Consider creating a network key first");
        }
        if (this.isAppKeyExists(newAppKey.getKey())) {
            throw new IllegalArgumentException("App key already exists, check the contents of the key!");
        }
        newAppKey.setMeshUuid(this.meshUUID);
        this.appKeys.add(newAppKey);
        this.notifyAppKeyAdded(newAppKey);
        return true;
    }

    private int getAvailableAppKeyIndex() {
        if (this.appKeys.isEmpty()) {
            return 0;
        }
        Collections.sort(this.appKeys, this.appKeyComparator);
        int index = this.appKeys.size() - 1;
        return this.appKeys.get(index).getKeyIndex() + 1;
    }

    public ApplicationKey getAppKey(int keyIndex) {
        for (ApplicationKey key : this.appKeys) {
            if (keyIndex != key.getKeyIndex()) continue;
            try {
                return key.clone();
            }
            catch (CloneNotSupportedException e) {
                Log.e((String)TAG, (String)("Error while cloning key: " + e.getMessage()));
            }
        }
        return null;
    }

    protected List<ApplicationKey> getAppKeys(int boundNetKeyIndex) {
        ArrayList<ApplicationKey> applicationKeys = new ArrayList<ApplicationKey>();
        for (ApplicationKey applicationKey : this.appKeys) {
            if (applicationKey.getBoundNetKeyIndex() != boundNetKeyIndex) continue;
            applicationKeys.add(applicationKey);
        }
        return applicationKeys;
    }

    private boolean isAppKeyExists(@NonNull byte[] appKey) {
        for (int i = 0; i < this.appKeys.size(); ++i) {
            ApplicationKey applicationKey = this.appKeys.get(i);
            if (!Arrays.equals(applicationKey.getKey(), appKey)) continue;
            return true;
        }
        return false;
    }

    public boolean updateAppKey(@NonNull ApplicationKey applicationKey, @NonNull String newAppKey) throws IllegalArgumentException {
        if (MeshParserUtils.validateKeyInput(newAppKey)) {
            byte[] key = MeshParserUtils.toByteArray(newAppKey);
            if (this.isNetKeyExists(key)) {
                throw new IllegalArgumentException("Net key already in use");
            }
            int keyIndex = applicationKey.getKeyIndex();
            ApplicationKey appKey = this.getAppKey(keyIndex);
            if (!this.isKeyInUse(appKey)) {
                if (appKey.equals(applicationKey)) {
                    appKey.setKey(key);
                    return this.updateMeshKey(appKey);
                }
                return false;
            }
            throw new IllegalArgumentException("Unable to update a application key that's already in use.");
        }
        return false;
    }

    public boolean updateAppKey(@NonNull ApplicationKey applicationKey) throws IllegalArgumentException {
        int keyIndex = applicationKey.getKeyIndex();
        ApplicationKey key = this.getAppKey(keyIndex);
        if (!this.isKeyInUse(key)) {
            return this.updateMeshKey(applicationKey);
        }
        throw new IllegalArgumentException("Unable to update a application key that's already in use.");
    }

    public ApplicationKey distributeAppKey(@NonNull ApplicationKey applicationKey, @NonNull byte[] newAppKey) throws IllegalArgumentException {
        if (this.validateKey(newAppKey)) {
            if (this.isAppKeyExists(newAppKey)) {
                throw new IllegalArgumentException("App key value is already in use.");
            }
            int keyIndex = applicationKey.getKeyIndex();
            ApplicationKey appKey = this.getAppKey(keyIndex);
            if (appKey.equals(applicationKey) && appKey.distributeKey(newAppKey)) {
                this.updateNodeKeyStatus(appKey);
                if (this.updateMeshKey(appKey)) {
                    return appKey;
                }
            }
        }
        return null;
    }

    private boolean updateMeshKey(@NonNull MeshKey key) {
        if (key instanceof ApplicationKey) {
            ApplicationKey appKey = null;
            for (int i = 0; i < this.appKeys.size(); ++i) {
                ApplicationKey tempKey = this.appKeys.get(i);
                if (tempKey.getKeyIndex() != key.getKeyIndex()) continue;
                appKey = (ApplicationKey)key;
                this.appKeys.set(i, appKey);
                break;
            }
            if (appKey != null) {
                this.notifyAppKeyUpdated(appKey);
                return true;
            }
        } else {
            NetworkKey netKey = null;
            for (int i = 0; i < this.netKeys.size(); ++i) {
                NetworkKey tempKey = this.netKeys.get(i);
                if (tempKey.getKeyIndex() != key.getKeyIndex()) continue;
                netKey = (NetworkKey)key;
                this.netKeys.set(i, netKey);
                break;
            }
            if (netKey != null) {
                netKey.setTimestamp(System.currentTimeMillis());
                this.notifyNetKeyUpdated(netKey);
                return true;
            }
        }
        return false;
    }

    public boolean removeAppKey(@NonNull ApplicationKey appKey) throws IllegalArgumentException {
        if (this.isKeyInUse(appKey)) {
            throw new IllegalArgumentException("Unable to delete an app key that's in use.");
        }
        if (this.appKeys.remove(appKey)) {
            this.notifyAppKeyDeleted(appKey);
            return true;
        }
        throw new IllegalArgumentException("Key does not exist.");
    }

    public boolean isKeyInUse(@NonNull MeshKey meshKey) {
        if (meshKey instanceof NetworkKey) {
            for (ApplicationKey applicationKey : this.appKeys) {
                if (meshKey.getKeyIndex() != applicationKey.getBoundNetKeyIndex()) continue;
                throw new IllegalArgumentException("Please unbind " + meshKey.name + " from the " + applicationKey.name + " or delete the bound " + applicationKey.name + " first.");
            }
        }
        for (ProvisionedMeshNode node : this.nodes) {
            if (node.getUuid().equalsIgnoreCase(this.getSelectedProvisioner().getProvisionerUuid())) continue;
            int index = meshKey.getKeyIndex();
            if (meshKey instanceof ApplicationKey) {
                return MeshParserUtils.isNodeKeyExists(node.getAddedAppKeys(), index);
            }
            return MeshParserUtils.isNodeKeyExists(node.getAddedNetKeys(), index);
        }
        return false;
    }

    @Nullable
    public Integer getProvisionerAddress() {
        return this.getSelectedProvisioner().getProvisionerAddress();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getUnicastAddress() {
        return this.unicastAddress;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setUnicastAddress(int address) {
        this.unicastAddress = address;
    }

    public boolean assignUnicastAddress(int unicastAddress) throws IllegalArgumentException {
        if (this.getNode(unicastAddress) != null) {
            throw new IllegalArgumentException("Unicast address is already in use.");
        }
        this.unicastAddress = unicastAddress;
        this.notifyNetworkUpdated();
        return true;
    }

    private boolean isAddressInUse(@Nullable Integer address) {
        if (address == null) {
            return false;
        }
        for (ProvisionedMeshNode node : this.nodes) {
            if (address.intValue() != node.getUnicastAddress()) continue;
            return true;
        }
        return false;
    }

    public int getGlobalTtl() {
        return this.getSelectedProvisioner().getGlobalTtl();
    }

    public void setGlobalTtl(int globalTtl) {
        Provisioner provisioner = this.provisioners.get(0);
        provisioner.setGlobalTtl(globalTtl);
        this.notifyProvisionerUpdated(provisioner);
    }

    public List<Provisioner> getProvisioners() {
        return Collections.unmodifiableList(this.provisioners);
    }

    void setProvisioners(List<Provisioner> provisioners) {
        this.provisioners = provisioners;
    }

    public Provisioner createProvisioner(@NonNull String name) throws IllegalArgumentException {
        return this.createProvisioner(name, new AllocatedUnicastRange(1, 6554), new AllocatedGroupRange(49152, 52378), new AllocatedSceneRange(1, 13107));
    }

    public Provisioner createProvisioner(@NonNull String name, @NonNull AllocatedUnicastRange unicastRange, @NonNull AllocatedGroupRange groupRange, @NonNull AllocatedSceneRange sceneRange) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Name cannot be empty.");
        }
        ArrayList<AllocatedUnicastRange> unicastRanges = new ArrayList<AllocatedUnicastRange>();
        ArrayList<AllocatedGroupRange> groupRanges = new ArrayList<AllocatedGroupRange>();
        ArrayList<AllocatedSceneRange> sceneRanges = new ArrayList<AllocatedSceneRange>();
        unicastRanges.add(unicastRange);
        groupRanges.add(groupRange);
        sceneRanges.add(sceneRange);
        Provisioner provisioner = new Provisioner(UUID.randomUUID().toString(), unicastRanges, groupRanges, sceneRanges, this.meshUUID);
        provisioner.setProvisionerName(name);
        return provisioner;
    }

    public boolean addProvisioner(@NonNull Provisioner provisioner) throws IllegalArgumentException {
        if (provisioner.allocatedUnicastRanges.isEmpty() && provisioner.getProvisionerAddress() != null) {
            throw new IllegalArgumentException("Provisioner has no allocated unicast range assigned.");
        }
        for (Provisioner other : this.provisioners) {
            if (!provisioner.hasOverlappingUnicastRanges(other.getAllocatedUnicastRanges()) && !provisioner.hasOverlappingGroupRanges(other.getAllocatedGroupRanges()) && !provisioner.hasOverlappingSceneRanges(other.getAllocatedSceneRanges())) continue;
            throw new IllegalArgumentException("Provisioner ranges overlap.");
        }
        if (!provisioner.isAddressWithinAllocatedRange(provisioner.getProvisionerAddress())) {
            throw new IllegalArgumentException("Unicast address assigned to a provisioner must be within an allocated unicast address range.");
        }
        if (this.isAddressInUse(provisioner.getProvisionerAddress())) {
            throw new IllegalArgumentException("Unicast address is in use by another node.");
        }
        if (provisioner.isNodeAddressInUse(this.nodes)) {
            throw new IllegalArgumentException("Unicast address is already in use.");
        }
        if (this.isProvisionerUuidInUse(provisioner.getProvisionerUuid())) {
            throw new IllegalArgumentException("Provisioner uuid already in use.");
        }
        provisioner.assignProvisionerAddress(provisioner.getProvisionerAddress());
        this.provisioners.add(provisioner);
        this.notifyProvisionerAdded(provisioner);
        if (provisioner.isLastSelected()) {
            this.selectProvisioner(provisioner);
        }
        if (provisioner.getProvisionerAddress() != null) {
            ProvisionedMeshNode node = new ProvisionedMeshNode(provisioner, this.netKeys, this.appKeys);
            this.nodes.add(node);
            this.notifyNodeAdded(node);
        }
        return true;
    }

    public boolean updateProvisioner(@NonNull Provisioner provisioner) {
        if (!this.isProvisionerUuidInUse(provisioner.getProvisionerUuid())) {
            throw new IllegalArgumentException("Provisioner does not exist, consider adding a provisioner first.");
        }
        if (provisioner.allocatedUnicastRanges.isEmpty() && provisioner.getProvisionerAddress() != null) {
            throw new IllegalArgumentException("Provisioner has no allocated unicast range assigned.");
        }
        for (Provisioner other : this.provisioners) {
            if (other.getProvisionerUuid().equalsIgnoreCase(provisioner.getProvisionerUuid()) || !provisioner.hasOverlappingUnicastRanges(other.getAllocatedUnicastRanges()) && !provisioner.hasOverlappingGroupRanges(other.getAllocatedGroupRanges()) && !provisioner.hasOverlappingSceneRanges(other.getAllocatedSceneRanges())) continue;
            throw new IllegalArgumentException("Provisioner ranges overlap.");
        }
        if (!provisioner.isAddressWithinAllocatedRange(provisioner.getProvisionerAddress())) {
            throw new IllegalArgumentException("Unicast address assigned to a provisioner must be within an allocated unicast address range.");
        }
        for (ProvisionedMeshNode node : this.nodes) {
            if (node.getUuid().equalsIgnoreCase(provisioner.getProvisionerUuid()) || provisioner.getProvisionerAddress() == null || node.getUnicastAddress() != provisioner.getProvisionerAddress().intValue()) continue;
            throw new IllegalArgumentException("Unicast address is in use by another node.");
        }
        if (provisioner.isNodeAddressInUse(this.nodes)) {
            throw new IllegalArgumentException("Unicast address is already in use by another provisioner.");
        }
        boolean provisionerExists = false;
        for (int i = 0; i < this.provisioners.size(); ++i) {
            Provisioner p = this.provisioners.get(i);
            if (!p.getProvisionerUuid().equalsIgnoreCase(provisioner.getProvisionerUuid())) continue;
            this.provisioners.set(i, provisioner);
            provisionerExists = true;
        }
        boolean nodeExists = false;
        if (provisionerExists) {
            if (provisioner.getProvisionerAddress() != null) {
                ProvisionedMeshNode node = this.getNode(provisioner.getProvisionerUuid());
                if (node == null) {
                    node = new ProvisionedMeshNode(provisioner, this.netKeys, this.appKeys);
                    this.nodes.add(node);
                    this.notifyNodeAdded(node);
                } else {
                    for (int i = 0; i < this.nodes.size(); ++i) {
                        ProvisionedMeshNode meshNode = this.nodes.get(i);
                        if (!meshNode.getUuid().equalsIgnoreCase(provisioner.getProvisionerUuid())) continue;
                        int sequenceNumber = meshNode.getUnicastAddress() != provisioner.getProvisionerAddress().intValue() ? this.sequenceNumbers.get(provisioner.getProvisionerAddress().intValue()) : this.sequenceNumbers.get(node.getUnicastAddress(), node.getSequenceNumber());
                        node = new ProvisionedMeshNode(provisioner, this.netKeys, this.appKeys);
                        node.setSequenceNumber(sequenceNumber);
                        this.nodes.set(i, node);
                        this.notifyNodeUpdated(node);
                        break;
                    }
                }
            }
            if (provisioner.isLastSelected()) {
                this.selectProvisioner(provisioner);
            } else {
                this.notifyProvisionerUpdated(provisioner);
            }
            return true;
        }
        return false;
    }

    public boolean disableConfigurationCapabilities(@NonNull Provisioner provisioner) {
        ProvisionedMeshNode node = this.getNode(provisioner.getProvisionerUuid());
        if (node == null) {
            return true;
        }
        if (this.nodes.remove(node)) {
            provisioner.assignProvisionerAddress(null);
            this.notifyNodeDeleted(node);
            return true;
        }
        return false;
    }

    public boolean removeProvisioner(@NonNull Provisioner provisioner) {
        return this.removeProvisionerAndNode(this.getNode(provisioner.getProvisionerAddress()), provisioner);
    }

    public final void selectProvisioner(Provisioner provisioner) {
        provisioner.setLastSelected(true);
        for (Provisioner prov : this.provisioners) {
            if (prov.getProvisionerUuid().equalsIgnoreCase(provisioner.getProvisionerUuid())) continue;
            prov.setLastSelected(false);
        }
        this.notifyProvisionersUpdated(this.getProvisioners());
    }

    public final boolean isProvisionerSelected() {
        if (this.provisioners.size() == 1) {
            if (!this.provisioners.get(0).isLastSelected()) {
                this.selectProvisioner(this.provisioners.get(0));
            }
            return true;
        }
        for (Provisioner provisioner : this.provisioners) {
            if (!provisioner.isLastSelected()) continue;
            return true;
        }
        return false;
    }

    public Provisioner getSelectedProvisioner() {
        for (Provisioner provisioner : this.provisioners) {
            if (!provisioner.isLastSelected()) continue;
            return provisioner;
        }
        return null;
    }

    protected boolean isProvisionerUuidInUse(@NonNull String uuid) {
        for (Provisioner provisioner : this.provisioners) {
            if (!provisioner.getProvisionerUuid().equalsIgnoreCase(uuid)) continue;
            return true;
        }
        return false;
    }

    public List<ProvisionedMeshNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    void setNodes(@NonNull List<ProvisionedMeshNode> nodes) {
        this.nodes = nodes;
    }

    public List<ProvisionedMeshNode> getNodes(NetworkKey networkKey) {
        ArrayList<ProvisionedMeshNode> nodes = new ArrayList<ProvisionedMeshNode>();
        for (ProvisionedMeshNode node : this.nodes) {
            for (NodeKey nodeKey : node.getAddedNetKeys()) {
                if (nodeKey.getIndex() != networkKey.getKeyIndex()) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    public ProvisionedMeshNode getNode(@NonNull byte[] unicastAddress) {
        for (ProvisionedMeshNode node : this.nodes) {
            if (!node.hasUnicastAddress(MeshAddress.addressBytesToInt(unicastAddress))) continue;
            return node;
        }
        return null;
    }

    public ProvisionedMeshNode getNode(Integer unicastAddress) {
        if (unicastAddress == null) {
            return null;
        }
        for (ProvisionedMeshNode node : this.nodes) {
            if (!node.hasUnicastAddress(unicastAddress)) continue;
            return node;
        }
        return null;
    }

    public ProvisionedMeshNode getNode(String uuid) {
        for (ProvisionedMeshNode node : this.nodes) {
            if (!node.getUuid().equalsIgnoreCase(uuid)) continue;
            return node;
        }
        return null;
    }

    public boolean updateNodeName(@NonNull ProvisionedMeshNode node, @NonNull String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        ProvisionedMeshNode meshNode = this.getNode(node.getUuid());
        if (meshNode == null) {
            return false;
        }
        meshNode.setNodeName(name);
        this.notifyNodeUpdated(meshNode);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addNode(@NonNull ProvisionedMeshNode meshNode) {
        ProvisionedMeshNode sameAddressNode = this.getNode(meshNode.getUnicastAddress());
        if (sameAddressNode != null) {
            throw new IllegalStateException("cant add node with conflicting unicast address");
        }
        boolean hasMatchingNetKey = false;
        for (NodeKey nodeKey : meshNode.getAddedNetKeys()) {
            for (NetworkKey networkKey : this.netKeys) {
                hasMatchingNetKey = nodeKey.getIndex() == networkKey.getKeyIndex();
                if (!hasMatchingNetKey) continue;
                break;
            }
            if (!hasMatchingNetKey) continue;
            break;
        }
        if (!hasMatchingNetKey) {
            throw new IllegalStateException("Network key added to the node is not a part of the mesh network");
        }
        boolean hasMatchingAppKey = false;
        for (NodeKey nodeKey : meshNode.getAddedAppKeys()) {
            for (ApplicationKey appKey : this.appKeys) {
                hasMatchingAppKey = nodeKey.getIndex() == appKey.getKeyIndex();
                if (!hasMatchingAppKey) continue;
                break;
            }
            if (!hasMatchingAppKey) continue;
            break;
        }
        if (!hasMatchingAppKey) {
            throw new IllegalStateException("Application key added to the node is not a part of the mesh network");
        }
        boolean bl = false;
        for (ProvisionedMeshNode provisionedMeshNode : this.nodes) {
            void var5_9;
            if (provisionedMeshNode.getUuid().equalsIgnoreCase(meshNode.getUuid())) {
                this.nodes.set((int)var5_9, meshNode);
                this.notifyNodeUpdated(meshNode);
                return true;
            }
            ++var5_9;
        }
        if (this.nodes.add(meshNode)) {
            this.notifyNodeAdded(meshNode);
            return true;
        }
        return false;
    }

    public boolean deleteNode(@NonNull ProvisionedMeshNode meshNode) {
        Provisioner provisioner = null;
        for (Provisioner prov : this.provisioners) {
            if (!prov.getProvisionerUuid().equalsIgnoreCase(meshNode.getUuid())) continue;
            provisioner = prov;
            break;
        }
        return this.removeProvisionerAndNode(meshNode, provisioner);
    }

    private boolean removeProvisionerAndNode(@Nullable ProvisionedMeshNode node, @Nullable Provisioner provisioner) {
        if (provisioner != null && this.provisioners.remove(provisioner)) {
            if (node != null) {
                this.excludeNode(node);
                if (this.nodes.remove(node)) {
                    this.notifyNodeDeleted(node);
                }
            } else {
                this.notifyProvisionerDeleted(provisioner);
            }
            this.notifyNetworkUpdated();
            return true;
        }
        if (node != null && this.nodes.remove(node)) {
            this.excludeNode(node);
            if (provisioner != null) {
                if (this.provisioners.remove(provisioner)) {
                    this.notifyProvisionerDeleted(provisioner);
                }
            } else {
                this.notifyNodeDeleted(node);
            }
            this.notifyNetworkUpdated();
            return true;
        }
        return false;
    }

    public boolean isProvisioner(@NonNull ProvisionedMeshNode node) {
        for (Provisioner provisioner : this.provisioners) {
            if (!provisioner.getProvisionerUuid().equalsIgnoreCase(node.getUuid())) continue;
            return true;
        }
        return false;
    }

    public boolean updateElementName(@NonNull Element element, @NonNull String name) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Element name cannot be empty.");
        }
        ProvisionedMeshNode node = this.getNode(element.getElementAddress());
        if (node != null && node.getElements().containsKey(element.getElementAddress())) {
            element.setName(name);
            node.getElements().put(element.getElementAddress(), element);
            this.notifyNodeUpdated(node);
            return true;
        }
        return false;
    }

    public boolean updateElementName(int address, @NonNull String name) throws IllegalArgumentException {
        Element element;
        if (TextUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Element name cannot be empty.");
        }
        ProvisionedMeshNode node = this.getNode(address);
        if (node != null && (element = node.getElements().get(address)) != null) {
            element.setName(name);
            this.notifyNodeUpdated(node);
            return true;
        }
        return false;
    }

    public SparseIntArray getSequenceNumbers() {
        return this.sequenceNumbers.clone();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setSequenceNumbers(@NonNull SparseIntArray sequenceNumbers) {
        this.sequenceNumbers = sequenceNumbers;
    }

    protected Integer getSequenceNumber(int address) {
        return this.sequenceNumbers.get(address, 0);
    }

    protected void loadSequenceNumbers() {
        for (ProvisionedMeshNode node : this.nodes) {
            this.sequenceNumbers.put(node.getUnicastAddress(), node.getSequenceNumber());
        }
    }

    public Map<Integer, List<Integer>> getNetworkExclusions() {
        HashMap<Integer, List<Integer>> networkExclusions = new HashMap<Integer, List<Integer>>();
        for (Map.Entry<Integer, List<Integer>> entry : this.networkExclusions.entrySet()) {
            networkExclusions.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(networkExclusions);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setNetworkExclusions(@NonNull Map<Integer, List<Integer>> networkExclusions) {
        this.networkExclusions = networkExclusions;
    }

    @Nullable
    public ProxyFilter getProxyFilter() {
        return this.proxyFilter;
    }

    public void setProxyFilter(@Nullable ProxyFilter proxyFilter) {
        this.proxyFilter = proxyFilter;
    }

    private void excludeNode(@NonNull ProvisionedMeshNode node) {
        List<Integer> addresses = this.networkExclusions.get(this.ivIndex.getIvIndex());
        if (addresses == null) {
            addresses = new ArrayList<Integer>();
        }
        for (Integer address : node.getElements().keySet()) {
            if (addresses.contains(address)) continue;
            addresses.add(address);
        }
        this.networkExclusions.put(this.ivIndex.getIvIndex(), addresses);
    }

    private boolean validateKey(@NonNull byte[] key) {
        if (key.length != 16) {
            throw new IllegalArgumentException("Key must be 16 bytes");
        }
        return true;
    }

    final void notifyNetworkUpdated() {
        if (this.mCallbacks != null) {
            this.mCallbacks.onMeshNetworkUpdated();
        }
    }

    final void notifyNetKeyAdded(@NonNull NetworkKey networkKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNetworkKeyAdded(networkKey);
        }
    }

    final void notifyNetKeyUpdated(@NonNull NetworkKey networkKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNetworkKeyUpdated(networkKey);
        }
    }

    final void notifyNetKeyDeleted(@NonNull NetworkKey networkKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNetworkKeyDeleted(networkKey);
        }
    }

    final void notifyAppKeyAdded(@NonNull ApplicationKey appKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onApplicationKeyAdded(appKey);
        }
    }

    final void notifyAppKeyUpdated(@NonNull ApplicationKey appKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onApplicationKeyUpdated(appKey);
        }
    }

    final void notifyAppKeyDeleted(@NonNull ApplicationKey appKey) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onApplicationKeyDeleted(appKey);
        }
    }

    final void notifyProvisionerAdded(@NonNull Provisioner provisioner) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onProvisionerAdded(provisioner);
        }
    }

    final void notifyProvisionerUpdated(@NonNull Provisioner provisioner) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onProvisionerUpdated(provisioner);
        }
    }

    final void notifyProvisionersUpdated(@NonNull List<Provisioner> provisioner) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onProvisionersUpdated(provisioner);
        }
    }

    final void notifyProvisionerDeleted(@NonNull Provisioner provisioner) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onProvisionerDeleted(provisioner);
        }
    }

    final void notifyNodeAdded(@NonNull ProvisionedMeshNode node) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNodeAdded(node);
        }
    }

    final void notifyNodeUpdated(@NonNull ProvisionedMeshNode node) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNodeUpdated(node);
        }
    }

    final void notifyNodeDeleted(@NonNull ProvisionedMeshNode meshNode) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onNodeDeleted(meshNode);
        }
    }

    final void notifySceneAdded(@NonNull Scene scene) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onSceneAdded(scene);
        }
    }

    final void notifySceneUpdated(@NonNull Scene scene) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onSceneUpdated(scene);
        }
    }

    final void notifySceneDeleted(@NonNull Scene scene) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onSceneDeleted(scene);
        }
    }

    final void notifyGroupAdded(@NonNull Group group) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onGroupAdded(group);
        }
    }

    final void notifyGroupUpdated(@NonNull Group group) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onGroupUpdated(group);
        }
    }

    final void notifyGroupDeleted(@NonNull Group group) {
        if (this.mCallbacks != null) {
            this.mCallbacks.onGroupDeleted(group);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IvUpdateStates {
    }
}

