/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import no.nordicsemi.android.mesh.utils.AlgorithmType;
import no.nordicsemi.android.mesh.utils.AuthenticationOOBMethods;
import no.nordicsemi.android.mesh.utils.InputOOBAction;
import no.nordicsemi.android.mesh.utils.OutputOOBAction;

public final class ProvisioningCapabilities
implements Parcelable {
    private static final int PUBLIC_KEY_INFORMATION_AVAILABLE = 1;
    private static final int STATIC_OOB_INFO_AVAILABLE = 1;
    private static final String TAG = ProvisioningCapabilities.class.getSimpleName();
    private byte numberOfElements;
    private short rawAlgorithm;
    private final List<AlgorithmType> supportedAlgorithmTypes;
    private byte rawPublicKeyType;
    private final boolean publicKeyInformationAvailable;
    private byte rawStaticOOBType;
    private final boolean staticOOBInformationAvailable;
    private byte outputOOBSize;
    private short rawOutputOOBAction;
    private final List<OutputOOBAction> supportedOutputOOBActions;
    private byte inputOOBSize;
    private short rawInputOOBAction;
    private final List<InputOOBAction> supportedInputOOBActions;
    private AuthenticationOOBMethods supportedOOBMethods;
    private final List<AuthenticationOOBMethods> availableOOBTypes = new ArrayList<AuthenticationOOBMethods>();
    public static final Parcelable.Creator<ProvisioningCapabilities> CREATOR = new Parcelable.Creator<ProvisioningCapabilities>(){

        public ProvisioningCapabilities createFromParcel(Parcel in) {
            return new ProvisioningCapabilities(in);
        }

        public ProvisioningCapabilities[] newArray(int size) {
            return new ProvisioningCapabilities[size];
        }
    };

    ProvisioningCapabilities(@NonNull byte[] capabilities) {
        ArrayList<InputOOBAction> arrayList;
        short inputOOBAction;
        byte inputOOBSize;
        ArrayList<OutputOOBAction> arrayList2;
        short outputOOBAction;
        byte outputOOBSize;
        short algorithm;
        byte numberOfElements;
        if (capabilities[2] == 0) {
            throw new IllegalArgumentException("Number of elements cannot be zero");
        }
        this.numberOfElements = numberOfElements = capabilities[2];
        Log.v((String)TAG, (String)("Number of elements: " + numberOfElements));
        this.rawAlgorithm = algorithm = (short)((capabilities[3] & 0xFF) << 8 | capabilities[4] & 0xFF);
        this.supportedAlgorithmTypes = AlgorithmType.getAlgorithmTypeFromBitMask(algorithm);
        this.rawPublicKeyType = capabilities[5];
        this.publicKeyInformationAvailable = this.rawPublicKeyType == 1;
        Log.v((String)TAG, (String)("Public key information available: " + this.publicKeyInformationAvailable));
        this.rawStaticOOBType = capabilities[6];
        this.staticOOBInformationAvailable = this.rawStaticOOBType == 1;
        Log.v((String)TAG, (String)("Static OOB information available: : " + this.staticOOBInformationAvailable));
        this.outputOOBSize = outputOOBSize = capabilities[7];
        Log.v((String)TAG, (String)("Output OOB size: " + outputOOBSize));
        this.rawOutputOOBAction = outputOOBAction = (short)((capabilities[8] & 0xFF) << 8 | capabilities[9] & 0xFF);
        if (outputOOBSize == 0) {
            ArrayList<OutputOOBAction> arrayList3;
            arrayList2 = arrayList3;
        } else {
            arrayList2 = OutputOOBAction.parseOutputActionsFromBitMask(outputOOBAction);
        }
        this.supportedOutputOOBActions = arrayList2;
        this.inputOOBSize = inputOOBSize = capabilities[10];
        Log.v((String)TAG, (String)("Input OOB size: " + inputOOBSize));
        this.rawInputOOBAction = inputOOBAction = (short)((capabilities[11] & 0xFF) << 8 | capabilities[12] & 0xFF);
        if (inputOOBSize == 0) {
            ArrayList<InputOOBAction> arrayList4;
            arrayList = arrayList4;
            super();
        } else {
            arrayList = InputOOBAction.parseInputActionsFromBitMask(inputOOBAction);
        }
        this.supportedInputOOBActions = arrayList;
        this.generateAvailableOOBTypes();
    }

    private void generateAvailableOOBTypes() {
        this.availableOOBTypes.clear();
        this.availableOOBTypes.add(AuthenticationOOBMethods.NO_OOB_AUTHENTICATION);
        if (this.isStaticOOBInformationAvailable()) {
            this.availableOOBTypes.add(AuthenticationOOBMethods.STATIC_OOB_AUTHENTICATION);
        }
        if (!this.supportedOutputOOBActions.isEmpty()) {
            this.availableOOBTypes.add(AuthenticationOOBMethods.OUTPUT_OOB_AUTHENTICATION);
        }
        if (!this.supportedInputOOBActions.isEmpty()) {
            this.availableOOBTypes.add(AuthenticationOOBMethods.INPUT_OOB_AUTHENTICATION);
        }
    }

    private ProvisioningCapabilities(Parcel in) {
        this.numberOfElements = in.readByte();
        this.rawAlgorithm = (short)in.readInt();
        this.supportedAlgorithmTypes = AlgorithmType.getAlgorithmTypeFromBitMask(this.rawAlgorithm);
        this.rawPublicKeyType = in.readByte();
        this.publicKeyInformationAvailable = in.readByte() != 0;
        this.rawStaticOOBType = in.readByte();
        this.staticOOBInformationAvailable = in.readByte() != 0;
        this.outputOOBSize = in.readByte();
        this.rawOutputOOBAction = (short)in.readInt();
        this.supportedOutputOOBActions = new ArrayList<OutputOOBAction>(OutputOOBAction.parseOutputActionsFromBitMask(this.rawOutputOOBAction));
        this.inputOOBSize = in.readByte();
        this.rawInputOOBAction = (short)in.readInt();
        this.supportedInputOOBActions = new ArrayList<InputOOBAction>(InputOOBAction.parseInputActionsFromBitMask(this.rawInputOOBAction));
        this.generateAvailableOOBTypes();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.numberOfElements);
        dest.writeInt((int)this.rawAlgorithm);
        dest.writeByte(this.rawPublicKeyType);
        dest.writeByte((byte)(this.publicKeyInformationAvailable ? 1 : 0));
        dest.writeByte(this.rawStaticOOBType);
        dest.writeByte((byte)(this.staticOOBInformationAvailable ? 1 : 0));
        dest.writeByte(this.outputOOBSize);
        dest.writeInt((int)this.rawOutputOOBAction);
        dest.writeByte(this.inputOOBSize);
        dest.writeInt((int)this.rawInputOOBAction);
    }

    public int describeContents() {
        return 0;
    }

    public byte getNumberOfElements() {
        return this.numberOfElements;
    }

    void setNumberOfElements(byte numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public short getRawAlgorithm() {
        return this.rawAlgorithm;
    }

    void setRawAlgorithm(short algorithm) {
        this.rawAlgorithm = algorithm;
    }

    public List<AlgorithmType> getSupportedAlgorithmTypes() {
        return Collections.unmodifiableList(this.supportedAlgorithmTypes);
    }

    public byte getRawPublicKeyType() {
        return this.rawPublicKeyType;
    }

    void setRawPublicKeyType(byte rawPublicKeyType) {
        this.rawPublicKeyType = rawPublicKeyType;
    }

    public boolean isPublicKeyInformationAvailable() {
        return this.publicKeyInformationAvailable;
    }

    public byte getRawStaticOOBType() {
        return this.rawStaticOOBType;
    }

    void setRawStaticOOBType(byte rawStaticOOBType) {
        this.rawStaticOOBType = rawStaticOOBType;
    }

    public boolean isStaticOOBInformationAvailable() {
        return this.staticOOBInformationAvailable;
    }

    public byte getOutputOOBSize() {
        return this.outputOOBSize;
    }

    void setOutputOOBSize(byte outputOOBSize) {
        this.outputOOBSize = outputOOBSize;
    }

    public short getRawOutputOOBAction() {
        return this.rawOutputOOBAction;
    }

    void setRawOutputOOBAction(short rawOutputOOBAction) {
        this.rawOutputOOBAction = rawOutputOOBAction;
    }

    public List<OutputOOBAction> getSupportedOutputOOBActions() {
        return Collections.unmodifiableList(this.supportedOutputOOBActions);
    }

    public byte getInputOOBSize() {
        return this.inputOOBSize;
    }

    void setInputOOBSize(byte inputOOBSize) {
        this.inputOOBSize = inputOOBSize;
    }

    public short getRawInputOOBAction() {
        return this.rawInputOOBAction;
    }

    void setRawInputOOBAction(short rawInputOOBAction) {
        this.rawInputOOBAction = rawInputOOBAction;
    }

    public List<InputOOBAction> getSupportedInputOOBActions() {
        return Collections.unmodifiableList(this.supportedInputOOBActions);
    }

    public List<AuthenticationOOBMethods> getAvailableOOBTypes() {
        return Collections.unmodifiableList(this.availableOOBTypes);
    }
}

