/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import no.nordicsemi.android.mesh.R;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;

public class ProvisioningFailedState
extends ProvisioningState {
    private int error;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProvisioningFailedState() {
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_FAILED;
    }

    @Override
    public void executeSend() {
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        this.error = data[2];
        return true;
    }

    public int getErrorCode() {
        return this.error;
    }

    public static String parseProvisioningFailure(Context context, int errorCode) {
        switch (ProvisioningFailureCode.fromErrorCode(errorCode)) {
            case PROHIBITED: {
                return context.getString(R.string.error_prohibited);
            }
            case INVALID_PDU: {
                return context.getString(R.string.error_invalid_pdu);
            }
            case INVALID_FORMAT: {
                return context.getString(R.string.error_invalid_format);
            }
            case UNEXPECTED_PDU: {
                return context.getString(R.string.error_prohibited);
            }
            case CONFIRMATION_FAILED: {
                return context.getString(R.string.error_confirmation_failed);
            }
            case OUT_OF_RESOURCES: {
                return context.getString(R.string.error_prohibited);
            }
            case DECRYPTION_FAILED: {
                return context.getString(R.string.error_decryption_failed);
            }
            case UNEXPECTED_ERROR: {
                return context.getString(R.string.error_unexpected_error);
            }
            case CANNOT_ASSIGN_ADDRESSES: {
                return context.getString(R.string.error_cannot_assign_addresses);
            }
        }
        return context.getString(R.string.error_rfu);
    }

    public static enum ProvisioningFailureCode {
        PROHIBITED(0),
        INVALID_PDU(1),
        INVALID_FORMAT(2),
        UNEXPECTED_PDU(3),
        CONFIRMATION_FAILED(4),
        OUT_OF_RESOURCES(5),
        DECRYPTION_FAILED(6),
        UNEXPECTED_ERROR(7),
        CANNOT_ASSIGN_ADDRESSES(8),
        UNKNOWN_ERROR_CODE(9);

        private final int errorCode;

        private ProvisioningFailureCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public static ProvisioningFailureCode fromErrorCode(int errorCode) {
            for (ProvisioningFailureCode failureCode : ProvisioningFailureCode.values()) {
                if (failureCode.getErrorCode() != errorCode) continue;
                return failureCode;
            }
            return UNKNOWN_ERROR_CODE;
        }

        public final int getErrorCode() {
            return this.errorCode;
        }
    }
}

