/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import no.nordicsemi.android.mesh.sensorutils.DevicePropertyCharacteristic;

public class Pressure
extends DevicePropertyCharacteristic<Float> {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Pressure(@NonNull byte[] data, int offset) {
        super(data, offset);
        this.value = Float.valueOf((float)ByteBuffer.wrap(Arrays.copyOfRange(data, offset, offset + this.getLength())).order(ByteOrder.LITTLE_ENDIAN).getInt() / 10.0f);
    }

    public Pressure(Float pressure) {
        this.value = pressure;
    }

    @NonNull
    public String toString() {
        return this.value + " Pa";
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public byte[] getBytes() {
        return ByteBuffer.allocate(this.getLength()).order(ByteOrder.LITTLE_ENDIAN).putInt(((Float)this.value).intValue()).array();
    }
}

