/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.BitReader;

public class GenericPropertyStatus
extends ApplicationStatusMessage
implements Parcelable {
    private final int opCode;
    private short propertyId;
    private byte userAccess;
    private byte[] propertyValue;
    private static final Parcelable.Creator<GenericPropertyStatus> CREATOR = new Parcelable.Creator<GenericPropertyStatus>(){

        public GenericPropertyStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new GenericPropertyStatus(message);
        }

        public GenericPropertyStatus[] newArray(int size) {
            return new GenericPropertyStatus[size];
        }
    };

    public GenericPropertyStatus(@NonNull AccessMessage message) {
        super(message);
        this.opCode = message.getOpCode();
        this.mMessage = message;
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        BitReader bitReader = new BitReader(this.mParameters);
        int firstPropertyByte = bitReader.getBits(8);
        int secondPropertyByte = bitReader.getBits(8);
        this.propertyId = (short)(secondPropertyByte << 8 | firstPropertyByte);
        this.userAccess = (byte)bitReader.getBits(8);
        this.propertyValue = bitReader.getRemainingBytes();
    }

    @Override
    public int getOpCode() {
        return this.opCode;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    public short getPropertyId() {
        return this.propertyId;
    }

    public byte getUserAccess() {
        return this.userAccess;
    }

    public byte[] getPropertyValue() {
        return this.propertyValue;
    }
}

