/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import java.nio.ByteBuffer;
import no.nordicsemi.android.mesh.utils.BitReader;

public class GenericTransitionTime {
    public static final int TRANSITION_TIME_BITS_LENGTH = 8;
    public final TransitionResolution resolution;
    public final TransitionStep transitionStep;

    public GenericTransitionTime(TransitionResolution transitionResolution, TransitionStep transitionSteps) {
        this.resolution = transitionResolution;
        this.transitionStep = transitionSteps;
    }

    public GenericTransitionTime(int value) {
        byte[] bytes = ByteBuffer.allocate(8).putInt(value).array();
        BitReader bitReader = new BitReader(bytes);
        this.resolution = TransitionResolution.fromValue(bitReader.getBits(2));
        this.transitionStep = TransitionStep.Specific(bitReader.getBits(6));
    }

    public int getValue() {
        return this.resolution.value << 6 | this.transitionStep.value;
    }

    public static enum TransitionResolution {
        HUNDRED_MILLISECONDS(0),
        SECOND(1),
        TEN_SECONDS(2),
        TEN_MINUTES(3);

        public static final int TRANSITION_STEP_RESOLUTION_BITS_LENGTH = 2;
        public int value;

        public static TransitionResolution fromValue(int value) {
            for (TransitionResolution resolution : TransitionResolution.values()) {
                if (resolution.value != value) continue;
                return resolution;
            }
            return SECOND;
        }

        private TransitionResolution(int value) {
            this.value = value;
        }
    }

    public static final class TransitionStep {
        public static final int TRANSITION_NUMBER_STEP_BITS_LENGTH = 6;
        public final int value;
        public static TransitionStep Immediate = new TransitionStep(0);
        public static TransitionStep Unknown = new TransitionStep(63);

        public static TransitionStep Specific(int numberOfSteps) {
            return new TransitionStep(numberOfSteps);
        }

        TransitionStep(int value) {
            this.value = value;
        }
    }
}

