/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import androidx.annotation.NonNull;

public final class TimeZoneOffset {
    private final byte encodedValue;

    private TimeZoneOffset(byte encodedValue) {
        this.encodedValue = encodedValue;
    }

    @NonNull
    public static TimeZoneOffset of(byte encodedValue) {
        return new TimeZoneOffset(encodedValue);
    }

    @NonNull
    public static TimeZoneOffset encode(double hours) {
        return new TimeZoneOffset((byte)Math.max(0L, Math.min(255L, Math.round(hours * 4.0 + 64.0))));
    }

    public byte getEncodedValue() {
        return this.encodedValue;
    }

    public double getHours() {
        return ((double)(this.encodedValue & 0xFF) - 64.0) / 4.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneOffset that = (TimeZoneOffset)o;
        return this.encodedValue == that.encodedValue;
    }

    public int hashCode() {
        return Byte.valueOf(this.encodedValue).hashCode();
    }

    @NonNull
    public String toString() {
        return "TimeZoneOffset{encodedValue=" + this.encodedValue + " hours=" + this.getHours() + '}';
    }
}

