/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningCapabilities;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningInviteState;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;

public class ProvisioningCapabilitiesState
extends ProvisioningState {
    private static final String TAG = ProvisioningInviteState.class.getSimpleName();
    private final UnprovisionedMeshNode node;
    private final MeshProvisioningStatusCallbacks mCallbacks;
    private ProvisioningCapabilities capabilities;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProvisioningCapabilitiesState(UnprovisionedMeshNode node, MeshProvisioningStatusCallbacks callbacks) {
        this.mCallbacks = callbacks;
        this.node = node;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_CAPABILITIES;
    }

    public ProvisioningCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void executeSend() {
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        boolean flag = this.parseProvisioningCapabilities(data);
        this.node.setProvisioningCapabilitiesPdu(data);
        this.node.setProvisioningCapabilities(this.capabilities);
        this.mCallbacks.onProvisioningStateChanged(this.node, ProvisioningState.States.PROVISIONING_CAPABILITIES, data);
        return flag;
    }

    private boolean parseProvisioningCapabilities(byte[] provisioningCapabilities) {
        this.capabilities = new ProvisioningCapabilities(provisioningCapabilities);
        return true;
    }
}

