/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import androidx.annotation.NonNull;

public abstract class ProvisioningState {
    static final byte TYPE_PROVISIONING_INVITE = 0;
    static final byte TYPE_PROVISIONING_CAPABILITIES = 1;
    static final byte TYPE_PROVISIONING_START = 2;
    static final byte TYPE_PROVISIONING_PUBLIC_KEY = 3;
    static final byte TYPE_PROVISIONING_INPUT_COMPLETE = 4;
    static final byte TYPE_PROVISIONING_CONFIRMATION = 5;
    static final byte TYPE_PROVISIONING_RANDOM_CONFIRMATION = 6;
    static final byte TYPE_PROVISIONING_DATA = 7;
    static final byte TYPE_PROVISIONING_COMPLETE = 8;

    public abstract State getState();

    public abstract void executeSend();

    public abstract boolean parseData(@NonNull byte[] var1);

    public static enum States {
        PROVISIONING_INVITE(0),
        PROVISIONING_CAPABILITIES(1),
        PROVISIONING_START(2),
        PROVISIONING_PUBLIC_KEY_SENT(3),
        PROVISIONING_PUBLIC_KEY_RECEIVED(4),
        PROVISIONING_AUTHENTICATION_INPUT_OOB_WAITING(5),
        PROVISIONING_AUTHENTICATION_OUTPUT_OOB_WAITING(6),
        PROVISIONING_AUTHENTICATION_STATIC_OOB_WAITING(7),
        PROVISIONING_AUTHENTICATION_INPUT_ENTERED(8),
        PROVISIONING_INPUT_COMPLETE(9),
        PROVISIONING_CONFIRMATION_SENT(10),
        PROVISIONING_CONFIRMATION_RECEIVED(11),
        PROVISIONING_RANDOM_SENT(12),
        PROVISIONING_RANDOM_RECEIVED(13),
        PROVISIONING_DATA_SENT(14),
        PROVISIONING_COMPLETE(15),
        PROVISIONING_FAILED(16),
        COMPOSITION_DATA_GET_SENT(17),
        COMPOSITION_DATA_STATUS_RECEIVED(18),
        SENDING_DEFAULT_TTL_GET(19),
        DEFAULT_TTL_STATUS_RECEIVED(20),
        SENDING_APP_KEY_ADD(21),
        APP_KEY_STATUS_RECEIVED(22),
        SENDING_NETWORK_TRANSMIT_SET(23),
        NETWORK_TRANSMIT_STATUS_RECEIVED(24),
        SENDING_BLOCK_ACKNOWLEDGEMENT(98),
        BLOCK_ACKNOWLEDGEMENT_RECEIVED(99);

        private int state;

        private States(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }

        public static States fromStatusCode(int statusCode) {
            for (States state : States.values()) {
                if (state.getState() != statusCode) continue;
                return state;
            }
            throw new IllegalStateException("Invalid state");
        }
    }

    public static enum State {
        PROVISIONING_INVITE(0),
        PROVISIONING_CAPABILITIES(1),
        PROVISIONING_START(2),
        PROVISIONING_PUBLIC_KEY(3),
        PROVISIONING_INPUT_COMPLETE(4),
        PROVISIONING_CONFIRMATION(5),
        PROVISIONING_RANDOM(6),
        PROVISIONING_DATA(7),
        PROVISIONING_COMPLETE(8),
        PROVISIONING_FAILED(9);

        private final int state;

        private State(int state) {
            this.state = state;
        }

        public int getState() {
            return this.state;
        }
    }
}

