/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.transport.ConfigMessage;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;

public class ConfigAppKeyDelete
extends ConfigMessage {
    private static final String TAG = ConfigAppKeyDelete.class.getSimpleName();
    private static final int OP_CODE = 32768;
    private final NetworkKey mNetKey;
    private final ApplicationKey mAppKey;

    public ConfigAppKeyDelete(@NonNull NetworkKey networkKey, @NonNull ApplicationKey appKey) throws IllegalArgumentException {
        if (networkKey.getKey().length != 16) {
            throw new IllegalArgumentException("Network key must be 16 bytes");
        }
        if (appKey.getKey().length != 16) {
            throw new IllegalArgumentException("App key must be 16 bytes");
        }
        this.mNetKey = networkKey;
        this.mAppKey = appKey;
        this.assembleMessageParameters();
    }

    public NetworkKey getNetKey() {
        return this.mNetKey;
    }

    public ApplicationKey getAppKey() {
        return this.mAppKey;
    }

    @Override
    public int getOpCode() {
        return 32768;
    }

    @Override
    void assembleMessageParameters() {
        Log.v((String)TAG, (String)("NetKeyIndex: " + this.mNetKey.getKeyIndex()));
        Log.v((String)TAG, (String)("AppKeyIndex: " + this.mAppKey.getKeyIndex()));
        byte[] netKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mNetKey.getKeyIndex());
        byte[] appKeyIndex = MeshParserUtils.addKeyIndexPadding(this.mAppKey.getKeyIndex());
        ByteBuffer paramsBuffer = ByteBuffer.allocate(3).order(ByteOrder.LITTLE_ENDIAN);
        paramsBuffer.put(netKeyIndex[1]);
        paramsBuffer.put((byte)((appKeyIndex[1] & 0xFF) << 4 | netKeyIndex[0] & 0xFF & 0xF));
        paramsBuffer.put((byte)((appKeyIndex[0] & 0xFF) << 4 | (appKeyIndex[1] & 0xFF) >> 4));
        this.mParameters = paramsBuffer.array();
    }
}

