/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class GenericAdminPropertySet
extends ApplicationMessage {
    private static final int PROPERTY_SET_PARAMS_LENGTH = 3;
    private final short propertyId;
    private final byte userAccess;
    final byte[] values;

    public GenericAdminPropertySet(@NonNull ApplicationKey appKey, short propertyId, byte userAccess, byte[] values) {
        super(appKey);
        this.propertyId = propertyId;
        this.userAccess = userAccess;
        this.values = values;
        this.assembleMessageParameters();
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        this.mParameters = ByteBuffer.allocate(3 + this.values.length).order(ByteOrder.LITTLE_ENDIAN).putShort(this.propertyId).put(this.userAccess).put(this.values).array();
    }

    @Override
    public int getOpCode() {
        return 72;
    }
}

