/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.util.Log;
import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.data.GlobalAltitude;
import no.nordicsemi.android.mesh.data.GlobalLatitude;
import no.nordicsemi.android.mesh.data.GlobalLongitude;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public final class GenericLocationGlobalSet
extends ApplicationMessage {
    private static final String TAG = GenericLocationGlobalSet.class.getSimpleName();
    private static final int OP_CODE = 65;
    private static final int GENERIC_LOCATION_GLOBAL_SET_LENGTH = 10;
    private GlobalLatitude latitude;
    private GlobalLongitude longitude;
    private GlobalAltitude altitude;

    public GenericLocationGlobalSet(@NonNull ApplicationKey appKey, @NonNull GlobalLatitude latitude, @NonNull GlobalLongitude longitude, @NonNull GlobalAltitude altitude) {
        super(appKey);
        this.latitude = latitude;
        this.longitude = longitude;
        this.altitude = altitude;
        this.assembleMessageParameters();
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        ByteBuffer buffer = ByteBuffer.allocate(10).order(ByteOrder.LITTLE_ENDIAN);
        Log.v((String)TAG, (String)"Creating message");
        Log.v((String)TAG, (String)this.latitude.toString());
        Log.v((String)TAG, (String)this.longitude.toString());
        Log.v((String)TAG, (String)this.altitude.toString());
        buffer.putInt(this.latitude.getEncodedValue());
        buffer.putInt(this.longitude.getEncodedValue());
        buffer.putShort(this.altitude.getEncodedValue());
        this.mParameters = buffer.array();
    }

    @Override
    public int getOpCode() {
        return 65;
    }

    @NonNull
    public GlobalLatitude getLatitude() {
        return this.latitude;
    }

    @NonNull
    public GlobalLongitude getLongitude() {
        return this.longitude;
    }

    @NonNull
    public GlobalAltitude getAltitude() {
        return this.altitude;
    }
}

