/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import androidx.room.Ignore;
import androidx.room.Index;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.Features;
import no.nordicsemi.android.mesh.MeshNetwork;
import no.nordicsemi.android.mesh.NetworkKey;
import no.nordicsemi.android.mesh.NodeKey;
import no.nordicsemi.android.mesh.Provisioner;
import no.nordicsemi.android.mesh.models.ConfigurationServerModel;
import no.nordicsemi.android.mesh.models.SigModel;
import no.nordicsemi.android.mesh.models.SigModelParser;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;
import no.nordicsemi.android.mesh.transport.ConfigCompositionDataStatus;
import no.nordicsemi.android.mesh.transport.ConfigModelAppStatus;
import no.nordicsemi.android.mesh.transport.Element;
import no.nordicsemi.android.mesh.transport.MeshModel;
import no.nordicsemi.android.mesh.transport.ProvisionedBaseMeshNode;
import no.nordicsemi.android.mesh.utils.MeshParserUtils;
import no.nordicsemi.android.mesh.utils.NetworkTransmitSettings;
import no.nordicsemi.android.mesh.utils.RelaySettings;
import no.nordicsemi.android.mesh.utils.SecureUtils;
import no.nordicsemi.android.mesh.utils.SparseIntArrayParcelable;

@Entity(tableName="nodes", foreignKeys={@ForeignKey(entity=MeshNetwork.class, parentColumns={"mesh_uuid"}, childColumns={"mesh_uuid"}, onUpdate=5, onDelete=5)}, indices={@Index(value={"mesh_uuid"})})
public final class ProvisionedMeshNode
extends ProvisionedBaseMeshNode {
    public static final Parcelable.Creator<ProvisionedMeshNode> CREATOR = new Parcelable.Creator<ProvisionedMeshNode>(){

        public ProvisionedMeshNode createFromParcel(Parcel in) {
            return new ProvisionedMeshNode(in);
        }

        public ProvisionedMeshNode[] newArray(int size) {
            return new ProvisionedMeshNode[size];
        }
    };

    @VisibleForTesting(otherwise=4)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProvisionedMeshNode() {
    }

    @Ignore
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProvisionedMeshNode(UnprovisionedMeshNode node) {
        this.uuid = node.getDeviceUuid().toString();
        this.nodeName = node.getNodeName();
        this.mAddedNetKeys.add(new NodeKey(node.getKeyIndex()));
        this.mFlags = node.getFlags();
        this.unicastAddress = node.getUnicastAddress();
        this.deviceKey = node.getDeviceKey();
        this.ttl = node.getTtl();
        this.mTimeStampInMillis = node.getTimeStamp();
        for (int i = 0; i < node.getProvisioningCapabilities().getNumberOfElements(); ++i) {
            this.mElements.put(this.unicastAddress + i, new Element(this.unicastAddress + i, 0, new HashMap<Integer, MeshModel>()));
        }
    }

    @Ignore
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @SuppressLint(value={"UseSparseArrays"})
    public ProvisionedMeshNode(@NonNull Provisioner provisioner, @NonNull List<NetworkKey> netKeys, @NonNull List<ApplicationKey> appKeys) {
        this.meshUuid = provisioner.getMeshUuid();
        this.uuid = provisioner.getProvisionerUuid();
        this.nodeName = provisioner.getProvisionerName();
        for (NetworkKey networkKey : netKeys) {
            this.mAddedNetKeys.add(new NodeKey(networkKey.getKeyIndex(), false));
        }
        for (ApplicationKey applicationKey : appKeys) {
            this.mAddedAppKeys.add(new NodeKey(applicationKey.getKeyIndex(), false));
        }
        if (provisioner.getProvisionerAddress() != null) {
            this.unicastAddress = provisioner.getProvisionerAddress();
        }
        this.sequenceNumber = 0;
        this.deviceKey = SecureUtils.generateRandomNumber();
        this.ttl = provisioner.getGlobalTtl();
        this.mTimeStampInMillis = System.currentTimeMillis();
        SigModel model = SigModelParser.getSigModel(1);
        HashMap<Integer, MeshModel> hashMap = new HashMap<Integer, MeshModel>();
        hashMap.put(((MeshModel)model).getModelId(), model);
        Element element = new Element(this.unicastAddress, 0, hashMap);
        HashMap<Integer, Element> elements = new HashMap<Integer, Element>();
        elements.put(this.unicastAddress, element);
        this.mElements = elements;
        this.nodeFeatures = new Features(2, 2, 2, 2);
    }

    @Ignore
    protected ProvisionedMeshNode(Parcel in) {
        this.uuid = in.readString();
        this.isConfigured = in.readByte() != 1;
        this.nodeName = in.readString();
        in.readList(this.mAddedNetKeys, NodeKey.class.getClassLoader());
        this.mFlags = in.createByteArray();
        this.unicastAddress = in.readInt();
        this.deviceKey = in.createByteArray();
        this.ttl = (Integer)in.readValue(Integer.class.getClassLoader());
        this.sequenceNumber = in.readInt();
        this.companyIdentifier = (Integer)in.readValue(Integer.class.getClassLoader());
        this.productIdentifier = (Integer)in.readValue(Integer.class.getClassLoader());
        this.versionIdentifier = (Integer)in.readValue(Integer.class.getClassLoader());
        this.crpl = (Integer)in.readValue(Integer.class.getClassLoader());
        this.nodeFeatures = (Features)in.readValue(Features.class.getClassLoader());
        in.readMap(this.mElements, Element.class.getClassLoader());
        this.sortElements(this.mElements);
        in.readList(this.mAddedAppKeys, NodeKey.class.getClassLoader());
        this.mTimeStampInMillis = in.readLong();
        this.mSeqAuth = (SparseIntArrayParcelable)in.readParcelable(SparseIntArrayParcelable.class.getClassLoader());
        this.secureNetworkBeaconSupported = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.networkTransmitSettings = (NetworkTransmitSettings)in.readParcelable(NetworkTransmitSettings.class.getClassLoader());
        this.relaySettings = (RelaySettings)in.readParcelable(RelaySettings.class.getClassLoader());
        this.excluded = in.readInt() != 1;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uuid);
        dest.writeByte((byte)(this.isConfigured ? 1 : 0));
        dest.writeString(this.nodeName);
        dest.writeList(this.mAddedNetKeys);
        dest.writeByteArray(this.mFlags);
        dest.writeInt(this.unicastAddress);
        dest.writeByteArray(this.deviceKey);
        dest.writeValue((Object)this.ttl);
        dest.writeInt(this.sequenceNumber);
        dest.writeValue((Object)this.companyIdentifier);
        dest.writeValue((Object)this.productIdentifier);
        dest.writeValue((Object)this.versionIdentifier);
        dest.writeValue((Object)this.crpl);
        dest.writeValue((Object)this.nodeFeatures);
        dest.writeMap(this.mElements);
        dest.writeList(this.mAddedAppKeys);
        dest.writeLong(this.mTimeStampInMillis);
        dest.writeParcelable((Parcelable)this.mSeqAuth, flags);
        dest.writeValue((Object)this.secureNetworkBeaconSupported);
        dest.writeParcelable((Parcelable)this.networkTransmitSettings, flags);
        dest.writeParcelable((Parcelable)this.relaySettings, flags);
        dest.writeInt(this.excluded ? 1 : 0);
    }

    public int describeContents() {
        return 0;
    }

    public final Map<Integer, Element> getElements() {
        return this.mElements;
    }

    public final boolean hasUnicastAddress(int unicastAddress) {
        if (unicastAddress == this.getUnicastAddress()) {
            return true;
        }
        for (Element element : this.mElements.values()) {
            if (element.getElementAddress() != unicastAddress) continue;
            return true;
        }
        return false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setElements(Map<Integer, Element> elements) {
        this.mElements = elements;
    }

    public final byte[] getDeviceKey() {
        return this.deviceKey;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setDeviceKey(byte[] deviceKey) {
        this.deviceKey = deviceKey;
    }

    public final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public final Integer getCompanyIdentifier() {
        return this.companyIdentifier;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setCompanyIdentifier(Integer companyIdentifier) {
        this.companyIdentifier = companyIdentifier;
    }

    public final Integer getProductIdentifier() {
        return this.productIdentifier;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setProductIdentifier(Integer productIdentifier) {
        this.productIdentifier = productIdentifier;
    }

    public final Integer getVersionIdentifier() {
        return this.versionIdentifier;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setVersionIdentifier(Integer versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public final Integer getCrpl() {
        return this.crpl;
    }

    public final void setCrpl(Integer crpl) {
        this.crpl = crpl;
    }

    public final Features getNodeFeatures() {
        return this.nodeFeatures;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setNodeFeatures(Features features) {
        this.nodeFeatures = features;
    }

    public final List<NodeKey> getAddedNetKeys() {
        return Collections.unmodifiableList(this.mAddedNetKeys);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setAddedNetKeys(List<NodeKey> addedNetKeyIndexes) {
        this.mAddedNetKeys = addedNetKeyIndexes;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected final void setAddedNetKeyIndex(int index) {
        if (!MeshParserUtils.isNodeKeyExists(this.mAddedNetKeys, index)) {
            this.mAddedNetKeys.add(new NodeKey(index));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected final void updateAddedNetKey(int index) {
        NodeKey nodeKey = MeshParserUtils.getNodeKey(this.mAddedNetKeys, index);
        if (nodeKey != null) {
            nodeKey.setUpdated(true);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected final void updateNetKeyList(List<Integer> indexes) {
        this.mAddedNetKeys.clear();
        for (Integer index : indexes) {
            this.mAddedNetKeys.add(new NodeKey(index, false));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected final void removeAddedNetKeyIndex(int index) {
        for (int i = 0; i < this.mAddedNetKeys.size(); ++i) {
            int keyIndex = ((NodeKey)this.mAddedNetKeys.get(i)).getIndex();
            if (keyIndex != index) continue;
            this.mAddedNetKeys.remove(i);
            for (Element element : this.mElements.values()) {
                for (MeshModel model : element.getMeshModels().values()) {
                    ConfigurationServerModel configServerModel;
                    if (model.getModelId() != 0 || (configServerModel = (ConfigurationServerModel)model).getHeartbeatPublication() == null || configServerModel.getHeartbeatPublication().getNetKeyIndex() != index) continue;
                    configServerModel.setHeartbeatPublication(null);
                }
            }
            break;
        }
    }

    public final List<NodeKey> getAddedAppKeys() {
        return this.mAddedAppKeys;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setAddedAppKeys(List<NodeKey> addedAppKeyIndexes) {
        this.mAddedAppKeys = addedAppKeyIndexes;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected final void setAddedAppKeyIndex(int index) {
        if (!MeshParserUtils.isNodeKeyExists(this.mAddedAppKeys, index)) {
            this.mAddedAppKeys.add(new NodeKey(index));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected final void updateAddedAppKey(int index) {
        NodeKey nodeKey = MeshParserUtils.getNodeKey(this.mAddedNetKeys, index);
        if (nodeKey != null) {
            nodeKey.setUpdated(true);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected final void updateAppKeyList(int netKeyIndex, @NonNull List<Integer> indexes, @NonNull List<ApplicationKey> keyIndexes) {
        if (this.mAddedAppKeys.isEmpty()) {
            this.mAddedAppKeys.addAll(this.addAppKeyList(indexes, new ArrayList<NodeKey>()));
        } else {
            ArrayList<NodeKey> tempList = new ArrayList<NodeKey>(this.mAddedAppKeys);
            for (ApplicationKey applicationKey : keyIndexes) {
                if (applicationKey.getBoundNetKeyIndex() != netKeyIndex) continue;
                for (NodeKey nodeKey : this.mAddedAppKeys) {
                    if (nodeKey.getIndex() != applicationKey.getKeyIndex()) continue;
                    tempList.remove(nodeKey);
                }
            }
            this.mAddedAppKeys.clear();
            this.addAppKeyList(indexes, tempList);
            this.mAddedAppKeys.addAll(tempList);
        }
    }

    private List<NodeKey> addAppKeyList(@NonNull List<Integer> indexes, @NonNull ArrayList<NodeKey> tempList) {
        for (Integer index : indexes) {
            tempList.add(new NodeKey(index, false));
        }
        return tempList;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected final void removeAddedAppKeyIndex(int index) {
        for (int i = 0; i < this.mAddedAppKeys.size(); ++i) {
            int keyIndex = ((NodeKey)this.mAddedAppKeys.get(i)).getIndex();
            if (keyIndex != index) continue;
            this.mAddedAppKeys.remove(i);
            for (Map.Entry<Integer, Element> elementEntry : this.getElements().entrySet()) {
                Element element = elementEntry.getValue();
                block2: for (Map.Entry<Integer, MeshModel> modelEntry : element.getMeshModels().entrySet()) {
                    MeshModel model = modelEntry.getValue();
                    if (model == null) continue;
                    for (int j = 0; j < model.getBoundAppKeyIndexes().size(); ++j) {
                        int boundKeyIndex = model.getBoundAppKeyIndexes().get(j);
                        if (boundKeyIndex != index) continue;
                        model.mBoundAppKeyIndexes.remove(j);
                        continue block2;
                    }
                }
            }
            break;
        }
    }

    protected final void setCompositionData(@NonNull ConfigCompositionDataStatus configCompositionDataStatus) {
        this.companyIdentifier = configCompositionDataStatus.getCompanyIdentifier();
        this.productIdentifier = configCompositionDataStatus.getProductIdentifier();
        this.versionIdentifier = configCompositionDataStatus.getVersionIdentifier();
        this.crpl = configCompositionDataStatus.getCrpl();
        boolean relayFeatureSupported = configCompositionDataStatus.isRelayFeatureSupported();
        boolean proxyFeatureSupported = configCompositionDataStatus.isProxyFeatureSupported();
        boolean friendFeatureSupported = configCompositionDataStatus.isFriendFeatureSupported();
        boolean lowPowerFeatureSupported = configCompositionDataStatus.isLowPowerFeatureSupported();
        this.nodeFeatures = new Features(friendFeatureSupported ? 1 : 2, lowPowerFeatureSupported ? 1 : 2, proxyFeatureSupported ? 1 : 2, relayFeatureSupported ? 1 : 2);
        this.mElements.putAll(configCompositionDataStatus.getElements());
    }

    private int getFeatureState(Boolean feature) {
        if (feature != null && feature.booleanValue()) {
            return 2;
        }
        return 0;
    }

    protected final void setAppKeyBindStatus(@NonNull ConfigModelAppStatus configModelAppStatus) {
        Element element;
        if (configModelAppStatus.isSuccessful() && (element = (Element)this.mElements.get(configModelAppStatus.getElementAddress())) != null) {
            int modelIdentifier = configModelAppStatus.getModelIdentifier();
            MeshModel model = element.getMeshModels().get(modelIdentifier);
            if (model != null) {
                int appKeyIndex = configModelAppStatus.getAppKeyIndex();
                model.setBoundAppKeyIndex(appKeyIndex);
            }
        }
    }

    protected final void setAppKeyUnbindStatus(@NonNull ConfigModelAppStatus configModelAppStatus) {
        Element element;
        if (configModelAppStatus.isSuccessful() && (element = (Element)this.mElements.get(configModelAppStatus.getElementAddress())) != null) {
            int modelIdentifier = configModelAppStatus.getModelIdentifier();
            MeshModel model = element.getMeshModels().get(modelIdentifier);
            int appKeyIndex = configModelAppStatus.getAppKeyIndex();
            if (model != null) {
                model.removeBoundAppKeyIndex(appKeyIndex);
            }
        }
    }

    private void sortElements(Map<Integer, Element> unorderedElements) {
        Set<Integer> unorderedKeys = unorderedElements.keySet();
        ArrayList<Integer> orderedKeys = new ArrayList<Integer>(unorderedKeys);
        Collections.sort(orderedKeys);
        Iterator iterator = orderedKeys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            this.mElements.put(key, unorderedElements.get(key));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    void setSeqAuth(int src, int seqAuth) {
        this.mSeqAuth.put(src, seqAuth);
    }

    public Integer getSeqAuth(int src) {
        if (this.mSeqAuth.size() == 0) {
            return null;
        }
        return this.mSeqAuth.get(src);
    }

    public boolean isExist(int modelId) {
        for (Map.Entry elementEntry : this.mElements.entrySet()) {
            Element element = (Element)elementEntry.getValue();
            for (Map.Entry<Integer, MeshModel> modelEntry : element.getMeshModels().entrySet()) {
                MeshModel model = modelEntry.getValue();
                if (model == null || model.getModelId() != modelId) continue;
                return true;
            }
        }
        return false;
    }

    public int incrementSequenceNumber() {
        return ++this.sequenceNumber;
    }
}

