/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.data;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public abstract class GlobalAltitude {
    private static final short ENCODED_VALUE_NOT_CONFIGURED = Short.MAX_VALUE;
    private static final short ENCODED_VALUE_GREATER_THAN_OR_EQUAL_TO_32766 = 32766;

    private GlobalAltitude() {
    }

    public abstract short getEncodedValue();

    @NonNull
    public static GlobalAltitude of(short encodedValue) {
        if (encodedValue == Short.MAX_VALUE) {
            return new NotConfigured();
        }
        if (encodedValue == 32766) {
            return new GreaterThanOrEqualTo32766();
        }
        return new Coordinate(encodedValue);
    }

    @NonNull
    public static Coordinate encode(int position) {
        return new Coordinate(position);
    }

    @NonNull
    public static NotConfigured notConfigured() {
        return new NotConfigured();
    }

    @Nullable
    public Integer getDecodedPosition() {
        if (this instanceof Coordinate) {
            return ((Coordinate)this).getPosition();
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalAltitude that = (GlobalAltitude)o;
        return this.getEncodedValue() == that.getEncodedValue();
    }

    public final int hashCode() {
        return Integer.valueOf(this.getEncodedValue()).hashCode();
    }

    @NonNull
    public String toString() {
        return "GlobalAltitude." + this.getClass().getSimpleName() + " encodedValue: " + Integer.toHexString(this.getEncodedValue()) + " position: " + this.getDecodedPosition();
    }

    public static final class GreaterThanOrEqualTo32766
    extends GlobalAltitude {
        private GreaterThanOrEqualTo32766() {
        }

        @Override
        public short getEncodedValue() {
            return 32766;
        }
    }

    public static final class NotConfigured
    extends GlobalAltitude {
        private NotConfigured() {
        }

        @Override
        public short getEncodedValue() {
            return Short.MAX_VALUE;
        }
    }

    public static final class Coordinate
    extends GlobalAltitude {
        private final short encodedValue;

        private Coordinate(short encodedValue) {
            if (encodedValue == Short.MAX_VALUE) {
                throw new IllegalArgumentException("Encoded value can't be \u00b4NOT_CONFIGURED\u00b4 (0x7FFF)");
            }
            if (encodedValue == 32766) {
                throw new IllegalArgumentException("Encoded value can't be \u00b4GREATER_THAN_OR_EQUAL_TO_32766\u00b4 (0x7FFE)");
            }
            this.encodedValue = encodedValue;
        }

        private Coordinate(int value) {
            if (value < Short.MIN_VALUE || value > 32765) {
                throw new IllegalArgumentException("Altitude coordinate must be between -32768 and 32765 meters inclusive");
            }
            this.encodedValue = (short)value;
        }

        @Override
        public short getEncodedValue() {
            return this.encodedValue;
        }

        public int getPosition() {
            return this.encodedValue;
        }
    }
}

