/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.provisionerstates;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import no.nordicsemi.android.mesh.InternalTransportCallbacks;
import no.nordicsemi.android.mesh.MeshProvisioningStatusCallbacks;
import no.nordicsemi.android.mesh.provisionerstates.ProvisioningState;
import no.nordicsemi.android.mesh.provisionerstates.UnprovisionedMeshNode;

public class ProvisioningInviteState
extends ProvisioningState {
    private final String TAG = ProvisioningInviteState.class.getSimpleName();
    private final UnprovisionedMeshNode node;
    private final int attentionTimer;
    private final MeshProvisioningStatusCallbacks mStatusCallbacks;
    private final InternalTransportCallbacks mInternalTransportCallbacks;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ProvisioningInviteState(UnprovisionedMeshNode node, int attentionTimer, InternalTransportCallbacks internalTransportCallbacks, MeshProvisioningStatusCallbacks provisioningStatusCallbacks) {
        this.node = node;
        this.attentionTimer = attentionTimer;
        this.mStatusCallbacks = provisioningStatusCallbacks;
        this.mInternalTransportCallbacks = internalTransportCallbacks;
    }

    @Override
    public ProvisioningState.State getState() {
        return ProvisioningState.State.PROVISIONING_INVITE;
    }

    @Override
    public void executeSend() {
        byte[] invitePDU = this.createInvitePDU();
        this.node.setProvisioningInvitePdu(invitePDU);
        this.mStatusCallbacks.onProvisioningStateChanged(this.node, ProvisioningState.States.PROVISIONING_INVITE, invitePDU);
        this.mInternalTransportCallbacks.sendProvisioningPdu(this.node, invitePDU);
    }

    @Override
    public boolean parseData(@NonNull byte[] data) {
        return true;
    }

    private byte[] createInvitePDU() {
        byte[] data = new byte[]{3, 0, (byte)this.attentionTimer};
        return data;
    }
}

