/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.sensorutils;

public enum SensorSamplingFunction {
    UNSPECIFIED(0),
    INSTANTANEOUS(1),
    ARITHMETIC_MEAN(2),
    RMS(3),
    MAXIMUM(4),
    MINIMUM(5),
    ACCUMULATED(6),
    COUNT(7),
    UNKNOWN(8);

    private static final String TAG;
    private final byte samplingFunction;

    private SensorSamplingFunction(byte samplingFunction) {
        this.samplingFunction = samplingFunction;
    }

    public static SensorSamplingFunction from(byte samplingFunction) {
        switch (samplingFunction) {
            case 0: {
                return UNSPECIFIED;
            }
            case 1: {
                return INSTANTANEOUS;
            }
            case 2: {
                return ARITHMETIC_MEAN;
            }
            case 3: {
                return RMS;
            }
            case 4: {
                return MAXIMUM;
            }
            case 5: {
                return MINIMUM;
            }
            case 6: {
                return ACCUMULATED;
            }
            case 7: {
                return COUNT;
            }
        }
        return UNKNOWN;
    }

    public static String getSamplingFunction(SensorSamplingFunction type) {
        switch (type) {
            case UNSPECIFIED: {
                return "Unspecified";
            }
            case INSTANTANEOUS: {
                return "Instantaneous";
            }
            case ARITHMETIC_MEAN: {
                return "Arithmetic Mean";
            }
            case RMS: {
                return "RMS";
            }
            case MAXIMUM: {
                return "Maximum";
            }
            case MINIMUM: {
                return "Minimum";
            }
            case ACCUMULATED: {
                return "Accumulated";
            }
            case COUNT: {
                return "Count";
            }
        }
        return "Unknown";
    }

    public byte getSensorSamplingFunction() {
        return this.samplingFunction;
    }

    static {
        TAG = SensorSamplingFunction.class.getSimpleName();
    }
}

