/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import no.nordicsemi.android.mesh.ApplicationKey;
import no.nordicsemi.android.mesh.sensorutils.DeviceProperty;
import no.nordicsemi.android.mesh.transport.ApplicationMessage;
import no.nordicsemi.android.mesh.utils.SecureUtils;

public class SensorSettingGet
extends ApplicationMessage {
    private static final String TAG = SensorSettingGet.class.getSimpleName();
    private static final int OP_CODE = 33334;
    private final DeviceProperty propertyId;
    private final DeviceProperty sensorSettingPropertyId;

    public SensorSettingGet(@NonNull ApplicationKey appKey, @Nullable DeviceProperty propertyId, @Nullable DeviceProperty sensorSettingPropertyId) {
        super(appKey);
        this.propertyId = propertyId;
        this.sensorSettingPropertyId = sensorSettingPropertyId;
        this.assembleMessageParameters();
    }

    @Override
    public int getOpCode() {
        return 33334;
    }

    @Override
    void assembleMessageParameters() {
        this.mAid = SecureUtils.calculateK4(this.mAppKey.getKey());
        if (this.propertyId != null) {
            this.mParameters = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(this.propertyId.getPropertyId()).array();
        }
    }

    public DeviceProperty getPropertyId() {
        return this.propertyId;
    }

    public DeviceProperty getSensorSettingPropertyId() {
        return this.sensorSettingPropertyId;
    }
}

