/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.mesh.transport;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import no.nordicsemi.android.mesh.transport.AccessMessage;
import no.nordicsemi.android.mesh.transport.ApplicationStatusMessage;
import no.nordicsemi.android.mesh.utils.ArrayUtils;
import no.nordicsemi.android.mesh.utils.BitReader;

public class TimeStatus
extends ApplicationStatusMessage
implements Parcelable {
    private static final String TAG = TimeStatus.class.getSimpleName();
    private static final int OP_CODE = 93;
    private static final Parcelable.Creator<TimeStatus> CREATOR = new Parcelable.Creator<TimeStatus>(){

        public TimeStatus createFromParcel(Parcel in) {
            AccessMessage message = (AccessMessage)in.readParcelable(AccessMessage.class.getClassLoader());
            return new TimeStatus(message);
        }

        public TimeStatus[] newArray(int size) {
            return new TimeStatus[size];
        }
    };
    private Integer taiSeconds;
    private Byte subSecond;
    private Byte uncertainty;
    private Boolean timeAuthority;
    private Short utcDelta;
    private Byte timeZoneOffset;
    static final int TAI_SECONDS_BIT_SIZE = 40;
    static final int SUB_SECOND_BIT_SIZE = 8;
    static final int UNCERTAINTY_BIT_SIZE = 8;
    static final int TIME_AUTHORITY_BIT_SIZE = 1;
    static final int UTC_DELTA_BIT_SIZE = 15;
    static final int TIME_ZONE_OFFSET_BIT_SIZE = 8;
    static final int TIME_BIT_SIZE = 80;
    static final int TIME_ZONE_START_RANGE = 64;
    static final int UTC_DELTA_START_RANGE = 255;

    public TimeStatus(@NonNull AccessMessage message) {
        super(message);
        this.mParameters = message.getParameters();
        this.parseStatusParameters();
    }

    @Override
    void parseStatusParameters() {
        BitReader bitReader = new BitReader(ArrayUtils.reverseArray(this.mParameters));
        if (bitReader.bitsLeft() == 80) {
            this.timeZoneOffset = (byte)(bitReader.getBits(8) - 64);
            this.utcDelta = (short)(bitReader.getBits(15) - 255);
            this.timeAuthority = bitReader.getBits(1) == 1;
            this.uncertainty = (byte)bitReader.getBits(8);
            this.subSecond = (byte)bitReader.getBits(8);
            this.taiSeconds = bitReader.getBits(40);
            Log.v((String)TAG, (String)("Time status has taiSeconds: " + this.taiSeconds));
            Log.v((String)TAG, (String)("Time status has subSecond: " + this.subSecond));
            Log.v((String)TAG, (String)("Time status has uncertainty: " + this.uncertainty));
            Log.v((String)TAG, (String)("Time status has timeAuthority: " + this.timeAuthority));
            Log.v((String)TAG, (String)("Time status has utcDelta: " + this.utcDelta));
            Log.v((String)TAG, (String)("Time status has timeZoneOffset: " + this.timeZoneOffset));
        } else {
            Log.v((String)TAG, (String)"Time status has no values");
        }
    }

    @Override
    public int getOpCode() {
        return 93;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AccessMessage message = (AccessMessage)this.mMessage;
        dest.writeParcelable((Parcelable)message, flags);
    }

    @Nullable
    public Integer getTaiSeconds() {
        return this.taiSeconds;
    }

    @Nullable
    public Byte getSubSecond() {
        return this.subSecond;
    }

    @Nullable
    public Byte getUncertainty() {
        return this.uncertainty;
    }

    @Nullable
    public Boolean isTimeAuthority() {
        return this.timeAuthority;
    }

    @Nullable
    public Short getUtcDelta() {
        return this.utcDelta;
    }

    @Nullable
    public Byte getTimeZoneOffset() {
        return this.timeZoneOffset;
    }
}

